/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.CustomSampleScheme;
import net.refractions.udig.style.sld.editor.StyleThemePage;
import net.refractions.udig.style.sld.internal.Messages;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.SampleScheme;
import org.geotools.brewer.color.StyleGenerator;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

final class IPaletteCellEditor
implements ICellModifier {
    private final StyleThemePage styleThemePage;

    IPaletteCellEditor(StyleThemePage styleThemePage) {
        this.styleThemePage = styleThemePage;
    }

    public boolean canModify(Object element, String property) {
        if (property.equals("styleExpr")) {
            if (element instanceof Rule) {
                Rule rule = (Rule)element;
                if (rule.getName().startsWith("rule")) {
                    return !rule.hasElseFilter();
                }
                return false;
            }
        } else {
            if (property.equals("title")) {
                return true;
            }
            if (property == "colour") {
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (property.equals("styleExpr")) {
            if (element instanceof Rule) {
                Rule rule = (Rule)element;
                if (rule.hasElseFilter()) {
                    return "else";
                }
                return StyleGenerator.toStyleExpression((Filter)rule.getFilter());
            }
        } else if (property.equals("title")) {
            if (element instanceof Rule) {
                Rule rule = (Rule)element;
                return rule.getTitle();
            }
        } else if (property.equals("colour") && element instanceof Rule) {
            Rule rule = (Rule)element;
            Color colour = SLDs.toColor((String)SLDs.colors((Rule)rule)[0]);
            RGB rgb = new RGB(colour.getRed(), colour.getGreen(), colour.getBlue());
            return rgb;
        }
        return new Object[0];
    }

    public void modify(Object element, String property, Object value) {
        if (property.equals("styleExpr")) {
            if (element instanceof TreeItem) {
                String newExpr = (String)value;
                TreeItem item = (TreeItem)element;
                Object data = item.getData();
                this.styleThemePage.customBreak = null;
                int ruleIndex = Integer.parseInt(((Rule)data).getName().substring(4)) - 1;
                List rules = this.styleThemePage.getFTS().rules();
                ArrayList<Double> min = new ArrayList<Double>();
                ArrayList<Double> max = new ArrayList<Double>();
                Set[] values = new Set[rules.size()];
                int i = 0;
                while (i < rules.size()) {
                    String thisExpr = null;
                    if (i == ruleIndex) {
                        thisExpr = newExpr;
                    } else if (((Rule)rules.get(i)).getFilter() != null) {
                        thisExpr = StyleGenerator.toStyleExpression((Filter)((Rule)rules.get(i)).getFilter());
                    }
                    if (thisExpr != null) {
                        if (StyleGenerator.isRanged((String)thisExpr)) {
                            String[] minMax = thisExpr.split("\\.\\.");
                            min.add(new Double(minMax[0]));
                            max.add(new Double(minMax[1]));
                        } else {
                            String[] myvalues = thisExpr.split(",");
                            values[i] = new HashSet();
                            int j = 0;
                            while (j < myvalues.length) {
                                values[i].add(myvalues[j].trim());
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                this.styleThemePage.customBreak = min.size() > 0 ? new RangedClassifier((Comparable[])min.toArray(new Double[min.size()]), (Comparable[])max.toArray(new Double[max.size()])) : new ExplicitClassifier(values);
                Combo breaks = this.styleThemePage.getCombo(3);
                String[] allBreaks = breaks.getItems();
                int hasCustom = -1;
                int i2 = 0;
                while (i2 < allBreaks.length) {
                    if (allBreaks[i2].equalsIgnoreCase(Messages.StyleEditor_theme_custom)) {
                        hasCustom = i2;
                        break;
                    }
                    ++i2;
                }
                if (hasCustom > -1) {
                    breaks.select(hasCustom);
                } else {
                    breaks.add(Messages.StyleEditor_theme_custom);
                    breaks.select(allBreaks.length);
                }
                if (this.styleThemePage.inputsValid()) {
                    this.styleThemePage.generateTheme();
                }
            }
        } else if (property.equals("title")) {
            if (element instanceof TreeItem) {
                TreeItem item = (TreeItem)element;
                Object data = item.getData();
                if (data instanceof Rule) {
                    Rule rule = (Rule)data;
                    if (rule.getTitle().equals(value)) {
                        return;
                    }
                    rule.setTitle(value.toString());
                }
                this.styleThemePage.treeViewer.refresh();
            }
        } else if (property.equals("colour")) {
            if (value == null) {
                return;
            }
            if (element instanceof Item) {
                this.modifyColourColumn(element, value);
            }
        }
    }

    private void modifyColourColumn(Object element, Object value) {
        Rule rule;
        Symbolizer[] symb;
        Item item = (Item)element;
        Object data = item.getData();
        Expression newColorExpr = null;
        Expression oldColorExpr = null;
        Color newColor = null;
        StyleBuilder sb = new StyleBuilder();
        if (value instanceof RGB) {
            RGB rgb = (RGB)value;
            newColor = new Color(rgb.red, rgb.green, rgb.blue);
            String htmlColor = SLDs.toHTMLColor((Color)newColor);
            newColorExpr = sb.literalExpression(htmlColor);
        }
        if (data instanceof Rule && (symb = (rule = (Rule)data).getSymbolizers()).length == 1) {
            PolygonSymbolizer ps;
            if (symb[0] instanceof PolygonSymbolizer) {
                ps = (PolygonSymbolizer)symb[0];
                Fill fill = ps.getFill();
                oldColorExpr = fill.getColor();
                fill.setColor(newColorExpr);
            } else if (symb[0] instanceof PointSymbolizer) {
                ps = (PointSymbolizer)symb[0];
                Mark[] marks = ps.getGraphic().getMarks();
                if (marks != null && marks.length > 0) {
                    oldColorExpr = marks[0].getFill().getColor();
                    marks[0].getFill().setColor(newColorExpr);
                }
            } else if (symb[0] instanceof LineSymbolizer) {
                ps = (LineSymbolizer)symb[0];
                Stroke stroke = ps.getStroke();
                oldColorExpr = stroke.getColor();
                stroke.setColor(newColorExpr);
            }
            if (newColorExpr.equals(oldColorExpr)) {
                return;
            }
            if (this.styleThemePage.customPalette == null) {
                int numClasses = new Integer(this.styleThemePage.getCombo(2).getText());
                BrewerPalette pal = (BrewerPalette)((StructuredSelection)this.styleThemePage.paletteTable.getSelection()).getFirstElement();
                this.styleThemePage.customPalette = new BrewerPalette();
                PaletteSuitability suitability = new PaletteSuitability();
                SampleScheme newScheme = new SampleScheme();
                int maxColors = pal.getMaxColors();
                Color[] allColorsArray = pal.getColors();
                if (maxColors == Integer.MAX_VALUE) {
                    maxColors = numClasses;
                    newScheme = new CustomSampleScheme(maxColors);
                }
                if (allColorsArray.length == 0) {
                    allColorsArray = pal.getColors(maxColors);
                }
                Color[] colors = new Color[maxColors];
                ArrayList<Color> allColors = new ArrayList<Color>();
                int i = 0;
                while (i < allColorsArray.length) {
                    allColors.add(allColorsArray[i]);
                    ++i;
                }
                String unknown = "?";
                int i2 = 0;
                while (i2 < maxColors) {
                    if (i2 > 0) {
                        int[] scheme = new int[i2 + 1];
                        int j = 0;
                        while (j < i2 + 1) {
                            scheme[j] = j;
                            ++j;
                        }
                        newScheme.setSampleScheme(i2 + 1, scheme);
                        try {
                            suitability.setSuitability(i2 + 1, new String[]{unknown, unknown, unknown, unknown, unknown, unknown});
                        }
                        catch (Exception e) {
                            SLDPlugin.log("setSuitability() failed", e);
                        }
                    }
                    if (i2 < numClasses) {
                        colors[i2] = pal.getColor(i2, numClasses);
                        allColors.remove(colors[i2]);
                    } else {
                        colors[i2] = (Color)allColors.remove(0);
                    }
                    ++i2;
                }
                this.styleThemePage.customPalette.setPaletteSuitability(suitability);
                this.styleThemePage.customPalette.setColors(colors);
                this.styleThemePage.customPalette.setColorScheme(newScheme);
                this.styleThemePage.customPalette.setName(Messages.StyleEditor_theme_custom);
                this.styleThemePage.customPalette.setDescription(Messages.StyleEditor_theme_custom_desc);
                this.styleThemePage.customPalette.setType(pal.getType());
                if (!this.styleThemePage.getBrewer().hasPalette(Messages.StyleEditor_theme_custom)) {
                    this.styleThemePage.getBrewer().registerPalette(this.styleThemePage.customPalette);
                }
            }
            Color[] colors = this.styleThemePage.customPalette.getColors();
            int expectedIndex = -1;
            if (rule.getName().toLowerCase().startsWith("rule")) {
                expectedIndex = Integer.parseInt(rule.getName().substring(4)) - 1;
            }
            int actualIndex = -1;
            int i = 0;
            while (i < colors.length) {
                if (sb.literalExpression(SLDs.toHTMLColor((Color)colors[i])).equals(oldColorExpr)) {
                    actualIndex = i;
                    if (expectedIndex == i) break;
                }
                ++i;
            }
            if (actualIndex == -1) {
                SLDPlugin.log("color match unsuccessful... " + oldColorExpr + " vs " + newColorExpr, null);
                return;
            }
            colors[actualIndex] = newColor;
            this.styleThemePage.customPalette.setColors(colors);
            this.styleThemePage.paletteTable.setInput((Object)this.styleThemePage.getBrewer());
            this.styleThemePage.paletteTable.setSelection((ISelection)new StructuredSelection((Object)this.styleThemePage.customPalette));
        }
        this.styleThemePage.treeViewer.refresh();
    }
}

