/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.editor.EditorNode;
import net.refractions.udig.style.sld.editor.StyleConfiguratorExtensionProcessor;
import net.refractions.udig.style.sld.editor.StyleEditorPageExtensionProcessor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.PlatformUI;

public class EditorPageManager
implements IExtensionChangeHandler {
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_LABEL = "label";
    public static final String PL_KEYWORDS = "keywords";
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    EditorNode root = new EditorNode("");
    String separator;

    public EditorPageManager() {
        this('.');
    }

    public EditorPageManager(char separatorChar) {
        this.separator = new String(new char[]{separatorChar});
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                if (event.getExtensionDeltas("net.refractions.udig.style.sld.StyleEditorPage", EditorPageManager.PL_KEYWORDS).length > 0) {
                    Iterator<?> j = EditorPageManager.this.getElements(1).iterator();
                    while (j.hasNext()) {
                        ((EditorNode)j.next()).clearKeywords();
                    }
                }
            }
        });
    }

    public void addPages(Collection<?> pageContributions) {
        for (Object next : pageContributions) {
            if (!(next instanceof EditorNode)) continue;
            EditorNode node = (EditorNode)next;
            this.addToRoot(node);
            this.registerNode(node);
        }
    }

    public void registerNode(EditorNode node) {
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(node.getConfigurationElement().getDeclaringExtension(), (Object)node, 2);
        EditorNode[] subNodes = node.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            this.registerNode(subNodes[i]);
            ++i;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            boolean classMissing;
            EditorNode node = null;
            boolean nameMissing = elements[i].getAttribute(ATT_NAME) == null;
            String id = elements[i].getAttribute(ATT_ID);
            boolean bl = classMissing = this.getClassValue(elements[i], ATT_CLASS) == null;
            if (!nameMissing && id != null && !classMissing) {
                node = new EditorNode(id, elements[i]);
            }
            if (node != null) {
                this.registerNode(node);
                String category = node.getCategory();
                if (category == null) {
                    this.addToRoot(node);
                } else {
                    EditorNode parent = null;
                    for (EditorNode element : this.getElements(1)) {
                        if (!category.equals(element.getId())) continue;
                        parent = element;
                        break;
                    }
                    if (parent == null) {
                        this.addToRoot(node);
                    } else {
                        parent.add(node);
                    }
                }
            }
            ++i;
        }
    }

    public String getClassValue(IConfigurationElement configElement, String classAttributeName) {
        String className = configElement.getAttribute(classAttributeName);
        if (className != null) {
            return className;
        }
        IConfigurationElement[] candidateChildren = configElement.getChildren(classAttributeName);
        if (candidateChildren.length == 0) {
            return null;
        }
        return candidateChildren[0].getAttribute(ATT_CLASS);
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("net.refractions.udig.style.sld.StyleEditorPage");
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof EditorNode) {
                EditorNode node = (EditorNode)objects[i];
                node.disposeResources();
                this.deepRemove(this.getRoot(), node);
            }
            ++i;
        }
    }

    private boolean deepRemove(EditorNode parent, EditorNode nodeToRemove) {
        if (parent == nodeToRemove && parent == this.getRoot()) {
            this.removeAll();
            return true;
        }
        if (parent.remove(nodeToRemove)) {
            return true;
        }
        EditorNode[] subNodes = parent.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            if (this.deepRemove(subNodes[i], nodeToRemove)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean addTo(String path, EditorNode node) {
        EditorNode target = this.find(path);
        if (target == null) {
            return false;
        }
        target.add(node);
        return true;
    }

    public void addToRoot(EditorNode node) {
        Assert.isNotNull((Object)node);
        this.root.add(node);
    }

    protected void buildSequence(EditorNode node, List<EditorNode> sequence, int order) {
        if (order == 0) {
            sequence.add(node);
        }
        EditorNode[] subnodes = node.getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.buildSequence(subnodes[i], sequence, order);
            ++i;
        }
        if (order == 1) {
            sequence.add(node);
        }
    }

    public EditorNode find(String path) {
        return this.find(path, this.root);
    }

    protected EditorNode find(String path, EditorNode top) {
        Assert.isNotNull((Object)path);
        StringTokenizer stok = new StringTokenizer(path, this.separator);
        EditorNode node = top;
        while (stok.hasMoreTokens()) {
            String id = stok.nextToken();
            if ((node = node.findSubNode(id)) != null) continue;
            return null;
        }
        if (node == top) {
            return null;
        }
        return node;
    }

    public List<?> getElements(int order) {
        Assert.isTrue((order == 0 || order == 1 ? 1 : 0) != 0, (String)"invalid traversal order");
        ArrayList<EditorNode> sequence = new ArrayList<EditorNode>();
        EditorNode[] subnodes = this.getRoot().getSubNodes();
        int i = 0;
        while (i < subnodes.length) {
            this.buildSequence(subnodes[i], sequence, order);
            ++i;
        }
        return sequence;
    }

    public EditorNode getRoot() {
        return this.root;
    }

    public EditorNode remove(String path) {
        Assert.isNotNull((Object)path);
        int index = path.lastIndexOf(this.separator);
        if (index == -1) {
            return this.root.remove(path);
        }
        Assert.isTrue((index < path.length() - 1 ? 1 : 0) != 0, (String)"Path can not end with a dot");
        String parentPath = path.substring(0, index);
        String id = path.substring(index + 1);
        EditorNode parentNode = this.find(parentPath);
        if (parentNode == null) {
            return null;
        }
        return parentNode.remove(id);
    }

    public boolean remove(EditorNode node) {
        Assert.isNotNull((Object)node);
        return this.root.remove(node);
    }

    public void removeAll() {
        this.root = new EditorNode("");
    }

    public EditorNode[] getRootSubNodes() {
        return this.getRoot().getSubNodes();
    }

    public boolean hasNode(String nodeId) {
        EditorNode[] nodes = this.getRoot().getSubNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getId().equalsIgnoreCase(nodeId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean meetsRequirement(ILayer selectedLayer, String id, IConfigurationElement element, EditorNode node) {
        String requires;
        block6: {
            requires = element.getAttribute("requires");
            Object classInstance = EditorNode.createExtension(element, ATT_CLASS);
            if (!AdapterUtil.instance.canAdaptTo(requires, (Object)selectedLayer, classInstance.getClass().getClassLoader())) break block6;
            SLDPlugin.trace("skipped " + id, null);
            return true;
        }
        try {
            Object requiredClass = element.createExecutableExtension("requires");
            if (AdapterUtil.instance.canAdaptTo(requires, (Object)selectedLayer, requiredClass.getClass().getClassLoader())) {
                return true;
            }
        }
        catch (Exception exception) {
            try {
                SLDPlugin.trace("skipped " + id, null);
            }
            catch (Exception exception2) {
                SLDPlugin.log("extProcConfigurator skipped " + id + " (couldn't find " + requires + ")", null);
            }
        }
        return false;
    }

    public static EditorPageManager loadManager(Plugin plugin, ILayer selectedLayer) {
        EditorPageManager[] manager = new EditorPageManager[]{new EditorPageManager('.')};
        StyleEditorPageExtensionProcessor extProcPage = new StyleEditorPageExtensionProcessor(manager, selectedLayer);
        ExtensionPointUtil.process((Plugin)plugin, (String)"net.refractions.udig.style.sld.StyleEditorPage", (ExtensionPointProcessor)extProcPage);
        StyleConfiguratorExtensionProcessor extProcConfigurator = new StyleConfiguratorExtensionProcessor(manager, selectedLayer);
        ExtensionPointUtil.process((Plugin)plugin, (String)"net.refractions.udig.style.styleConfigurator", (ExtensionPointProcessor)extProcConfigurator);
        return manager[0];
    }
}

