/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld.editor;

import java.awt.Color;
import net.refractions.udig.style.sld.editor.CustomSampleScheme;
import net.refractions.udig.style.sld.editor.CustomUnknownPaletteSuitability;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.brewer.color.PaletteSuitability;
import org.geotools.brewer.color.PaletteType;
import org.geotools.brewer.color.SampleScheme;

public class CustomDynamicPalette
extends BrewerPalette {
    private int[][] current = null;
    private int[][] rainbow;
    private int[][] elevation;
    private int[][] grey;
    private CustomSampleScheme sampler;
    private PaletteType type;

    public CustomDynamicPalette(TABLE tableType) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 255;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArray3[2] = 255;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 255;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 255;
        nArray5[2] = 255;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 255;
        nArrayArray[5] = nArray6;
        this.rainbow = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray7 = new int[3];
        nArray7[1] = 191;
        nArray7[2] = 191;
        nArrayArray2[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 255;
        nArrayArray2[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 255;
        nArray9[1] = 255;
        nArrayArray2[2] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 255;
        nArray10[1] = 127;
        nArrayArray2[3] = nArray10;
        nArrayArray2[4] = new int[]{191, 127, 63};
        nArrayArray2[5] = new int[]{20, 21, 20};
        this.elevation = nArrayArray2;
        this.grey = new int[][]{new int[3], {255, 255, 255}};
        switch (tableType) {
            case RAINBOW: {
                this.setName("Dynamic Rainbow");
                this.setDescription("A rainbow colors palette dynamically adapting to the number of classes");
                this.current = this.rainbow;
                break;
            }
            case ELEVATION: {
                this.setName("Dynamic Elevation");
                this.setDescription("An elevation colors palette dynamically adapting to the number of classes");
                this.current = this.elevation;
                break;
            }
            case GREY: {
                this.setName("Dynamic Greyscale");
                this.setDescription("A greyscale palette dynamically adapting to the number of classes");
                this.current = this.grey;
                break;
            }
        }
    }

    public CustomDynamicPalette(String name, String descripiton, Color[] colors) {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 255;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArray3[2] = 255;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[2] = 255;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 255;
        nArray5[2] = 255;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 255;
        nArrayArray[5] = nArray6;
        this.rainbow = nArrayArray;
        int[][] nArrayArray2 = new int[6][];
        int[] nArray7 = new int[3];
        nArray7[1] = 191;
        nArray7[2] = 191;
        nArrayArray2[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 255;
        nArrayArray2[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 255;
        nArray9[1] = 255;
        nArrayArray2[2] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[0] = 255;
        nArray10[1] = 127;
        nArrayArray2[3] = nArray10;
        nArrayArray2[4] = new int[]{191, 127, 63};
        nArrayArray2[5] = new int[]{20, 21, 20};
        this.elevation = nArrayArray2;
        this.grey = new int[][]{new int[3], {255, 255, 255}};
        this.setName(name);
        this.setDescription(descripiton);
        this.current = new int[colors.length][3];
        int i = 0;
        while (i < colors.length) {
            this.current[i][0] = colors[i].getRed();
            this.current[i][1] = colors[i].getGreen();
            this.current[i][2] = colors[i].getBlue();
            ++i;
        }
    }

    public PaletteType getType() {
        return ColorBrewer.ALL;
    }

    public void setType(PaletteType type) {
        this.type = type;
    }

    public Color getColor(int index, int length) {
        return this.getColors(length)[index];
    }

    public int getMaxColors() {
        return Integer.MAX_VALUE;
    }

    public int getMinColors() {
        return 6;
    }

    public Color[] getColors(int length) {
        if (length < 2) {
            length = 2;
        }
        if (length == Integer.MAX_VALUE) {
            length = 20;
        }
        return this.interpolateColors(length);
    }

    private Color[] interpolateColors(int classes) {
        Color[] colors = new Color[classes];
        float factor = (float)(this.current.length - 1) / (float)classes;
        int i = 0;
        while (i < classes) {
            int b;
            int g;
            int r;
            float y = factor * (float)i;
            int floor = (int)Math.floor(y);
            int ceil = (int)Math.ceil(y);
            if (ceil - floor == 0) {
                r = this.current[floor][0];
                g = this.current[floor][1];
                b = this.current[floor][2];
            } else {
                float r1 = this.current[floor][0];
                float g1 = this.current[floor][1];
                float b1 = this.current[floor][2];
                float r2 = this.current[ceil][0];
                float g2 = this.current[ceil][1];
                float b2 = this.current[ceil][2];
                r = (int)(r2 - ((float)ceil - y) * (r2 - r1) / (float)(ceil - floor));
                g = (int)(g2 - ((float)ceil - y) * (g2 - g1) / (float)(ceil - floor));
                b = (int)(b2 - ((float)ceil - y) * (b2 - b1) / (float)(ceil - floor));
            }
            colors[i] = new Color(r, g, b);
            ++i;
        }
        int length = colors.length;
        this.sampler = new CustomSampleScheme(length);
        int j = 2;
        while (j < length) {
            int[] list = new int[j];
            int k = 0;
            while (k < list.length) {
                list[k] = k;
                ++k;
            }
            this.sampler.setSampleScheme(j, list);
            ++j;
        }
        return colors;
    }

    public PaletteSuitability getPaletteSuitability() {
        return CustomUnknownPaletteSuitability.getInstance();
    }

    public void setPaletteSuitability(PaletteSuitability suitability) {
    }

    public SampleScheme getColorScheme() {
        return this.sampler;
    }

    public void setColorScheme(CustomSampleScheme scheme) {
        this.sampler = scheme;
    }

    public static enum TABLE {
        RAINBOW,
        GREY,
        ELEVATION;

    }
}

