/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.AbstractSimpleConfigurator;
import net.refractions.udig.style.sld.SLDContentManager;
import net.refractions.udig.style.sld.simple.ScaleViewer;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.coverage.grid.GridCoverage;

public class SimpleGridConfigurator
extends AbstractSimpleConfigurator {
    ScaleViewer minScale = new ScaleViewer(0);
    ScaleViewer maxScale = new ScaleViewer(1);
    SelectionListener synchronize = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            SimpleGridConfigurator.this.synchronize();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SimpleGridConfigurator.this.synchronize();
        }
    };

    public SimpleGridConfigurator() {
        this.minScale.addListener(this.synchronize);
        this.maxScale.addListener(this.synchronize);
    }

    @Override
    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(GridCoverage.class) || aLayer.hasResource(WebMapServer.class);
    }

    @Override
    protected void refresh() {
        Style style = this.getStyle();
        SLD.rasterSymbolizer((Style)style);
        Rule r = style.getFeatureTypeStyles()[0].getRules()[0];
        double minScaleDen = r.getMinScaleDenominator();
        double maxScaleDen = r.getMaxScaleDenominator();
        this.minScale.setScale(minScaleDen, Math.round(this.getLayer().getMap().getViewportModel().getScaleDenominator()));
        this.maxScale.setScale(maxScaleDen, Math.round(this.getLayer().getMap().getViewportModel().getScaleDenominator()));
    }

    @Override
    public void createControl(Composite parent) {
        this.setLayout(parent);
        KeyAdapter adapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.character == '\r') {
                    SimpleGridConfigurator.this.makeActionDoStuff();
                }
            }
        };
        this.minScale.createControl(parent, (KeyListener)adapter);
        this.maxScale.createControl(parent, (KeyListener)adapter);
    }

    @Override
    public void synchronize() {
        StyleBlackboard styleBlackboard = (StyleBlackboard)this.getStyleBlackboard();
        Style style = (Style)styleBlackboard.get("net.refractions.udig.style.sld");
        if (style == null) {
            style = this.createDefaultStyle();
            this.getStyleBlackboard().put("net.refractions.udig.style.sld", (Object)style);
            ((StyleBlackboard)this.getStyleBlackboard()).setSelected(new String[]{"net.refractions.udig.style.sld"});
        }
        Rule ruleToUpdate = SLDs.getRasterSymbolizerRule((Style)style);
        ruleToUpdate.setMinScaleDenominator(this.minScale.getScale());
        ruleToUpdate.setMaxScaleDenominator(this.maxScale.getScale());
    }

    public Style createDefaultStyle() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        StyleBuilder styleBuilder = new StyleBuilder(styleFactory);
        RasterSymbolizer rasterSymbolizer = styleFactory.createRasterSymbolizer();
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{rasterSymbolizer});
        Style style = styleBuilder.createStyle();
        SLDContentManager sldContentManager = new SLDContentManager(styleBuilder, style);
        sldContentManager.addSymbolizer((Symbolizer)rasterSymbolizer);
        FeatureTypeStyle fts = sldContentManager.getDefaultFeatureTypeStyle();
        fts.setFeatureTypeName("Feature");
        fts.setName("simple");
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "simple"});
        fts.addRule(rule);
        style.addFeatureTypeStyle(fts);
        style.setName("simpleStyle");
        return style;
    }
}

