/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.sld;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.style.sld.SLDContentManager;
import net.refractions.udig.style.sld.SLDEditorPart;
import net.refractions.udig.style.sld.SLDPlugin;
import net.refractions.udig.style.sld.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PageBook;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.Layer;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeatureType;

public class SLDConfigurator
extends IStyleConfigurator {
    SLDContentManager sldContentManager;
    PageBook editorBook;
    Composite blank;
    List<SLDEditorMenuAction> toolbarItems;
    SortedMap<Class, List<SLDEditorPart>> classToEditors;

    public boolean canStyle(net.refractions.udig.project.internal.Layer layer) {
        if (layer.hasResource(FeatureSource.class)) {
            return true;
        }
        return layer.hasResource(Layer.class);
    }

    public void init() {
        this.sldContentManager = new SLDContentManager();
        Comparator<Class> compare = new Comparator<Class>(){

            @Override
            public int compare(Class a, Class b) {
                return a.getSimpleName().compareTo(b.getSimpleName());
            }
        };
        this.classToEditors = new TreeMap<Class, List<SLDEditorPart>>(compare);
        ExtensionPointProcessor p = new ExtensionPointProcessor(){

            public void process(IExtension ext, IConfigurationElement element) throws Exception {
                try {
                    Class contentClass;
                    ArrayList<SLDEditorPart> list;
                    SLDEditorPart editor = (SLDEditorPart)element.createExecutableExtension("class");
                    editor.setPluginId(element.getNamespace());
                    editor.setLabel(element.getAttribute("label"));
                    ImageDescriptor image = editor.createImageDescriptor();
                    if (image != null) {
                        editor.setImageDescriptor(image);
                    }
                    if ((list = (ArrayList<SLDEditorPart>)SLDConfigurator.this.classToEditors.get(contentClass = editor.getContentType())) == null) {
                        list = new ArrayList<SLDEditorPart>();
                        SLDConfigurator.this.classToEditors.put(contentClass, list);
                    }
                    list.add(editor);
                }
                catch (Exception e) {
                    SLDPlugin.log(null, e);
                }
            }
        };
        ExtensionPointUtil.process((Plugin)SLDPlugin.getDefault(), (String)"net.refractions.udig.style.sld.sldEditorPart", (ExtensionPointProcessor)p);
    }

    public void createControl(Composite parent) {
        this.createToolbarItems();
        this.editorBook = new PageBook(parent, 0);
        this.editorBook.setVisible(true);
        this.blank = new Composite((Composite)this.editorBook, 0);
        this.editorBook.showPage((Control)this.blank);
        for (List<SLDEditorPart> parts : this.classToEditors.values()) {
            for (SLDEditorPart part : parts) {
                try {
                    part.createControl(this.editorBook);
                }
                catch (Throwable t) {
                    SLDPlugin.log(null, t);
                }
            }
        }
    }

    protected void refresh() {
        net.refractions.udig.project.internal.Layer layer = this.getLayer();
        if (!this.canStyle(layer)) {
            throw new IllegalStateException("Hey I can't style " + layer);
        }
        Style style = (Style)this.getStyleBlackboard().get("net.refractions.udig.style.sld");
        if (style == null) {
            style = SLDContent.createDefaultStyle();
            this.getStyleBlackboard().put("net.refractions.udig.style.sld", (Object)style);
        }
        this.sldContentManager.init(SLDContent.getStyleBuilder(), style);
        if (layer.getSchema() != null) {
            SimpleFeatureType featureType = layer.getSchema();
            featureType.getName().getLocalPart();
            this.sldContentManager.getDefaultFeatureTypeStyle().setFeatureTypeName("Feature");
        }
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.markDirty();
        tbm.update(true);
        this.getViewSite().getActionBars().updateActionBars();
        IContributionItem[] iContributionItemArray = tbm.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            ActionContributionItem action = (ActionContributionItem)item;
            action.getAction().setEnabled(action.getAction().isEnabled());
            ++n2;
        }
        SLDEditorPart editor = (SLDEditorPart)this.editorBook.getData();
        List<Class> supported = SLD.getSupportedTypes((ILayer)layer);
        if (editor != null && supported.contains(editor.getContentType())) {
            this.initEditor(editor);
            editor.reset();
            return;
        }
        for (Class type : this.classToEditors.keySet()) {
            Iterator iterator;
            if (!supported.contains(type) || !(iterator = ((List)this.classToEditors.get(type)).iterator()).hasNext()) continue;
            SLDEditorPart part = (SLDEditorPart)iterator.next();
            this.initEditor(part);
            part.reset();
            this.editorBook.setData((Object)part);
            this.editorBook.showPage((Control)part.getPage());
            part.getPage().setVisible(true);
            return;
        }
        this.editorBook.showPage((Control)this.blank);
    }

    protected void createToolbarItems() {
        this.toolbarItems = new ArrayList<SLDEditorMenuAction>();
        for (Class contentClass : this.classToEditors.keySet()) {
            List editors = (List)this.classToEditors.get(contentClass);
            if (editors == null || editors.isEmpty()) continue;
            editors.add(new SLDDisableEditorPart(contentClass));
            SLDEditorMenuAction action = new SLDEditorMenuAction(editors);
            this.toolbarItems.add(action);
        }
        Collections.sort(this.toolbarItems);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        for (SLDEditorMenuAction item : this.toolbarItems) {
            tbm.add((IAction)item);
        }
    }

    void initEditor(SLDEditorPart editor) {
        Class symbolizerType = editor.getContentType();
        Object content = this.sldContentManager.getSymbolizer(symbolizerType);
        if (content == null) {
            this.sldContentManager.addSymbolizer(symbolizerType);
            content = this.sldContentManager.getSymbolizer(symbolizerType);
        }
        editor.setStyleBuilder(this.sldContentManager.getStyleBuilder());
        editor.setLayer(this.getLayer());
        editor.setContent(content);
    }

    class SLDDisableEditorPart
    extends SLDEditorPart {
        private Class<Symbolizer> contentType;

        public SLDDisableEditorPart(Class<Symbolizer> contentType) {
            this.contentType = contentType;
            this.setImageDescriptor(SLD.createDisabledImageDescriptor(contentType));
            this.setLabel(Messages.SLDConfigurator_disable);
        }

        @Override
        public void init() {
        }

        @Override
        public Class getContentType() {
            return this.contentType;
        }

        @Override
        protected Control createPartControl(Composite parent) {
            return new Composite(parent, 0);
        }

        @Override
        public void reset() {
            SLDConfigurator.this.sldContentManager.removeSymbolizer(this.contentType);
        }
    }

    class SLDEditorAction
    extends Action {
        SLDEditorMenuAction parent;
        SLDEditorPart editor;

        public SLDEditorAction(SLDEditorPart editor, SLDEditorMenuAction parent) {
            this.editor = editor;
            this.parent = parent;
            this.setImageDescriptor(this.getImageDescriptor(editor));
            this.setText(editor.getLabel());
        }

        public void run() {
            this.parent.setImageDescriptor(this.getImageDescriptor());
            if (this.editor instanceof SLDDisableEditorPart) {
                Class symbolizer = this.editor.getContentType();
                SLDConfigurator.this.sldContentManager.removeSymbolizer(symbolizer);
            } else {
                SLDConfigurator.this.initEditor(this.editor);
            }
            this.editor.reset();
            SLDConfigurator.this.editorBook.setData((Object)this.editor);
            Composite page = this.editor.getPage();
            SLDConfigurator.this.editorBook.setVisible(true);
            SLDConfigurator.this.editorBook.showPage((Control)page);
        }

        protected ImageDescriptor getImageDescriptor(SLDEditorPart editor1) {
            return editor1.getImageDescriptor();
        }
    }

    class SLDEditorMenuAction
    extends Action
    implements IMenuCreator,
    Comparable<SLDEditorMenuAction> {
        List<SLDEditorPart> editors;
        Menu menu;

        public SLDEditorMenuAction(List<SLDEditorPart> editors) {
            this.editors = editors;
            this.setMenuCreator(this);
            this.setImageDescriptor(editors.get(0).getImageDescriptor());
        }

        public Class getContentType() {
            if (this.editors == null || this.editors.isEmpty()) {
                return null;
            }
            return this.editors.get(0).getContentType();
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            for (SLDEditorPart editor : this.editors) {
                SLDEditorAction action = new SLDEditorAction(editor, this);
                this.addActionToMenu(this.menu, action);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        @Override
        public int compareTo(SLDEditorMenuAction other) {
            return this.editors.get(0).getContentType().getName().compareTo(other.editors.get(0).getContentType().getName());
        }

        public boolean isEnabled() {
            net.refractions.udig.project.internal.Layer layer = SLDConfigurator.this.getLayer();
            if (layer == null) {
                return false;
            }
            return SLD.getSupportedTypes((ILayer)layer).contains(this.getContentType());
        }
    }
}

