/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.filter;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.ui.PlatformGIS;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FilterStyle {
    private boolean aoiFilter;
    private Filter filter;

    public FilterStyle() {
    }

    public FilterStyle(Object value) {
        if (value != null) {
            if (value instanceof FilterStyle) {
                FilterStyle copy = (FilterStyle)value;
                this.aoiFilter = copy.aoiFilter;
                this.filter = copy.filter;
            } else if (value instanceof Filter) {
                this.filter = (Filter)value;
            } else if (value instanceof Query) {
                Query query = (Query)value;
                this.filter = query.getFilter();
            }
        }
    }

    public FilterStyle(FilterStyle copy) {
        this.aoiFilter = copy.aoiFilter;
        this.filter = copy.filter;
    }

    public FilterStyle(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter value) {
        this.filter = value;
    }

    public boolean isAoiFilter() {
        return this.aoiFilter;
    }

    public void setAoiFilter(boolean aoiFilter) {
        this.aoiFilter = aoiFilter;
    }

    public Filter toFilter(FeatureType schema) {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Filter filter = this.getFilter();
        if (filter == Filter.INCLUDE) {
            filter = null;
        }
        if (this.isAoiFilter()) {
            try {
                IAOIService aoiService = PlatformGIS.getAOIService();
                ReferencedEnvelope extent = aoiService.getExtent();
                if (extent != null) {
                    CoordinateReferenceSystem crs = extent.getCoordinateReferenceSystem();
                    Geometry geometry = aoiService.getGeometry();
                    CoordinateReferenceSystem dataCRS = schema.getCoordinateReferenceSystem();
                    if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)dataCRS)) {
                        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)dataCRS);
                        geometry = JTS.transform((Geometry)geometry, (MathTransform)transform);
                    }
                    String the_geom = schema.getGeometryDescriptor().getName().getLocalPart();
                    Intersects spatialFilter = ff.intersects((Expression)ff.property(the_geom), (Expression)ff.literal((Object)geometry));
                    if (filter != null) {
                        return ff.and(filter, (Filter)spatialFilter);
                    }
                    return spatialFilter;
                }
            }
            catch (MismatchedDimensionException mismatchedDimensionException) {
            }
            catch (TransformException transformException) {
            }
            catch (FactoryException factoryException) {}
        }
        if (filter != null) {
            return filter;
        }
        return Filter.INCLUDE;
    }
}

