/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class RuntimeFieldEditor
extends FieldEditor {
    public static final String WORKSPACE_PATH = "WORKSPACE_PATH";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MEMORY = "MEMORY";
    public static final String PROXYSET = "http.proxySet";
    public static final String PROXYHOST = "http.proxyHost";
    public static final String PROXYPORT = "http.proxyPort";
    public static final String PROXYNONHOSTS = "http.nonProxyHosts";
    private Text wkspaceText;
    private Combo langCombo;
    private Text memoryText;
    private String workspacePath;
    private static String[] langArray = new String[]{"de", "en", "es", "eu", "fr", "it", "ko"};
    private IPreferenceStore preferenceStore = UiPlugin.getDefault().getPreferenceStore();
    private Text proxyHostText;
    private Text proxyPortText;
    private Button proxyButton;
    private Text proxyNonHostText;

    public RuntimeFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void doStore() {
        if (this.checkValues()) {
            this.saveValues();
        }
    }

    protected void doLoadDefault() {
        this.wkspaceText.setText(this.getWorkspacePath());
        this.memoryText.setText(String.valueOf(this.getCurrentHeap()));
    }

    protected void doLoad() {
        String workSpacePath = this.preferenceStore.getString(WORKSPACE_PATH);
        if (workSpacePath == null || workSpacePath.equals("")) {
            workSpacePath = this.getWorkspacePath();
        }
        this.wkspaceText.setText(workSpacePath);
        this.memoryText.setText(String.valueOf(this.getCurrentHeap()));
        String lang = this.preferenceStore.getString(LANGUAGE);
        if (lang == null || lang.equals("")) {
            Locale locale = Locale.getDefault();
            lang = locale.getLanguage();
        }
        int i = 0;
        while (i < langArray.length) {
            if (lang.equals(langArray[i])) {
                this.langCombo.select(i);
            }
            ++i;
        }
        String host = this.preferenceStore.getString(PROXYHOST);
        String port = this.preferenceStore.getString(PROXYPORT);
        String nonhost = this.preferenceStore.getString(PROXYNONHOSTS);
        String setStr = this.preferenceStore.getString(PROXYSET);
        if (host.equals("") || this.proxyPortText.equals("")) {
            try {
                Properties proxySettings = UiPlugin.getProxySettings();
                host = proxySettings.getProperty(PROXYHOST);
                port = proxySettings.getProperty(PROXYPORT);
                nonhost = proxySettings.getProperty(PROXYNONHOSTS);
                if (host == null) {
                    host = "";
                }
                if (port == null) {
                    port = "";
                }
                if (nonhost == null) {
                    nonhost = "";
                }
            }
            catch (IOException e) {
                UiPlugin.log("Problem reading proxy settings.", e);
            }
        }
        if (setStr.equals("")) {
            setStr = "false";
        }
        boolean set = Boolean.parseBoolean(setStr);
        this.proxyButton.setSelection(set);
        this.proxyHostText.setText(host);
        this.proxyPortText.setText(port);
        this.proxyNonHostText.setText(nonhost);
    }

    protected void doFillIntoGrid(final Composite parent, int numColumns) {
        this.setPreferenceStore(this.preferenceStore);
        this.workspacePath = this.getWorkspacePath();
        Label wkspaceLabel = new Label(parent, 0);
        wkspaceLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        wkspaceLabel.setText(Messages.RuntimeFieldEditor_workspace_path);
        this.wkspaceText = new Text(parent, 18436);
        this.wkspaceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.wkspaceText.setText(this.workspacePath);
        Button wkspaceButton = new Button(parent, 8);
        wkspaceButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        wkspaceButton.setText("...");
        wkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fileDialog = new DirectoryDialog(parent.getShell(), 4096);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    RuntimeFieldEditor.this.wkspaceText.setText("");
                } else {
                    RuntimeFieldEditor.this.wkspaceText.setText(path);
                }
            }
        });
        Label langLabel = new Label(parent, 0);
        langLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        langLabel.setText(Messages.RuntimeFieldEditor_locale);
        this.langCombo = new Combo(parent, 12);
        GridData gD = new GridData(4, 0x1000000, true, false);
        gD.horizontalSpan = 2;
        this.langCombo.setLayoutData((Object)gD);
        this.langCombo.setItems(langArray);
        Label memoryLabel = new Label(parent, 0);
        memoryLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        memoryLabel.setText(Messages.RuntimeFieldEditor_maxheap);
        this.memoryText = new Text(parent, 18436);
        GridData gD2 = new GridData(4, 0x1000000, true, false);
        gD2.horizontalSpan = 2;
        this.memoryText.setLayoutData((Object)gD2);
        long maxHeapMemory = this.getCurrentHeap();
        this.memoryText.setText(String.valueOf(maxHeapMemory));
        Group proxyGroup = new Group(parent, 0);
        GridData proxyGD = new GridData(4, 4, true, false);
        proxyGD.horizontalSpan = 3;
        proxyGroup.setLayoutData((Object)proxyGD);
        proxyGroup.setLayout((Layout)new GridLayout(2, false));
        proxyGroup.setText("Proxy");
        this.proxyButton = new Button((Composite)proxyGroup, 32);
        GridData proxyButtonGD = new GridData(1, 0x1000000, false, false);
        proxyButtonGD.horizontalSpan = 2;
        this.proxyButton.setLayoutData((Object)proxyButtonGD);
        this.proxyButton.setText("Enable/Disable proxy");
        Label proxyHostLabel = new Label((Composite)proxyGroup, 0);
        proxyHostLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        proxyHostLabel.setText("Proxy Server");
        this.proxyHostText = new Text((Composite)proxyGroup, 18436);
        this.proxyHostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.proxyHostText.setText("");
        Label proxyPortLabel = new Label((Composite)proxyGroup, 0);
        proxyPortLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        proxyPortLabel.setText("Proxy Port");
        this.proxyPortText = new Text((Composite)proxyGroup, 18436);
        this.proxyPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.proxyPortText.setText("");
        Label proxyNonHostLabel = new Label((Composite)proxyGroup, 0);
        proxyNonHostLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        proxyNonHostLabel.setText("Proxy Bypass Servers");
        this.proxyNonHostText = new Text((Composite)proxyGroup, 18436);
        this.proxyNonHostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.proxyNonHostText.setText("");
        Button restartButton = new Button(parent, 8);
        restartButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        restartButton.setText(Messages.RuntimeFieldEditor_restart);
        restartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeFieldEditor.this.saveValues();
                RuntimeFieldEditor.this.restart();
            }
        });
    }

    private String getWorkspacePath() {
        URL instanceUrl = Platform.getInstanceLocation().getURL();
        return new File(instanceUrl.getFile()).toString();
    }

    private long getCurrentHeap() {
        try {
            int maxHeapSize = UiPlugin.getMaxHeapSize();
            return maxHeapSize;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        }
    }

    private boolean checkValues() {
        String wksPath = this.wkspaceText.getText();
        File f = new File(wksPath);
        if (!f.exists()) {
            MessageDialog.openError((Shell)this.wkspaceText.getShell(), (String)Messages.RuntimeFieldEditor_error, (String)Messages.RuntimeFieldEditor_path_not_existing);
            return false;
        }
        String memory = this.memoryText.getText();
        int mem = 0;
        try {
            mem = Integer.parseInt(memory);
        }
        catch (Exception exception) {}
        if (mem < 64) {
            MessageDialog.openError((Shell)this.wkspaceText.getShell(), (String)Messages.RuntimeFieldEditor_error, (String)Messages.RuntimeFieldEditor_memory_positive);
            return false;
        }
        return true;
    }

    private void saveValues() {
        if (this.checkValues()) {
            this.preferenceStore.setValue(WORKSPACE_PATH, this.wkspaceText.getText());
            this.preferenceStore.setValue(LANGUAGE, this.langCombo.getText());
            this.preferenceStore.setValue(MEMORY, this.memoryText.getText());
            this.preferenceStore.setValue(PROXYNONHOSTS, this.proxyNonHostText.getText());
            this.preferenceStore.setValue(PROXYHOST, this.proxyHostText.getText());
            this.preferenceStore.setValue(PROXYPORT, this.proxyPortText.getText());
            this.preferenceStore.setValue(PROXYSET, String.valueOf(this.proxyButton.getSelection()));
        }
        this.writeSettings();
    }

    private void restart() {
        this.writeSettings();
        PlatformUI.getWorkbench().restart();
    }

    private void writeSettings() {
        try {
            String maxHeadSize = this.memoryText.getText();
            UiPlugin.setMaxHeapSize(maxHeadSize);
            if (this.proxyButton.getSelection()) {
                String host = this.proxyHostText.getText();
                String nonhost = this.proxyNonHostText.getText();
                String port = this.proxyPortText.getText();
                UiPlugin.setProxy(host, port, nonhost);
            } else {
                UiPlugin.setProxy(null, null, null);
            }
            URL configUrlURL = Platform.getConfigurationLocation().getURL();
            String configFilePath = String.valueOf(configUrlURL.getFile()) + File.separator + "config.ini";
            File configFile = new File(configFilePath);
            Properties properties = new Properties();
            properties.load(new FileInputStream(configFile));
            String path = this.wkspaceText.getText();
            path = new File(path).toURI().toURL().toExternalForm();
            path = path.replaceAll("%20", " ");
            properties.setProperty("osgi.instance.area.default", path);
            properties.setProperty("osgi.nl", this.langCombo.getText());
            Set<Object> keySet = properties.keySet();
            BufferedWriter bW = null;
            try {
                bW = new BufferedWriter(new FileWriter(configFile));
                for (Object key : keySet) {
                    String keyStr = (String)key;
                    if (keyStr.equals("eof")) continue;
                    bW.write(keyStr);
                    bW.write("=");
                    bW.write(properties.getProperty(keyStr));
                    bW.write("\n");
                }
                bW.write("eof=eof");
            }
            finally {
                bW.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = "An error occurred while setting preferences.";
            ExceptionDetailsDialog.openError(null, message, 4, "net.refractions.udig.ui", e);
        }
    }

    protected void adjustForNumColumns(int numColumns) {
    }
}

