/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.preferences;

import java.nio.charset.Charset;
import net.refractions.udig.ui.CharsetSelectionDialog;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class CharSetFieldEditor
extends FieldEditor {
    private Text text;

    public CharSetFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.text.getText());
    }

    protected void doLoadDefault() {
        this.text.setText(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doLoad() {
        this.text.setText(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doFillIntoGrid(final Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        label.setLayoutData((Object)new GridData());
        this.text = new Text(parent, 2048);
        GridData layout = new GridData(768);
        layout.horizontalSpan = numColumns - 2;
        this.text.setLayoutData((Object)layout);
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData());
        button.setText(Messages.CharSetFieldEditor_select);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CharsetSelectionDialog dialog = new CharsetSelectionDialog(parent.getShell(), false, CharSetFieldEditor.this.text.getText());
                dialog.open();
                CharSetFieldEditor.this.text.setText(((Charset)dialog.getFirstResult()).name());
                CharSetFieldEditor.this.store();
            }
        });
    }

    protected void adjustForNumColumns(int numColumns) {
    }
}

