/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.refractions.udig.ui.palette.Friendly;

public class Scheme {
    public final List<Color> colors;
    public final EnumSet<Friendly> good;
    public final EnumSet<Friendly> doubtful;

    public Scheme(Color[] scheme) {
        this(scheme, new Friendly[]{Friendly.CRT, Friendly.LCD}, new Friendly[]{Friendly.COLORBLIND, Friendly.PROJECTOR});
    }

    public Scheme(Color[] scheme, Friendly[] good) {
        this(scheme, good, new Friendly[0]);
    }

    public Scheme(List<Color> scheme) {
        this(scheme, EnumSet.of(Friendly.CRT, Friendly.LCD), EnumSet.of(Friendly.COLORBLIND, Friendly.PROJECTOR));
    }

    public Scheme(List<Color> scheme, EnumSet<Friendly> good, EnumSet<Friendly> doubtful) {
        this.colors = scheme;
        this.good = good;
        this.doubtful = doubtful;
    }

    public Scheme(Color[] scheme, Friendly[] good, Friendly[] doubtful) {
        this(Scheme.colors(scheme), Scheme.friendly(good), Scheme.friendly(doubtful));
    }

    public Scheme(int[][] scheme, int[] friendly) {
        this(Scheme.colors(scheme), Scheme.good(friendly), Scheme.doubtful(friendly));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<Scheme");
        if (this.colors.size() != 0) {
            if (this.colors.size() == 1) {
                buf.append(this.colors.get(0));
            } else {
                buf.append("(");
                buf.append(this.colors.size());
                buf.append("(");
                buf.append(this.colors.get(0));
                buf.append("..");
                buf.append(this.colors.get(this.colors.size() - 1));
            }
        }
        if (!this.good.isEmpty()) {
            buf.append(" good=");
            buf.append(this.good);
        }
        if (!this.doubtful.isEmpty()) {
            buf.append(" doubtful=");
            buf.append(this.doubtful);
        }
        buf.append(">");
        return buf.toString();
    }

    private static EnumSet<Friendly> friendly(Friendly[] good) {
        if (good != null) {
            return EnumSet.copyOf(Arrays.asList(good));
        }
        return (EnumSet)Collections.unmodifiableSet(EnumSet.noneOf(Friendly.class));
    }

    private static List<Color> colors(Color[] scheme) {
        return Collections.unmodifiableList(Arrays.asList(scheme));
    }

    private static EnumSet<Friendly> good(int[] friendly) {
        EnumSet<Friendly> set = EnumSet.noneOf(Friendly.class);
        int i = 0;
        Friendly[] friendlyArray = Friendly.values();
        int n = friendlyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Friendly f = friendlyArray[n2];
            if (friendly[i] == 1) {
                set.add(f);
            }
            ++i;
            ++n2;
        }
        return set;
    }

    private static EnumSet<Friendly> doubtful(int[] friendly) {
        EnumSet<Friendly> set = EnumSet.noneOf(Friendly.class);
        int i = 0;
        Friendly[] friendlyArray = Friendly.values();
        int n = friendlyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Friendly f = friendlyArray[n2];
            if (friendly[i] == 0) {
                set.add(f);
            }
            ++i;
            ++n2;
        }
        return set;
    }

    private static List<Color> colors(int[][] scheme) {
        ArrayList<Color> list = new ArrayList<Color>();
        int R = 0;
        int G = 1;
        int B = 2;
        int[][] nArray = scheme;
        int n = scheme.length;
        int n2 = 0;
        while (n2 < n) {
            int[] rgb = nArray[n2];
            list.add(new Color(rgb[R], rgb[G], rgb[B]));
            ++n2;
        }
        return Collections.unmodifiableList(list);
    }
}

