/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.util.EnumSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

public enum Friendly {
    COLORBLIND,
    PHOTOCOPY,
    PROJECTOR,
    LCD,
    CRT,
    PRINT;

    public final InternationalString description;
    public final InternationalString display = Friendly.string(String.valueOf(this.name()) + ".display");
    private static ResourceBundle bundle;

    static {
        bundle = null;
    }

    private Friendly() {
        this.description = Friendly.string(String.valueOf(this.name()) + ".description");
    }

    private static InternationalString string(String key) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("net.refractions.udig.ui.palette.friendly");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            return new SimpleInternationalString(bundle.getString(key));
        }
        catch (MissingResourceException missingResourceException) {
            return new SimpleInternationalString(key);
        }
        catch (NullPointerException nullPointerException) {
            return new SimpleInternationalString("!" + key + "!");
        }
    }

    public static EnumSet<Friendly> parse(String text) {
        EnumSet<Friendly> set = EnumSet.noneOf(Friendly.class);
        if (text == null) {
            return set;
        }
        String[] stringArray = text.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            if ((symbol = symbol.trim()).length() != 0) {
                try {
                    set.add(Friendly.valueOf(symbol.toUpperCase()));
                }
                catch (IllegalArgumentException badSymbol) {
                    System.out.println(badSymbol);
                }
            }
            ++n2;
        }
        return set;
    }
}

