/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.internal.ui.UiPlugin;
import org.geotools.brewer.color.BrewerPalette;

public class ColourScheme {
    private int itemCount = 0;
    private int colourCount = 0;
    private boolean canAutoSize = true;
    private HashMap<String, Integer> idMap;
    private HashMap<Integer, Integer> colourMap;
    private BrewerPalette palette;

    public ColourScheme(BrewerPalette palette, int itemSize) {
        this.colourMap = new HashMap();
        this.idMap = new HashMap();
        this.setColourPalette(palette);
        this.setSizeScheme(itemSize);
    }

    public ColourScheme(BrewerPalette palette, int itemSize, int paletteSize) {
        this.colourMap = new HashMap();
        this.idMap = new HashMap();
        this.setColourPalette(palette);
        this.setSizePalette(paletteSize);
        this.setSizeScheme(itemSize);
    }

    public ColourScheme(BrewerPalette palette, HashMap<Integer, Integer> colourMap, HashMap<String, Integer> idMap, int itemSize, int paletteSize) {
        this.idMap = idMap;
        this.colourMap = colourMap;
        this.palette = palette;
        this.colourCount = paletteSize;
        this.itemCount = itemSize;
    }

    public static ColourScheme getDefault(BrewerPalette palette) {
        return new ColourScheme(palette, 0);
    }

    public void setColourPalette(BrewerPalette palette) {
        this.palette = palette;
    }

    public boolean getAutoSizing() {
        return this.canAutoSize;
    }

    public void setAutoSizing(boolean auto) {
        this.canAutoSize = auto;
    }

    public void setSizeScheme(int numItems) {
        if (this.canAutoSize) {
            this.setSizePalette(numItems);
        }
        if (numItems > this.itemCount) {
            int i = this.itemCount;
            while (i < numItems) {
                int newColourIndex = this.getNextColourIndex();
                this.colourMap.put(i, newColourIndex);
                ++this.itemCount;
                ++i;
            }
        } else {
            int i = numItems;
            while (i < this.itemCount) {
                if (this.colourMap.containsKey(i)) {
                    this.colourMap.remove(i);
                }
                ++i;
            }
            this.itemCount = numItems;
        }
    }

    public void setSizePalette(int numColours) {
        int minSize = this.palette.getMinColors();
        int maxSize = this.palette.getMaxColors();
        if (numColours > maxSize) {
            numColours = maxSize;
        }
        if (numColours < minSize) {
            numColours = minSize;
        }
        this.colourCount = numColours;
    }

    private int getLargestColourIndex(int numItems) {
        int largestIndex = -1;
        int i = 0;
        while (i < numItems) {
            int thisIndex;
            if (this.colourMap.containsKey(i) && (thisIndex = this.colourMap.get(i).intValue()) > largestIndex) {
                largestIndex = i;
            }
            ++i;
        }
        return largestIndex;
    }

    public int getMinColours() {
        int minColours = this.palette.getMinColors();
        int colourWidth = this.getLargestColourIndex(this.itemCount) + 1;
        if (colourWidth > minColours) {
            return colourWidth;
        }
        return minColours;
    }

    private int getNextColourIndex() {
        int i = 0;
        while (i < this.colourCount) {
            boolean hasColour = false;
            int j = 0;
            while (j < this.itemCount) {
                if (this.colourMap.containsKey(j) && this.colourMap.get(j) == i) {
                    hasColour = true;
                    break;
                }
                ++j;
            }
            if (!hasColour) {
                return i;
            }
            ++i;
        }
        int[] instances = new int[this.colourCount];
        int i2 = 0;
        while (i2 < this.itemCount) {
            if (this.colourMap.containsKey(i2)) {
                int n = this.colourMap.get(i2);
                instances[n] = instances[n] + 1;
            }
            ++i2;
        }
        int leastInstances = -1;
        int index = 0;
        int i3 = 0;
        while (i3 < this.colourCount) {
            if (instances[i3] < leastInstances || leastInstances == -1) {
                leastInstances = instances[i3];
                index = i3;
            }
            ++i3;
        }
        return index;
    }

    public int getSizePalette() {
        return this.colourCount;
    }

    public int getSizeScheme() {
        return this.itemCount;
    }

    public boolean alignScheme(List<Color> colours) {
        int size = colours.size();
        if (this.itemCount < size) {
            this.setSizeScheme(size);
        }
        int i = 0;
        while (i < size) {
            if (!this.getColour(i).equals(colours.get(i))) {
                boolean consistent = false;
                Color[] paletteColours = this.palette.getColors(this.colourCount);
                int j = 0;
                while (j < this.colourCount) {
                    if (paletteColours[j].equals(colours.get(i))) {
                        consistent = true;
                        this.colourMap.remove(i);
                        this.colourMap.put(i, j);
                        break;
                    }
                    ++j;
                }
                if (!consistent) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public Color getNextAvailableColour(List<Color> colours) {
        boolean[] inUse = new boolean[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            inUse[i] = false;
            ++i;
        }
        for (Color colour : colours) {
            HashMap<Integer, Integer> clrMap = this.getColourMap();
            int index = 0;
            while (index < this.itemCount) {
                int i2;
                Color aColour;
                if (clrMap.containsKey(index) && (aColour = this.palette.getColor(i2 = clrMap.get(index).intValue(), this.colourCount)).equals(colour)) {
                    inUse[index] = true;
                }
                ++index;
            }
        }
        i = 0;
        while (i < this.itemCount) {
            if (!inUse[i]) {
                return this.getColour(i);
            }
            ++i;
        }
        if (this.palette.getMaxColors() == this.colourCount && this.colourCount <= this.itemCount) {
            return this.getColour(this.itemCount);
        }
        this.setSizeScheme(this.itemCount + 1);
        return this.getNextAvailableColour(colours);
    }

    public Color getColour(int index) {
        int i;
        HashMap<Integer, Integer> clrMap;
        if (index >= this.itemCount) {
            this.setSizeScheme(index + 1);
        }
        if ((clrMap = this.getColourMap()).containsKey(index)) {
            i = clrMap.get(index);
        } else {
            UiPlugin.log("ColourScheme getColour(" + index + ") exceeded bounds", null);
            i = 0;
        }
        return this.palette.getColor(i, this.colourCount);
    }

    public Color[] getAllColours() {
        return this.palette.getColors(this.colourCount);
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof ColourScheme)) {
            return false;
        }
        ColourScheme schemeToCompare = (ColourScheme)other;
        if (schemeToCompare.getSizePalette() != this.colourCount) {
            return false;
        }
        if (schemeToCompare.getSizeScheme() != this.itemCount) {
            return false;
        }
        if (!schemeToCompare.getColourPalette().getName().equals(this.palette.getName())) {
            return false;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (!schemeToCompare.getColourMap().get(i).equals(this.colourMap.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.colourCount;
        result = 31 * result + this.itemCount;
        if (this.palette != null && this.palette.getName() != null) {
            result = 31 * result + this.palette.hashCode();
        }
        int i = 0;
        while (i < this.itemCount) {
            Integer integer = this.colourMap.get(i);
            result = 31 * result + (integer == null ? 0 : integer.hashCode());
            ++i;
        }
        return result;
    }

    public BrewerPalette getColourPalette() {
        return this.palette;
    }

    public HashMap<Integer, Integer> getColourMap() {
        HashMap<Integer, Integer> colourMapping = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < this.itemCount) {
            if (this.colourMap.containsKey(i)) {
                colourMapping.put(i, this.colourMap.get(i));
            } else if (i > this.colourCount) {
                colourMapping.put(i, i % this.colourCount);
            } else {
                colourMapping.put(i, i);
            }
            ++i;
        }
        return colourMapping;
    }

    public HashMap<String, Integer> getIdMap() {
        return this.idMap;
    }

    public void setColourMap(HashMap<Integer, Integer> colourMap) {
        this.colourMap = colourMap;
    }

    public void swapColours(int firstIndex, int secondIndex) {
        if (firstIndex >= this.colourCount) {
            this.setSizeScheme(firstIndex + 1);
        }
        if (secondIndex >= this.colourCount) {
            this.setSizeScheme(secondIndex + 1);
        }
        int tempVal = this.colourMap.get(firstIndex);
        this.colourMap.put(firstIndex, this.colourMap.get(secondIndex));
        this.colourMap.put(secondIndex, tempVal);
    }

    public Color addItem() {
        int size = this.getSizeScheme();
        return this.getColour(size);
    }

    public Color addItem(String id) {
        int size = this.getSizeScheme();
        Color color = this.getColour(size);
        int index = this.indexOf(color);
        if (index > -1) {
            this.idMap.put(id, index);
        }
        return color;
    }

    public void addItem(Color color) {
    }

    public int indexOf(String id) {
        if (this.idMap.containsKey(id)) {
            return this.idMap.get(id);
        }
        return -1;
    }

    private int indexOf(Color color) {
        for (Integer i : this.colourMap.keySet()) {
            if (i >= this.itemCount || !color.equals(this.getColour(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean removeItem(String id) {
        if (this.idMap.containsKey(id)) {
            int index = this.indexOf(id);
            this.idMap.remove(id);
            return this.removeItem(index);
        }
        return false;
    }

    public boolean removeItem(String id, Color colour) {
        Set<Map.Entry<String, Integer>> entries = this.idMap.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            if (!id.equals(entry.getKey()) || !colour.equals(this.getColour(entry.getValue()))) continue;
            entries.remove(entry);
            return true;
        }
        return false;
    }

    public boolean removeItem(int index) {
        if (index < 0) {
            return false;
        }
        if (this.idMap.containsValue(index)) {
            for (Map.Entry<String, Integer> entry : this.idMap.entrySet()) {
                if (!entry.getValue().equals(index)) continue;
                this.idMap.remove(entry.getKey());
            }
        }
        if (this.colourMap.containsKey(index)) {
            this.colourMap.remove(index);
            --this.itemCount;
        }
        return true;
    }
}

