/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.palette;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.SortedSet;
import java.util.TreeSet;
import net.refractions.udig.ui.palette.Palette;
import net.refractions.udig.ui.palette.Scheme;
import net.refractions.udig.ui.palette.SchemeType;
import org.opengis.util.InternationalString;

public final class ColorBrewer {
    public static final Palette BLUES = ColorBrewer.pal("blues");
    public static final Palette BUGN = ColorBrewer.pal("BuGn");
    public static final Palette BRGB = ColorBrewer.pal("BrBG");

    static final SortedSet<Palette> sequential() {
        return ColorBrewer.set(EnumSet.of(SchemeType.SEQUENTIAL));
    }

    static final SortedSet<Palette> qualitative() {
        return ColorBrewer.set(EnumSet.of(SchemeType.QUALITATIVE));
    }

    static final SortedSet<Palette> diverging() {
        return ColorBrewer.set(EnumSet.of(SchemeType.DIVERGING));
    }

    static final Palette sequential(Color color) {
        Palette best = null;
        double distance = Double.MAX_VALUE;
        for (Palette pal : ColorBrewer.sequential()) {
            double score = 0.0;
            for (Scheme scheme : pal.contents) {
                for (Color c : scheme.colors) {
                    score += ColorBrewer.distance(color, c);
                }
            }
            if (!(score < distance)) continue;
            best = pal;
            distance = score;
        }
        return best;
    }

    public static final double distance(Color a, Color b) {
        if (a.equals(b)) {
            return 0.0;
        }
        float[] hsb1 = Color.RGBtoHSB(a.getRed(), a.getGreen(), a.getBlue(), null);
        float[] hsb2 = Color.RGBtoHSB(b.getRed(), b.getGreen(), b.getBlue(), null);
        return Math.max(Math.abs(hsb1[0] - hsb2[0]), Math.max(Math.abs(hsb1[1] - hsb2[1]), Math.abs(hsb1[2] - hsb2[2])));
    }

    private static SortedSet<Palette> set(EnumSet<SchemeType> types) {
        TreeSet<Palette> sorted = new TreeSet<Palette>(new Comparator<Palette>(){

            @Override
            public int compare(Palette a, Palette b) {
                return a.name.compareTo((InternationalString)b.name);
            }
        });
        Field[] fieldArray = ColorBrewer.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType() == Palette.class) {
                try {
                    Palette pal = (Palette)field.get(null);
                    if (pal != null && types.contains((Object)pal.type)) {
                        sorted.add(pal);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
        return sorted;
    }

    static final Palette pal(String palette) {
        try {
            return new Palette(String.valueOf(palette) + ".pal");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

