/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.IOpFilterListener;
import net.refractions.udig.ui.operations.OpFilter;
import net.refractions.udig.ui.operations.PropertyValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;

class OpFilterPropertyValueCondition
implements OpFilter {
    private static final PropertyValue FAILED_TO_LOAD = new PropertyValue<Object>(){

        @Override
        public void addListener(IOpFilterListener listener) {
        }

        @Override
        public boolean canCacheResult() {
            return true;
        }

        @Override
        public boolean isBlocking() {
            return false;
        }

        @Override
        public boolean isTrue(Object object, String value) {
            return true;
        }

        @Override
        public void removeListener(IOpFilterListener listener) {
        }
    };
    private final String equalsValue;
    private final IConfigurationElement propertyElement;
    private final String targetObject;
    private volatile PropertyValue propertyValueInstance;
    private Class<?> targetClass;

    public OpFilterPropertyValueCondition(IConfigurationElement propertyElement2, String targetObject2, String equalsValue2) {
        this.equalsValue = equalsValue2;
        this.propertyElement = propertyElement2;
        this.targetObject = targetObject2;
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)object;
            for (Object element : selection) {
                if (this.accepted(element)) continue;
                return false;
            }
            return true;
        }
        return this.accepted(object);
    }

    private boolean accepted(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getTargetObject(object) != null && !this.getTargetObject(object).isAssignableFrom(object.getClass())) {
            return false;
        }
        PropertyValue v = this.getValue();
        if (v == null) {
            return false;
        }
        return v.isTrue(object, this.equalsValue);
    }

    private PropertyValue getValue() {
        if (this.propertyValueInstance == null) {
            try {
                String classAttribute = this.propertyElement.getAttribute("class");
                this.propertyValueInstance = classAttribute == null || classAttribute.trim().length() == 0 ? (PropertyValue)this.propertyElement.createExecutableExtension("value") : (PropertyValue)this.propertyElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                this.propertyValueInstance = FAILED_TO_LOAD;
                UiPlugin.log("Error in extension: " + this.propertyElement.getDeclaringExtension().getUniqueIdentifier(), e);
                return null;
            }
        }
        return this.propertyValueInstance;
    }

    private Class<? extends Object> getTargetObject(Object object) {
        if (this.targetClass == null) {
            try {
                this.targetClass = object.getClass().getClassLoader().loadClass(this.targetObject);
            }
            catch (ClassNotFoundException e) {
                UiPlugin.log("", e);
                return null;
            }
        }
        return this.targetClass;
    }

    @Override
    public void addListener(IOpFilterListener listener) {
        this.getValue().addListener(listener);
    }

    @Override
    public boolean canCacheResult() {
        return this.getValue().canCacheResult();
    }

    @Override
    public boolean isBlocking() {
        return this.getValue().isBlocking();
    }

    @Override
    public void removeListener(IOpFilterListener listener) {
        this.getValue().removeListener(listener);
    }

    public String toString() {
        if (this.propertyValueInstance == null) {
            return "PropertyValue " + this.propertyElement.getAttribute("class");
        }
        return this.propertyValueInstance.getClass().getSimpleName();
    }
}

