/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import java.util.List;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.CompoundContributionItem;

public class OpCategoryContributionItem
extends CompoundContributionItem
implements IExecutableExtension {
    private IContributionItem[] items;
    private String categoryId;

    public OpCategoryContributionItem() {
    }

    public OpCategoryContributionItem(String id) {
        super(id);
        this.categoryId = id;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.items == null) {
            OperationMenuFactory factory = UiPlugin.getDefault().getOperationMenuFactory();
            List<IContributionItem> list = factory.createContributionItems(this.categoryId);
            if (list.size() == 0) {
                this.items = new IContributionItem[0];
            } else if (list.size() == 1) {
                this.items = list.toArray(new IContributionItem[list.size()]);
            } else {
                OperationCategory category = factory.findCategory(this.categoryId);
                MenuManager subMenu = new MenuManager(category.getMenuText(), category.getId());
                for (IContributionItem item : list) {
                    subMenu.add(item);
                }
                this.items = new IContributionItem[]{subMenu};
            }
        }
        return this.items;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.categoryId = (String)data;
        }
    }
}

