/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.ILazyOpListener;
import net.refractions.udig.ui.operations.IOpFilterListener;
import net.refractions.udig.ui.operations.OpFilter;

public class LazyOpFilter
implements OpFilter {
    private final OpFilter opFilter;
    private final ILazyOpListener listener;
    private Worker worker;
    final Map<Object, Boolean> cache = new WeakHashMap<Object, Boolean>();
    final boolean blocking;
    final boolean caching;
    final Lock lock = new ReentrantLock();
    private IOpFilterListener changeListener = new IOpFilterListener(){

        @Override
        public void notifyChange(Object changedLayer) {
            boolean notify = false;
            boolean newResult = false;
            LazyOpFilter.this.lock.lock();
            try {
                if (!LazyOpFilter.this.enabled) {
                    UiPlugin.log("Warning listener called even though not enabled", new Exception());
                    return;
                }
                if (LazyOpFilter.this.opFilter.canCacheResult()) {
                    Boolean removed = LazyOpFilter.this.cache.get(changedLayer);
                    if (removed != null) {
                        LazyOpFilter.this.cache.remove(changedLayer);
                        if (LazyOpFilter.this.listener != null && (newResult = LazyOpFilter.this.acceptInternal(changedLayer, removed)) != removed) {
                            notify = true;
                        }
                    }
                } else {
                    notify = true;
                    newResult = LazyOpFilter.this.accept(changedLayer);
                }
            }
            finally {
                LazyOpFilter.this.lock.unlock();
            }
            if (notify) {
                LazyOpFilter.this.listener.notifyResultObtained(newResult);
            }
        }
    };
    private boolean enabled;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    public static final boolean DEFAULT_RETURN_VALUE = true;

    public LazyOpFilter(ILazyOpListener listener, OpFilter opFilter) {
        this.listener = listener;
        this.opFilter = opFilter;
        this.caching = opFilter.canCacheResult();
        this.blocking = opFilter.isBlocking();
        this.enabled = false;
    }

    @Override
    public boolean accept(Object object) {
        this.lock.lock();
        try {
            if (!this.enabled) {
                this.enabled = true;
                this.opFilter.addListener(this.changeListener);
            }
            boolean bl = this.acceptInternal(object, true);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean acceptInternal(Object object, boolean defaultReturnValue) {
        Boolean result;
        if (this.worker != null) {
            this.worker.cancel();
        }
        if ((result = this.cache.get(object)) != null && this.caching) {
            return result;
        }
        if (result == null) {
            result = defaultReturnValue;
        }
        if (this.blocking) {
            this.worker = new Worker(object);
            executor.submit(this.worker);
        } else {
            result = this.opFilter.accept(object);
            this.cache.put(object, result);
        }
        return result;
    }

    @Override
    public void addListener(IOpFilterListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canCacheResult() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBlocking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(IOpFilterListener listener) {
        throw new UnsupportedOperationException();
    }

    public void disable() {
        this.lock.lock();
        try {
            this.enabled = false;
            this.opFilter.removeListener(this.changeListener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "LazyOpFilter " + this.opFilter;
    }

    private class Worker
    implements Runnable {
        private final Object object;
        private volatile boolean cancelled;

        public Worker(Object object) {
            this.object = object;
            this.cancelled = false;
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean result;
            LazyOpFilter lazyOpFilter = LazyOpFilter.this;
            synchronized (lazyOpFilter) {
                result = LazyOpFilter.this.opFilter.accept(this.object);
                LazyOpFilter.this.cache.put(this.object, result);
            }
            if (!this.cancelled) {
                LazyOpFilter.this.listener.notifyResultObtained(result);
            }
        }
    }
}

