/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.operations;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.operations.IOpFilterListener;
import net.refractions.udig.ui.operations.PropertyValue;

public abstract class AbstractPropertyValue<T>
implements PropertyValue<T> {
    protected Set<IOpFilterListener> listeners = new CopyOnWriteArraySet<IOpFilterListener>();

    @Override
    public void addListener(IOpFilterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IOpFilterListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners(Object changed) {
        for (IOpFilterListener listener : this.listeners) {
            try {
                listener.notifyChange(changed);
            }
            catch (Exception e) {
                UiPlugin.trace("net.refractions.udig.ui", listener.getClass(), e.getMessage(), e);
            }
        }
    }
}

