/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class TableSettings {
    private static final int defaultMinPixels = 60;
    private int currentMode = 0;
    private ArrayList<Integer> minPixels;
    private ArrayList<Double> maxPercent;
    private int numColumns;

    public TableSettings(Table table) {
        this(table.getColumnCount());
    }

    public TableSettings(Tree tree) {
        this(tree.getColumnCount());
    }

    public TableSettings(int columnCount) {
        this.numColumns = columnCount;
        this.minPixels = new ArrayList();
        this.maxPercent = new ArrayList();
        double defaultMaxPercent = 1.0 / (double)this.numColumns;
        int i = 0;
        while (i < this.numColumns) {
            this.minPixels.add(i, 60);
            this.maxPercent.add(i, defaultMaxPercent);
            ++i;
        }
    }

    public void setColumnMin(int columnIndex, int numPixels) {
        this.minPixels.set(columnIndex, numPixels);
    }

    public int getColumnMin(int columnIndex) {
        return this.minPixels.get(columnIndex);
    }

    public void setColumnMax(int columnIndex, double widthPercent) {
        this.maxPercent.set(columnIndex, widthPercent);
    }

    public double getColumnMax(int columnIndex) {
        return this.maxPercent.get(columnIndex);
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        this.currentMode = currentMode;
    }
}

