/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class SWTGraphics
implements ViewportGraphics {
    public static final int TRANSPARENT = 0x222222;
    static final AffineTransform AFFINE_TRANSFORM = new AffineTransform();
    private Transform swtTransform;
    private GC gc = null;
    private Color fore = null;
    private Color back = null;
    private Display display;
    private org.eclipse.swt.graphics.Font font = null;

    public SWTGraphics(org.eclipse.swt.graphics.Image image, Display display) {
        this(new GC((Drawable)image), display);
    }

    public SWTGraphics(GC gc, Display display) {
        AWTSWTImageUtils.checkAccess();
        this.display = display;
        this.setGraphics(gc, display);
    }

    void setGraphics(GC gc, Display display) {
        AWTSWTImageUtils.checkAccess();
        this.gc = gc;
        if (this.back != null) {
            this.back.dispose();
        }
        this.back = new Color((Device)display, 255, 255, 255);
        gc.setBackground(this.back);
        gc.setAdvanced(true);
    }

    @Override
    public <T> T getGraphics(Class<T> adaptee) {
        AWTSWTImageUtils.checkAccess();
        if (adaptee.isAssignableFrom(GC.class)) {
            return adaptee.cast(this.gc);
        }
        return null;
    }

    @Override
    public void dispose() {
        AWTSWTImageUtils.checkAccess();
        if (this.fore != null) {
            this.fore.dispose();
        }
        if (this.back != null) {
            this.back.dispose();
        }
        if (this.swtTransform != null) {
            this.swtTransform.dispose();
        }
        this.gc.dispose();
    }

    @Override
    public void drawPath(Path path) {
        AWTSWTImageUtils.checkAccess();
        this.gc.drawPath(path);
    }

    @Override
    public void draw(Shape s) {
        AWTSWTImageUtils.checkAccess();
        Path path = AWTSWTImageUtils.convertToPath(s, (Device)this.display);
        if (path != null) {
            this.gc.drawPath(path);
            path.dispose();
        }
    }

    public static Path convertToPath(Shape shape, Device device) {
        return AWTSWTImageUtils.convertToPath(shape, device);
    }

    public static Path createPath(PathIterator p, Device device) {
        return AWTSWTImageUtils.createPath(p, device);
    }

    @Override
    public void fill(Shape s) {
        Color tmp = this.prepareForFill();
        Path path = AWTSWTImageUtils.convertToPath(s, (Device)this.display);
        this.gc.fillPath(path);
        path.dispose();
        this.gc.setBackground(tmp);
    }

    private Color prepareForFill() {
        AWTSWTImageUtils.checkAccess();
        Color tmp = this.gc.getBackground();
        if (this.fore == null) {
            this.gc.setBackground(this.gc.getForeground());
        } else {
            this.gc.setBackground(this.fore);
        }
        return tmp;
    }

    @Override
    public void fillPath(Path path) {
        Color tmp = this.prepareForFill();
        this.gc.fillPath(path);
        this.gc.setBackground(tmp);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Color tmp = this.prepareForFill();
        this.gc.drawRectangle(x, y, width, height);
        this.gc.setBackground(tmp);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        Color tmp = this.prepareForFill();
        this.gc.fillRectangle(new org.eclipse.swt.graphics.Rectangle(x, y, width, height));
        this.gc.setBackground(tmp);
    }

    @Override
    public void setColor(java.awt.Color c) {
        AWTSWTImageUtils.checkAccess();
        Color color = new Color((Device)this.display, c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setForeground(color);
        this.gc.setAlpha(c.getAlpha());
        if (this.fore != null) {
            this.fore.dispose();
        }
        this.fore = color;
    }

    @Override
    public void setBackground(java.awt.Color c) {
        AWTSWTImageUtils.checkAccess();
        Color color = new Color((Device)this.display, c.getRed(), c.getGreen(), c.getBlue());
        this.gc.setBackground(color);
        if (this.back != null) {
            this.back.dispose();
        }
        this.back = color;
    }

    @Override
    public void setStroke(int style, int width) {
        AWTSWTImageUtils.checkAccess();
        this.gc.setLineWidth(width);
        switch (style) {
            case 2: {
                this.gc.setLineStyle(2);
                break;
            }
            case 4: {
                this.gc.setLineStyle(4);
                break;
            }
            case 5: {
                this.gc.setLineStyle(5);
                break;
            }
            case 3: {
                this.gc.setLineStyle(3);
                break;
            }
            case 1: {
                this.gc.setLineStyle(1);
                break;
            }
            case 6: {
                this.gc.setLineCap(2);
                this.gc.setLineJoin(2);
                this.gc.setLineStyle(1);
                break;
            }
            default: {
                this.gc.setLineStyle(1);
            }
        }
    }

    @Override
    public void setClip(Rectangle r) {
        AWTSWTImageUtils.checkAccess();
        this.gc.setClipping(r.x, r.y, r.width, r.height);
    }

    @Override
    public void translate(java.awt.Point offset) {
        AWTSWTImageUtils.checkAccess();
        if (this.swtTransform == null) {
            this.swtTransform = new Transform((Device)this.display);
        }
        this.swtTransform.translate((float)offset.x, (float)offset.y);
        this.gc.setTransform(this.swtTransform);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        AWTSWTImageUtils.checkAccess();
        this.gc.fillRectangle(x, y, width, height);
    }

    @Override
    public void drawImage(RenderedImage rimage, int x, int y) {
        AWTSWTImageUtils.checkAccess();
        this.drawImage(rimage, x, y, x + rimage.getWidth(), y + rimage.getHeight(), 0, 0, rimage.getWidth(), rimage.getHeight());
    }

    public static org.eclipse.swt.graphics.Image createDefaultImage(Display display, int width, int height) {
        return AWTSWTImageUtils.createDefaultImage(display, width, height);
    }

    public static ImageDescriptor createImageDescriptor(RenderedImage image, boolean transparent) {
        return AWTSWTImageUtils.createImageDescriptor(image, transparent);
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        return AWTSWTImageUtils.createBufferedImage(w, h);
    }

    public static org.eclipse.swt.graphics.Image createSWTImage(RenderedImage image, boolean transparent) {
        return AWTSWTImageUtils.createSWTImage(image, transparent);
    }

    public static ImageData createImageData(RenderedImage image, boolean transparent) {
        return AWTSWTImageUtils.createImageData(image, transparent);
    }

    @Override
    public void drawString(String string, int x, int y, int alignx, int aligny) {
        int x2;
        AWTSWTImageUtils.checkAccess();
        Point text = this.gc.stringExtent(string);
        int w = text.x;
        int h = text.y;
        int n = alignx == 0 ? x - w / 2 : (x2 = alignx > 0 ? x - w : x);
        int y2 = aligny == 0 ? y + h / 2 : (aligny > 0 ? y + h : y);
        this.gc.drawString(string, x2, y2, true);
    }

    @Override
    public void setTransform(AffineTransform transform) {
        AWTSWTImageUtils.checkAccess();
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        if (this.swtTransform == null) {
            this.swtTransform = new Transform((Device)this.display, (float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
        } else {
            this.swtTransform.setElements((float)matrix[0], (float)matrix[1], (float)matrix[2], (float)matrix[3], (float)matrix[4], (float)matrix[5]);
        }
        this.gc.setTransform(this.swtTransform);
    }

    @Override
    public int getFontHeight() {
        AWTSWTImageUtils.checkAccess();
        return this.gc.getFontMetrics().getHeight();
    }

    @Override
    public int stringWidth(String str) {
        AWTSWTImageUtils.checkAccess();
        return -1;
    }

    @Override
    public int getFontAscent() {
        AWTSWTImageUtils.checkAccess();
        return this.gc.getFontMetrics().getAscent();
    }

    @Override
    public Rectangle2D getStringBounds(String str) {
        AWTSWTImageUtils.checkAccess();
        Point extent = this.gc.textExtent(str);
        return new Rectangle(0, 0, extent.x, extent.y);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        AWTSWTImageUtils.checkAccess();
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawImage(Image awtImage, int x, int y) {
        AWTSWTImageUtils.checkAccess();
        RenderedImage rimage = (RenderedImage)((Object)awtImage);
        this.drawImage(rimage, x, y);
    }

    public void drawImage(RenderedImage rimage, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        AWTSWTImageUtils.checkAccess();
        assert (rimage != null);
        org.eclipse.swt.graphics.Image swtImage = null;
        try {
            swtImage = rimage instanceof BufferedImage ? AWTSWTImageUtils.convertToSWTImage((BufferedImage)rimage) : AWTSWTImageUtils.createSWTImage(rimage);
            if (swtImage != null) {
                this.gc.drawImage(swtImage, sx1, sy1, Math.abs(sx2 - sx1), Math.abs(sy2 - sy1), dx1, dy1, Math.abs(dx2 - dx1), Math.abs(dy2 - dy1));
                swtImage.dispose();
            }
        }
        finally {
            if (swtImage != null) {
                swtImage.dispose();
            }
        }
    }

    @Override
    public void drawImage(Image awtImage, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        AWTSWTImageUtils.checkAccess();
        RenderedImage rimage = (RenderedImage)((Object)awtImage);
        this.drawImage(rimage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image swtImage, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        AWTSWTImageUtils.checkAccess();
        this.gc.drawImage(swtImage, sx1, sy1, Math.abs(sx2 - sx1), Math.abs(sy2 - sy1), dx1, dy1, Math.abs(dx2 - dx1), Math.abs(dy2 - dy1));
    }

    @Override
    public void drawImage(org.eclipse.swt.graphics.Image swtImage, int x, int y) {
        this.gc.drawImage(swtImage, x, y);
    }

    @Override
    public AffineTransform getTransform() {
        AWTSWTImageUtils.checkAccess();
        if (this.swtTransform == null) {
            return AFFINE_TRANSFORM;
        }
        float[] matrix = new float[6];
        this.swtTransform.getElements(matrix);
        return new AffineTransform(matrix);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x, y, width, height);
    }

    public static ImageDescriptor createImageDescriptor(BufferedImage image) {
        return AWTSWTImageUtils.createImageDescriptor(image);
    }

    public static org.eclipse.swt.graphics.Image convertToSWTImage(BufferedImage image) {
        return AWTSWTImageUtils.convertToSWTImage(image);
    }

    public static ImageData createImageData(BufferedImage image) {
        return AWTSWTImageUtils.createImageData(image);
    }

    public static org.eclipse.swt.graphics.Image createSWTImage(RenderedImage image) {
        return AWTSWTImageUtils.createSWTImage(image);
    }

    public static ImageData createImageData(RenderedImage image) {
        return AWTSWTImageUtils.createImageData(image);
    }

    @Override
    public Shape getClip() {
        org.eclipse.swt.graphics.Rectangle clipping = this.gc.getClipping();
        return new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height);
    }

    @Override
    public void setClipBounds(Rectangle newBounds) {
        this.gc.setClipping(new org.eclipse.swt.graphics.Rectangle(newBounds.x, newBounds.y, newBounds.width, newBounds.height));
    }

    @Override
    public java.awt.Color getBackgroundColor() {
        AWTSWTImageUtils.checkAccess();
        return AWTSWTImageUtils.swtColor2awtColor(this.gc, this.gc.getBackground());
    }

    @Override
    public java.awt.Color getColor() {
        AWTSWTImageUtils.checkAccess();
        return AWTSWTImageUtils.swtColor2awtColor(this.gc, this.gc.getForeground());
    }

    public static java.awt.Color swtColor2awtColor(GC gc, Color swt) {
        return AWTSWTImageUtils.swtColor2awtColor(gc, swt);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        AWTSWTImageUtils.checkAccess();
        this.gc.drawRoundRectangle(x, y, width, height, arcWidth, arcHeight);
    }

    static void checkAccess() {
        AWTSWTImageUtils.checkAccess();
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Color tmp = this.prepareForFill();
        this.gc.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
        this.gc.setBackground(tmp);
    }

    @Override
    public void setLineDash(int[] dash) {
        this.gc.setLineDash(dash);
    }

    @Override
    public void setLineWidth(int width) {
        this.gc.setLineWidth(width);
    }

    public static int toFontStyle(Font f) {
        return AWTSWTImageUtils.toFontStyle(f);
    }

    @Override
    public void setFont(Font f) {
        int size = f.getSize() * this.getDPI() / 72;
        int style = AWTSWTImageUtils.toFontStyle(f);
        org.eclipse.swt.graphics.Font swtFont = new org.eclipse.swt.graphics.Font(this.gc.getDevice(), f.getFamily(), size, style);
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = swtFont;
        this.gc.setFont(this.font);
    }

    @Override
    public int getDPI() {
        return this.gc.getDevice().getDPI().y;
    }

    @Override
    public void fillGradientRectangle(int x, int y, int width, int height, java.awt.Color startColor, java.awt.Color endColor, boolean isVertical) {
        Color color1 = new Color((Device)this.display, startColor.getRed(), startColor.getGreen(), startColor.getBlue());
        Color color2 = new Color((Device)this.display, endColor.getRed(), endColor.getGreen(), endColor.getBlue());
        this.gc.setForeground(color1);
        this.gc.setBackground(color2);
        this.gc.fillGradientRectangle(x, y, width, height, isVertical);
        color1.dispose();
        color2.dispose();
    }

    public static Font swtFontToAwt(FontData fontData) {
        return AWTSWTImageUtils.swtFontToAwt(fontData);
    }

    public static org.eclipse.swt.graphics.Font awtFontToSwt(Font font, FontRegistry fontRegistry) {
        return AWTSWTImageUtils.awtFontToSwt(font, fontRegistry);
    }
}

