/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import net.refractions.udig.ui.Drawing;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.geotools.styling.Rule;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class Glyph {
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    static final int DEFAULT_DEPTH = 24;
    public static final int WHITE = 0xFFFFFF;
    private static final java.awt.Color DEFAULT_BORDER = new java.awt.Color(0, 0, 0);
    private static final java.awt.Color DEFAULT_FILL = new java.awt.Color(27, 158, 119, 255);
    static Drawing d = Drawing.create();

    public static ImageDescriptor push(final ImageDescriptor icon) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                ImageData push = icon.getImageData();
                if (!push.palette.isDirect) {
                    RGB[] rgb = new RGB[push.palette.colors.length];
                    System.arraycopy(push.palette.colors, 0, rgb, 0, push.palette.colors.length);
                    rgb[push.transparentPixel] = Display.getDefault().getSystemColor(18).getRGB();
                    push.palette = new PaletteData(rgb);
                    push.transparentPixel = -1;
                    this.createBorder(push);
                    return push;
                }
                int pushColour = push.palette.getPixel(Display.getDefault().getSystemColor(18).getRGB());
                int x = 0;
                while (x < push.width) {
                    int y = 0;
                    while (y < push.height) {
                        if (push.getAlpha(x, y) == 0) {
                            push.setAlpha(x, y, 255);
                            push.setPixel(x, y, pushColour);
                        }
                        if (push.getPixel(x, y) == push.transparentPixel) {
                            push.setPixel(x, y, pushColour);
                        }
                        ++y;
                    }
                    ++x;
                }
                return push;
            }

            private void createBorder(ImageData push) {
                int y = 0;
                while (y < push.height) {
                    int x = 0;
                    while (x < push.width) {
                        if (y == 0 || x == 0) {
                            push.setPixel(x, y, 0);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
        };
    }

    public static Image image(Display display) {
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(16, 16, 24, palette);
        imageData.transparentPixel = palette.getPixel(display.getSystemColor(22).getRGB());
        return new Image((Device)display, imageData);
    }

    static Color color(java.awt.Color color) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return new Color((Device)display, color.getRed(), color.getGreen(), color.getBlue());
    }

    static ImageData extractImageDataAndDispose(Image image) {
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public static ImageDescriptor point(final Rule rule) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image image = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    image = new Image((Device)display, 16, 16);
                    d.drawDirect(image, display, d.feature(d.point(7, 7)), rule);
                    return Glyph.extractImageDataAndDispose(image);
                }
                catch (RuntimeException ex) {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor point() {
        return Glyph.point(DEFAULT_BORDER, DEFAULT_FILL);
    }

    public static ImageDescriptor point(final java.awt.Color color, final java.awt.Color fill) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image swtImage = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    swtImage = new Image((Device)display, 16, 16);
                    GC gc = new GC((Drawable)swtImage);
                    gc.setAntialias(1);
                    gc.setLineCap(3);
                    gc.setLineStyle(1);
                    gc.setLineWidth(1);
                    java.awt.Color c = color;
                    java.awt.Color f = fill;
                    if (c == null && f == null) {
                        c = java.awt.Color.BLACK;
                        f = java.awt.Color.LIGHT_GRAY;
                    }
                    if (f != null) {
                        gc.setBackground(Glyph.color(f));
                        gc.setAlpha(f.getAlpha());
                        gc.fillRectangle(8, 7, 5, 5);
                    }
                    if (c != null) {
                        gc.setForeground(Glyph.color(c));
                        gc.setAlpha(c.getAlpha());
                        gc.drawRectangle(8, 7, 5, 5);
                    }
                    ImageData clone = (ImageData)swtImage.getImageData().clone();
                    swtImage.dispose();
                    gc.dispose();
                    return clone;
                }
                catch (RuntimeException ex) {
                    if (swtImage != null && !swtImage.isDisposed()) {
                        swtImage.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor line() {
        return Glyph.line(DEFAULT_BORDER, 1);
    }

    public static ImageDescriptor line(final Rule rule) {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = 14;
        nArray[2] = 6;
        nArray[4] = 11;
        nArray[5] = 14;
        nArray[6] = 15;
        nArray[7] = 1;
        final SimpleFeature feature = d.feature(d.line(nArray));
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image image = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    image = new Image((Device)display, 16, 16);
                    d.drawDirect(image, display, feature, rule);
                    return Glyph.extractImageDataAndDispose(image);
                }
                catch (RuntimeException ex) {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor line(java.awt.Color color, int width) {
        java.awt.Color color2 = color;
        int width2 = width;
        if (color2 == null) {
            color2 = java.awt.Color.BLACK;
        }
        if (width2 <= 0) {
            width2 = 1;
        }
        final int finalWidth = width2;
        final java.awt.Color finalColor = color2;
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image swtImage = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    swtImage = new Image((Device)display, 16, 16);
                    GC gc = new GC((Drawable)swtImage);
                    gc.setAntialias(1);
                    gc.setLineCap(3);
                    gc.setLineStyle(1);
                    gc.setForeground(Glyph.color(finalColor));
                    gc.setAlpha(finalColor.getAlpha());
                    gc.setLineWidth(finalWidth);
                    gc.drawLine(1, 13, 6, 2);
                    gc.drawLine(6, 2, 9, 13);
                    gc.drawLine(9, 13, 14, 2);
                    ImageData clone = (ImageData)swtImage.getImageData().clone();
                    swtImage.dispose();
                    return clone;
                }
                catch (RuntimeException ex) {
                    if (swtImage != null && !swtImage.isDisposed()) {
                        swtImage.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor geometry(final Rule rule) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image image = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    image = new Image((Device)display, 16, 16);
                    int[] nArray = new int[8];
                    nArray[1] = 12;
                    nArray[2] = 6;
                    nArray[3] = 3;
                    nArray[4] = 11;
                    nArray[5] = 12;
                    nArray[6] = 15;
                    nArray[7] = 3;
                    d.drawDirect(image, display, d.feature(d.line(nArray)), rule);
                    d.drawDirect(image, display, d.feature(d.point(4, 4)), rule);
                    return Glyph.extractImageDataAndDispose(image);
                }
                catch (RuntimeException ex) {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor geometry(final java.awt.Color color, final java.awt.Color fill) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image swtImage = null;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    swtImage = new Image((Device)display, 16, 16);
                    GC gc = new GC((Drawable)swtImage);
                    gc.setAntialias(1);
                    gc.setLineCap(3);
                    gc.setLineStyle(1);
                    gc.setLineWidth(1);
                    java.awt.Color c = color;
                    java.awt.Color f = fill;
                    if (c == null && f == null) {
                        c = java.awt.Color.BLACK;
                        f = java.awt.Color.LIGHT_GRAY;
                    }
                    if (f != null) {
                        gc.setBackground(Glyph.color(f));
                        gc.setAlpha(f.getAlpha());
                        gc.fillRoundRectangle(2, 1, 13, 13, 2, 2);
                    }
                    if (c != null) {
                        gc.setForeground(Glyph.color(c));
                        gc.setAlpha(c.getAlpha());
                        gc.drawRoundRectangle(2, 1, 13, 13, 2, 2);
                    }
                    ImageData clone = (ImageData)swtImage.getImageData().clone();
                    swtImage.dispose();
                    return clone;
                }
                catch (RuntimeException ex) {
                    if (swtImage != null && !swtImage.isDisposed()) {
                        swtImage.dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor polygon(final Rule rule) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                final Image[] image = new Image[1];
                try {
                    final Display display = PlatformUI.getWorkbench().getDisplay();
                    PlatformGIS.syncInDisplayThread(display, new Runnable(){

                        @Override
                        public void run() {
                            image[0] = new Image((Device)display, 16, 16);
                            try {
                                d.drawDirect(image[0], display, d.feature(d.polygon(new int[]{1, 14, 3, 9, 4, 6, 6, 4, 9, 3, 14, 1, 14, 14})), rule);
                            }
                            catch (Throwable throwable) {}
                        }
                    });
                    return Glyph.extractImageDataAndDispose(image[0]);
                }
                catch (RuntimeException ex) {
                    if (image[0] != null && !image[0].isDisposed()) {
                        image[0].dispose();
                    }
                    throw ex;
                }
            }
        };
    }

    public static ImageDescriptor polygon() {
        return Glyph.polygon(DEFAULT_BORDER, DEFAULT_FILL, 1);
    }

    public static ImageDescriptor polygon(final java.awt.Color color, final java.awt.Color fill, final int width) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Image swtImage = null;
                try {
                    int w;
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    swtImage = new Image((Device)display, 16, 16);
                    GC gc = new GC((Drawable)swtImage);
                    gc.setAntialias(1);
                    gc.setLineCap(3);
                    gc.setLineStyle(1);
                    Color t = null;
                    java.awt.Color c = color;
                    java.awt.Color f = fill;
                    int n = w = width > 0 ? width : 1;
                    if (c == null && f == null) {
                        c = java.awt.Color.BLACK;
                        f = java.awt.Color.LIGHT_GRAY;
                    }
                    if (f != null) {
                        t = Glyph.color(f);
                        gc.setBackground(t);
                        t.dispose();
                    }
                    if (c != null) {
                        t = Glyph.color(c);
                        gc.setForeground(t);
                        t.dispose();
                    }
                    gc.setLineWidth(w);
                    int[] points = new int[]{1, 14, 3, 9, 4, 6, 6, 4, 9, 3, 14, 1, 14, 14};
                    gc.setAlpha(f.getAlpha());
                    gc.fillPolygon(points);
                    gc.setAlpha(c.getAlpha());
                    gc.drawPolygon(points);
                    ImageData clone = (ImageData)swtImage.getImageData().clone();
                    swtImage.dispose();
                    ImageData imageData = clone;
                    return imageData;
                }
                finally {
                    if (swtImage != null && !swtImage.isDisposed()) {
                        swtImage.dispose();
                    }
                }
            }
        };
    }

    public static ImageDescriptor grid(java.awt.Color a, java.awt.Color b, java.awt.Color c, java.awt.Color d1) {
        if (a == null) {
            a = java.awt.Color.BLACK;
        }
        if (b == null) {
            b = java.awt.Color.DARK_GRAY;
        }
        if (c == null) {
            c = java.awt.Color.LIGHT_GRAY;
        }
        if (d1 == null) {
            d1 = java.awt.Color.WHITE;
        }
        final java.awt.Color finalA = a;
        final java.awt.Color finalB = b;
        final java.awt.Color finalC = c;
        final java.awt.Color finalD = d1;
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Display display = PlatformUI.getWorkbench().getDisplay();
                Image swtImage = new Image((Device)display, 16, 16);
                GC gc = new GC((Drawable)swtImage);
                gc.setAntialias(1);
                Color c = null;
                c = Glyph.color(finalA);
                gc.setBackground(c);
                gc.fillRectangle(0, 0, 7, 7);
                c.dispose();
                c = Glyph.color(finalB);
                gc.setBackground(c);
                gc.fillRectangle(7, 0, 15, 7);
                c.dispose();
                c = Glyph.color(finalC);
                gc.setBackground(c);
                gc.fillRectangle(0, 7, 7, 15);
                c.dispose();
                c = Glyph.color(finalD);
                gc.setBackground(c);
                gc.fillRectangle(7, 7, 15, 15);
                c.dispose();
                c = Glyph.color(java.awt.Color.BLACK);
                gc.setForeground(c);
                gc.drawRectangle(0, 0, 7, 7);
                gc.drawRectangle(0, 0, 15, 7);
                gc.drawRectangle(0, 0, 7, 15);
                gc.drawRectangle(0, 0, 15, 15);
                c.dispose();
                ImageData clone = (ImageData)swtImage.getImageData().clone();
                swtImage.dispose();
                return clone;
            }
        };
    }

    public static ImageDescriptor swatch(java.awt.Color c) {
        java.awt.Color c2 = c;
        c2 = c == null ? java.awt.Color.GRAY : c;
        final java.awt.Color color = c2;
        int saturation = color.getRed() + color.getGreen() + color.getBlue();
        final java.awt.Color contrast = saturation < 384 ? c.brighter() : c.darker();
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Display display = PlatformUI.getWorkbench().getDisplay();
                Image swtImage = new Image((Device)display, 16, 16);
                GC gc = new GC((Drawable)swtImage);
                gc.setAntialias(1);
                Color swtColor = Glyph.color(color);
                try {
                    gc.setBackground(swtColor);
                    gc.fillRoundRectangle(0, 0, 14, 14, 2, 2);
                }
                finally {
                    swtColor.dispose();
                }
                try {
                    swtColor = Glyph.color(contrast);
                    gc.setForeground(swtColor);
                    gc.drawRoundRectangle(0, 0, 14, 14, 2, 2);
                }
                finally {
                    swtColor.dispose();
                }
                ImageData clone = (ImageData)swtImage.getImageData().clone();
                swtImage.dispose();
                return clone;
            }
        };
    }

    public static ImageDescriptor palette(java.awt.Color[] c) {
        final java.awt.Color[] colors = new java.awt.Color[16];
        java.awt.Color color = java.awt.Color.GRAY;
        if (c == null) {
            int i = 0;
            while (i < 16) {
                color = java.awt.Color.GRAY;
                ++i;
            }
        } else {
            int i = 0;
            while (i < 16) {
                int lookup = i * c.length / 16;
                if (c[lookup] != null) {
                    color = c[lookup];
                }
                colors[i] = color;
                ++i;
            }
        }
        return new ImageDescriptor(){

            public ImageData getImageData() {
                Display display = PlatformUI.getWorkbench().getDisplay();
                Image swtImage = new Image((Device)display, 16, 16);
                GC gc = new GC((Drawable)swtImage);
                gc.setAntialias(1);
                Color swtColor = null;
                int i = 0;
                while (i < 16) {
                    try {
                        swtColor = Glyph.color(colors[i]);
                        gc.setForeground(swtColor);
                        gc.drawLine(i, 0, i, 15);
                    }
                    finally {
                        swtColor.dispose();
                    }
                    ++i;
                }
                try {
                    swtColor = Glyph.color(java.awt.Color.GRAY);
                    gc.setForeground(swtColor);
                    gc.drawRoundRectangle(0, 0, 14, 14, 2, 2);
                }
                finally {
                    swtColor.dispose();
                }
                ImageData clone = (ImageData)swtImage.getImageData().clone();
                swtImage.dispose();
                return clone;
            }
        };
    }

    public static ImageDescriptor icon(SimpleFeatureType ft) {
        if (ft == null || ft.getGeometryDescriptor() == null) {
            return null;
        }
        Class geomType = ft.getGeometryDescriptor().getType().getBinding();
        return Glyph.icon(geomType);
    }

    public static ImageDescriptor icon(Class<?> geomType) {
        if (Point.class.isAssignableFrom(geomType) || MultiPoint.class.isAssignableFrom(geomType)) {
            return Glyph.point(DEFAULT_BORDER, DEFAULT_FILL);
        }
        if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType) || LinearRing.class.isAssignableFrom(geomType)) {
            return Glyph.line(DEFAULT_BORDER, 1);
        }
        if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            return Glyph.polygon(DEFAULT_BORDER, DEFAULT_FILL, 1);
        }
        return Glyph.geometry(DEFAULT_BORDER, DEFAULT_FILL);
    }
}

