/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.graphics;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.swing.Icon;
import net.refractions.udig.ui.graphics.SWTGraphics;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class AWTSWTImageUtils {
    public static BufferedImage convertToAWT(Image image) {
        ImageData data = image.getImageData();
        return AWTSWTImageUtils.convertToAWT(data);
    }

    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            if (data.alphaData == null) {
                colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
                WritableRaster raster = bufferedImage.getRaster();
                int[] pixelArray = new int[4];
                int y = 0;
                while (y < data.height) {
                    int x = 0;
                    while (x < data.width) {
                        int pixel = data.getPixel(x, y);
                        RGB rgb = palette.getRGB(pixel);
                        pixelArray[0] = rgb.red;
                        pixelArray[1] = rgb.green;
                        pixelArray[2] = rgb.blue;
                        pixelArray[3] = pixel == data.transparentPixel ? 0 : 255;
                        raster.setPixels(x, y, 1, 1, pixelArray);
                        ++x;
                    }
                    ++y;
                }
                int w = bufferedImage.getWidth();
                int h = bufferedImage.getHeight();
                Raster ras = bufferedImage.getData();
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        ras.getPixel(i, j, new double[4]);
                        ++j;
                    }
                    ++i;
                }
                return bufferedImage;
            }
            colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    pixelArray[3] = data.getAlpha(x, y);
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static Path convertToPath(Shape shape, Device device) {
        AWTSWTImageUtils.checkAccess();
        PathIterator p = shape.getPathIterator(SWTGraphics.AFFINE_TRANSFORM);
        return AWTSWTImageUtils.createPath(p, device);
    }

    public static Path createPath(PathIterator p, Device device) {
        if (p.isDone()) {
            return null;
        }
        float[] current = new float[6];
        Path path = new Path(device);
        while (!p.isDone()) {
            int result = p.currentSegment(current);
            switch (result) {
                case 4: {
                    path.close();
                    break;
                }
                case 1: {
                    path.lineTo(current[0], current[1]);
                    break;
                }
                case 0: {
                    path.moveTo(current[0], current[1]);
                    break;
                }
                case 2: {
                    path.quadTo(current[0], current[1], current[2], current[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(current[0], current[1], current[2], current[3], current[4], current[5]);
                }
            }
            p.next();
        }
        return path;
    }

    public static Image createDefaultImage(Device device, int width, int height) {
        AWTSWTImageUtils.checkAccess();
        ImageData swtdata = null;
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        swtdata.transparentPixel = -1;
        swtdata.alpha = -1;
        swtdata.alphaData = new byte[swtdata.data.length];
        int i = 0;
        while (i < swtdata.alphaData.length) {
            swtdata.alphaData[i] = 0;
            ++i;
        }
        return new Image(device, swtdata);
    }

    public static Image createDefaultImage(Display display, int width, int height) {
        AWTSWTImageUtils.checkAccess();
        ImageData swtdata = null;
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        swtdata.transparentPixel = 0;
        swtdata.alpha = -1;
        swtdata.alphaData = new byte[swtdata.data.length];
        int i = 0;
        while (i < swtdata.alphaData.length) {
            swtdata.alphaData[i] = -1;
            ++i;
        }
        return new Image((Device)display, swtdata);
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 7);
    }

    public static Image createSWTImage(RenderedImage image, boolean transparent) {
        AWTSWTImageUtils.checkAccess();
        ImageData data = image instanceof BufferedImage ? AWTSWTImageUtils.createImageData((BufferedImage)image) : AWTSWTImageUtils.createImageData(image, transparent);
        return new Image((Device)Display.getDefault(), data);
    }

    public static ImageData createImageData(RenderedImage image, boolean transparent) {
        AWTSWTImageUtils.checkAccess();
        ImageData swtdata = null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = 24;
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        swtdata = new ImageData(width, height, depth, palette);
        Raster raster = image.getData();
        int numbands = raster.getNumBands();
        int[] awtdata = raster.getPixels(0, 0, width, height, new int[width * height * numbands]);
        int step = swtdata.depth / 8;
        byte[] data = swtdata.data;
        swtdata.transparentPixel = -1;
        int baseindex = 0;
        int y = 0;
        while (y < height) {
            int idx = (0 + y) * swtdata.bytesPerLine + 0 * step;
            int x = 0;
            while (x < width) {
                int pixel = x + y * width;
                baseindex = pixel * numbands;
                data[idx++] = (byte)awtdata[baseindex + 2];
                data[idx++] = (byte)awtdata[baseindex + 1];
                data[idx++] = (byte)awtdata[baseindex];
                if (numbands == 4 && transparent) {
                    swtdata.setAlpha(x, y, awtdata[baseindex + 3]);
                }
                ++x;
            }
            ++y;
        }
        return swtdata;
    }

    public static ImageDescriptor createImageDescriptor(final RenderedImage image, final boolean transparent) {
        AWTSWTImageUtils.checkAccess();
        return new ImageDescriptor(){

            public ImageData getImageData() {
                return AWTSWTImageUtils.createImageData(image, transparent);
            }
        };
    }

    public static ImageDescriptor createImageDescriptor(final BufferedImage image) {
        AWTSWTImageUtils.checkAccess();
        return new ImageDescriptor(){

            public ImageData getImageData() {
                return AWTSWTImageUtils.createImageData(image);
            }
        };
    }

    public static Image convertToSWTImage(BufferedImage image) {
        AWTSWTImageUtils.checkAccess();
        ImageData data = AWTSWTImageUtils.createImageData(image);
        return new Image((Device)Display.getDefault(), data);
    }

    public static ImageData createImageData(BufferedImage image) {
        AWTSWTImageUtils.checkAccess();
        int width = image.getWidth();
        int height = image.getHeight();
        if (image.getType() == 5) {
            int bands = image.getColorModel().getColorSpace().getNumComponents();
            int depth = 24;
            byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            ImageData data = new ImageData(width, height, depth, paletteData, width * bands, pixels);
            return data;
        }
        if (image.getType() == 6) {
            int bands = image.getColorModel().getColorSpace().getNumComponents() + 1;
            int depth = 32;
            byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            PaletteData paletteData = new PaletteData(255, 65280, 0xFF0000);
            ImageData data = new ImageData(width, height, depth, paletteData, width * bands, pixels);
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int pixel = image.getRGB(x, y);
                    int alpha_value = pixel >> 24 & 0xFF;
                    data.setAlpha(x, y, alpha_value);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return AWTSWTImageUtils.createImageData(image, image.getTransparency() != 1);
    }

    public static Image createSWTImage(RenderedImage image) {
        AWTSWTImageUtils.checkAccess();
        ImageData data = AWTSWTImageUtils.createImageData(image);
        return new Image((Device)Display.getDefault(), data);
    }

    public static ImageData createImageData(RenderedImage image) {
        AWTSWTImageUtils.checkAccess();
        if (image instanceof BufferedImage) {
            return AWTSWTImageUtils.createImageData((BufferedImage)image);
        }
        int depth = 24;
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixels = ((DataBufferByte)image.getTile(0, 0).getDataBuffer()).getData();
        ImageData data = new ImageData(width, height, depth, new PaletteData(0xFF0000, 65280, 255), width, pixels);
        return data;
    }

    public static java.awt.Color swtColor2awtColor(GC gc, Color swt) {
        java.awt.Color awt = new java.awt.Color(swt.getRed(), swt.getGreen(), swt.getBlue(), gc.getAlpha());
        return awt;
    }

    static void checkAccess() {
        if (Display.getCurrent() == null) {
            SWT.error((int)22);
        }
    }

    public static Font swtFontToAwt(FontData fontData) {
        int style = 0;
        if ((fontData.getStyle() & 1) == 1) {
            style = 1;
        }
        if ((fontData.getStyle() & 2) == 2) {
            style |= 2;
        }
        Font font = new Font(fontData.getName(), style, fontData.getHeight());
        return font;
    }

    public static org.eclipse.swt.graphics.Font awtFontToSwt(Font font, FontRegistry fontRegistry) {
        String fontName = font.getFontName();
        if (fontRegistry.hasValueFor(fontName)) {
            return fontRegistry.get(fontName);
        }
        int style = 0;
        if ((font.getStyle() & 1) == 1) {
            style = 1;
        }
        if ((font.getStyle() & 2) == 2) {
            style |= 2;
        }
        FontData data = new FontData(fontName, font.getSize(), style);
        fontRegistry.put(fontName, new FontData[]{data});
        return fontRegistry.get(fontName);
    }

    public static int toFontStyle(Font f) {
        int s = 0;
        if (f.isItalic()) {
            s |= 2;
        }
        if (f.isBold()) {
            s |= 1;
        }
        return s;
    }

    public static Icon imageDescriptor2awtIcon(ImageDescriptor imageDescriptor) {
        Icon awtIcon = new Icon(imageDescriptor){
            ImageData imageData;
            {
                this.imageData = imageDescriptor.getImageData();
            }

            @Override
            public int getIconHeight() {
                return this.imageData.width;
            }

            @Override
            public int getIconWidth() {
                return this.imageData.height;
            }

            @Override
            public void paintIcon(Component comp, Graphics g, int x, int y) {
                BufferedImage image = AWTSWTImageUtils.convertToAWT(this.imageData);
                g.drawImage(image, x, y, null);
            }
        };
        return awtIcon;
    }

    public static ImageDescriptor awtIcon2ImageDescriptor(final Icon icon) {
        ImageDescriptor descriptor = new ImageDescriptor(){

            public ImageData getImageData() {
                BufferedImage image = AWTSWTImageUtils.createBufferedImage(icon.getIconWidth(), icon.getIconHeight());
                Graphics2D g = image.createGraphics();
                try {
                    icon.paintIcon(null, g, 0, 0);
                }
                finally {
                    g.dispose();
                }
                ImageData data = AWTSWTImageUtils.createImageData(image);
                return data;
            }
        };
        return descriptor;
    }
}

