/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public abstract class ViewerFactory<V extends Viewer> {
    private IConfigurationElement config;

    void init(IConfigurationElement config) {
        this.config = config;
    }

    public String getId() {
        String id = this.config.getAttribute("id");
        return id;
    }

    public String getDisplayName() {
        String name = this.config.getAttribute("name");
        return name;
    }

    public Class<?> getBinding() {
        return Object.class;
    }

    public int score(Object input, Object value) {
        return Appropriate.INCOMPLETE.getScore();
    }

    public abstract V createViewer(Composite var1, int var2);

    public static <T> T safeCast(Object obj, Class<T> type) {
        if (obj == null) {
            return null;
        }
        if (type != null && type.isInstance(obj)) {
            return type.cast(obj);
        }
        return null;
    }

    public static enum Appropriate {
        NOT_APPROPRIATE(0),
        INCOMPLETE(1),
        COMPLETE(25),
        APPROPRIATE(50),
        FRIENDLY(75),
        PERFECT(100);

        private final int score;

        private Appropriate(int score) {
            this.score = score;
        }

        public int getScore() {
            return this.score;
        }

        public int getScore(int adjust) {
            int adjustedScore = this.score + adjust;
            if (adjustedScore < INCOMPLETE.getScore()) {
                return INCOMPLETE.getScore();
            }
            if (adjustedScore > PERFECT.getScore()) {
                return PERFECT.getScore();
            }
            return adjustedScore;
        }

        public static Appropriate valueOf(String string) {
            return Enum.valueOf(Appropriate.class, string);
        }
    }

    public static class ViewerFactoryComparator
    implements Comparator<ViewerFactory<?>> {
        private Object input;
        private Object value;

        public ViewerFactoryComparator(Object input, Object value) {
            this.input = input;
            this.value = value;
        }

        @Override
        public int compare(ViewerFactory<?> factory1, ViewerFactory<?> factory2) {
            int factory1Score = factory1 != null ? factory1.score(this.input, this.value) : -1;
            int factory2Score = factory2 != null ? factory2.score(this.input, this.value) : -1;
            return factory2Score - factory1Score;
        }
    }
}

