/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import net.miginfocom.swt.MigLayout;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewerFactory;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class SpinnerExpressionViewer
extends IExpressionViewer {
    public static final String NONE = "- none -";
    Composite control;
    protected ComboViewer combo;
    protected Spinner spinner;
    protected Text text;
    private SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Expression newExpression = SpinnerExpressionViewer.this.validate();
            SpinnerExpressionViewer.this.internalUpdate(newExpression);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private ISelectionChangedListener comboListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Expression newExpression = SpinnerExpressionViewer.this.validate();
            SpinnerExpressionViewer.this.internalUpdate(newExpression);
        }
    };

    public SpinnerExpressionViewer(Composite parent, int style) {
        boolean multiLine = (2 & style) != 0;
        this.control = new Composite(parent, 16){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                SpinnerExpressionViewer.this.combo.getControl().setEnabled(enabled);
                SpinnerExpressionViewer.this.spinner.setEnabled(enabled);
                SpinnerExpressionViewer.this.text.setEnabled(enabled);
            }
        };
        Label comboLabel = null;
        if (multiLine) {
            comboLabel = new Label(this.control, 0);
            comboLabel.setText("Numeric:");
        }
        this.combo = new ComboViewer(this.control, -1);
        this.combo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PropertyDescriptor) {
                    PropertyDescriptor descriptor = (PropertyDescriptor)element;
                    return descriptor.getName().getLocalPart();
                }
                return super.getText(element);
            }
        });
        this.combo.getControl().setEnabled(false);
        Label spinnerLabel = null;
        if (multiLine) {
            spinnerLabel = new Label(this.control, 0);
            spinnerLabel.setText("Value:");
        }
        this.spinner = new Spinner(this.control, -1);
        this.spinner.setMinimum(0);
        this.spinner.setMaximum(100);
        this.spinner.setIncrement(10);
        this.spinner.setEnabled(false);
        Label textLabel = null;
        if (multiLine) {
            textLabel = new Label(this.control, 0);
            textLabel.setText("Text:");
        }
        this.text = new Text(this.control, 2076);
        this.text.setEditable(false);
        if (multiLine) {
            this.control.setLayout((Layout)new MigLayout("insets 0", "[][][grow]", "[]"));
            comboLabel.setLayoutData((Object)"cell 0 0, alignx trailing");
            this.combo.getControl().setLayoutData((Object)"cell 1 0, width 200:30%:100%,gap related");
            spinnerLabel.setLayoutData((Object)"cell 0 1, alignx trailing");
            this.spinner.setLayoutData((Object)"cell 1 1, width 200:30%:300%,gap related");
            textLabel.setLayoutData((Object)"cell 0 2, alignx trailing");
            this.text.setLayoutData((Object)"cell 1 2, grow,width 200:pref:100%,gap related");
        } else {
            this.control.setLayout((Layout)new MigLayout("insets 0", "flowx", ""));
            this.combo.getControl().setLayoutData((Object)"width 200:30%:100%");
            this.spinner.setLayoutData((Object)"width 200:30%:300%,gap unrelated");
            this.text.setLayoutData((Object)"grow,width 200:pref:100%,gap unrelated");
        }
        this.listen(true);
    }

    private void listen(boolean listen) {
        if (listen) {
            this.spinner.addSelectionListener(this.listener);
            this.combo.addSelectionChangedListener(this.comboListener);
        } else {
            this.spinner.removeSelectionListener(this.listener);
            this.combo.removeSelectionChangedListener(this.comboListener);
        }
    }

    protected Expression validate() {
        Object selection;
        if (this.combo.getControl().isEnabled() && !this.combo.getSelection().isEmpty() && (selection = ((StructuredSelection)this.combo.getSelection()).getFirstElement()) != NONE && selection instanceof String) {
            String propertyName = (String)selection;
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            return ff.property(propertyName);
        }
        if (this.spinner.isEnabled()) {
            int number = this.spinner.getSelection();
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
            return ff.literal((double)number / 100.0);
        }
        return null;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void refresh() {
        try {
            this.listen(false);
            if (this.input != null) {
                this.combo.setInput(this.input.toNumericPropertyList());
                this.combo.getControl().setEnabled(true);
            } else {
                this.combo.setInput(null);
                this.combo.getControl().setEnabled(false);
            }
            if (this.input != null) {
                Comparable<?> min = this.input.getMin();
                Comparable<?> max = this.input.getMax();
                if (min instanceof Number && max instanceof Number) {
                    int minInt = ((Number)((Object)min)).intValue();
                    int maxInt = ((Number)((Object)max)).intValue();
                    this.spinner.setMinimum(minInt);
                    this.spinner.setMaximum(maxInt);
                    this.spinner.setEnabled(true);
                } else {
                    this.spinner.setEnabled(false);
                }
            } else {
                this.spinner.setEnabled(false);
            }
            this.text.setEnabled(false);
        }
        finally {
            this.listen(true);
        }
        this.refreshExpression();
    }

    public void refreshExpression() {
        Literal literal;
        Double percent;
        Expression expr = this.getExpression();
        if (expr instanceof PropertyName) {
            PropertyName property = (PropertyName)expr;
            String name = property.getPropertyName();
            this.refreshControls(null, name, null);
            this.feedback();
            return;
        }
        if (expr instanceof Literal && (percent = (Double)(literal = (Literal)expr).evaluate(null, Double.class)) != null) {
            this.refreshControls(percent, null, null);
            this.feedback();
            return;
        }
        String message = ECQL.toCQL((Expression)expr);
        this.refreshControls(null, null, message);
        this.feedbackReplace(expr);
    }

    protected void refreshControls(final Double number, final String propertyName, final String message) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SpinnerExpressionViewer.this.control == null || SpinnerExpressionViewer.this.control.isDisposed()) {
                        return;
                    }
                    boolean isPercent = SpinnerExpressionViewer.this.input != null && SpinnerExpressionViewer.this.input.isPercent();
                    SpinnerExpressionViewer.this.combo.setInput(SpinnerExpressionViewer.this.input.getNumericPropertyList());
                    if (number != null) {
                        SpinnerExpressionViewer.this.spinner.setEnabled(true);
                        int value = isPercent ? (int)(number * 100.0) : (int)Math.round(number);
                        SpinnerExpressionViewer.this.spinner.setSelection(value);
                        if (message == null) {
                            if (isPercent) {
                                SpinnerExpressionViewer.this.text.setText(String.valueOf(value) + "%");
                            } else {
                                SpinnerExpressionViewer.this.text.setText(String.valueOf(value));
                            }
                        }
                    } else {
                        SpinnerExpressionViewer.this.spinner.setEnabled(false);
                        SpinnerExpressionViewer.this.spinner.setSelection(0);
                    }
                    if (propertyName != null) {
                        StructuredSelection selection = new StructuredSelection((Object)propertyName);
                        SpinnerExpressionViewer.this.combo.setSelection((ISelection)selection, true);
                    } else {
                        StructuredSelection selection = new StructuredSelection((Object)SpinnerExpressionViewer.NONE);
                        SpinnerExpressionViewer.this.combo.setSelection((ISelection)selection, true);
                    }
                    if (message != null) {
                        SpinnerExpressionViewer.this.text.setText(message);
                    }
                }
            });
        }
    }

    @Override
    public void setExpression(Expression newExpression) {
        if (!newExpression.equals(this.expression)) {
            this.expression = newExpression;
            this.refreshExpression();
        }
    }

    public static class Factory
    extends ExpressionViewerFactory {
        @Override
        public int score(ExpressionInput input, Expression expression) {
            Literal literal;
            Double number;
            Class<Double> binding;
            if (input != null && !(binding = input.getBinding()).isAssignableFrom(Double.class)) {
                return ViewerFactory.Appropriate.NOT_APPROPRIATE.getScore();
            }
            if (expression instanceof Literal && (number = (Double)(literal = (Literal)expression).evaluate(null, Double.class)) != null && number >= 0.0 && number <= 1.0) {
                return ViewerFactory.Appropriate.APPROPRIATE.getScore();
            }
            if (expression instanceof PropertyName) {
                Class binding2;
                SimpleFeatureType schema;
                AttributeDescriptor descriptor;
                PropertyName name = (PropertyName)expression;
                if (input != null && input.getSchema() != null && (descriptor = (schema = input.getSchema()).getDescriptor(name.getPropertyName())) != null && Number.class.isAssignableFrom(binding2 = descriptor.getType().getBinding())) {
                    return ViewerFactory.Appropriate.APPROPRIATE.getScore();
                }
            }
            return ViewerFactory.Appropriate.INCOMPLETE.getScore();
        }

        @Override
        public IExpressionViewer createViewer(Composite parent, int style) {
            return new SpinnerExpressionViewer(parent, style);
        }
    }
}

