/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.awt.Color;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewerFactory;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class RGBExpressionViewer
extends IExpressionViewer {
    private final int MIN = 0;
    private final int MAX = 255;
    Composite control;
    protected Scale redScale;
    protected Spinner redSpinner;
    protected Scale blueScale;
    protected Spinner blueSpinner;
    protected Scale greenScale;
    protected Spinner greenSpinner;
    protected Text colorText;
    private SelectionListener listener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Expression newExpression = RGBExpressionViewer.this.validate(e);
            if (newExpression != null) {
                RGBExpressionViewer.this.internalUpdate(newExpression);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    protected void listen(boolean listen) {
        if (listen) {
            this.redSpinner.addSelectionListener(this.listener);
            if (this.redScale != null) {
                this.redScale.addSelectionListener(this.listener);
            }
            this.greenSpinner.addSelectionListener(this.listener);
            if (this.greenScale != null) {
                this.greenScale.addSelectionListener(this.listener);
            }
            this.blueSpinner.addSelectionListener(this.listener);
            if (this.blueScale != null) {
                this.blueScale.addSelectionListener(this.listener);
            }
        } else {
            this.redSpinner.removeSelectionListener(this.listener);
            if (this.redScale != null) {
                this.redScale.removeSelectionListener(this.listener);
            }
            this.greenSpinner.removeSelectionListener(this.listener);
            if (this.greenScale != null) {
                this.greenScale.removeSelectionListener(this.listener);
            }
            this.blueSpinner.removeSelectionListener(this.listener);
            if (this.blueScale != null) {
                this.blueScale.removeSelectionListener(this.listener);
            }
        }
    }

    public RGBExpressionViewer(Composite parent, int style) {
        boolean multiLine = (2 & style) != 0;
        this.control = new Composite(parent, style);
        this.control.setSize(400, 400);
        if (multiLine) {
            this.redScale = new Scale(this.control, 256);
            this.redScale.setMaximum(255);
            this.redScale.setMinimum(0);
            this.redScale.setEnabled(true);
        }
        Label redLabel = new Label(this.control, 4);
        redLabel.setText(multiLine ? "Red" : "R");
        this.redSpinner = new Spinner(this.control, 2048);
        this.redSpinner.setMinimum(0);
        this.redSpinner.setMaximum(255);
        this.redSpinner.setEnabled(true);
        if (multiLine) {
            this.greenScale = new Scale(this.control, 256);
            this.greenScale.setMaximum(255);
            this.greenScale.setMinimum(0);
        }
        Label greenLabel = new Label(this.control, 4);
        greenLabel.setText(multiLine ? "Green" : "G");
        this.greenSpinner = new Spinner(this.control, 2048);
        this.greenSpinner.setDigits(0);
        this.greenSpinner.setMinimum(0);
        this.greenSpinner.setMaximum(255);
        if (multiLine) {
            this.blueScale = new Scale(this.control, 256);
            this.blueScale.setMaximum(255);
            this.blueScale.setMinimum(0);
        }
        Label blueLabel = new Label(this.control, 4);
        blueLabel.setText(multiLine ? "Blue" : "B");
        this.blueSpinner = new Spinner(this.control, 2048);
        this.blueSpinner.setDigits(0);
        this.blueSpinner.setMinimum(0);
        this.blueSpinner.setMaximum(255);
        this.colorText = new Text(this.control, 2060);
        Label hexLabel = new Label(this.control, 4);
        hexLabel.setText("Color");
        if (multiLine) {
            MigLayout layout = new MigLayout("insets 0", "[][][grow]", "[]");
            this.control.setLayout((Layout)layout);
            redLabel.setLayoutData((Object)"cell 0 0, alignx trailing, gapx related");
            this.redSpinner.setLayoutData((Object)"cell 1 0, wmin 60,alignx left, gapx related");
            this.redScale.setLayoutData((Object)"cell 2 0, grow, width 200:100%:100%");
            greenLabel.setLayoutData((Object)"cell 0 1, alignx trailing, gapx related");
            this.greenSpinner.setLayoutData((Object)"cell 1 1, wmin 60,alignx left, gapx related");
            this.greenScale.setLayoutData((Object)"cell 2 1,grow, width 200:100%:100%");
            blueLabel.setLayoutData((Object)"cell 0 2, alignx trailing, gapx related");
            this.blueSpinner.setLayoutData((Object)"cell 1 2, wmin 60,alignx left, gapx related");
            this.blueScale.setLayoutData((Object)"cell 2 2,grow, width 200:100%:100%");
            hexLabel.setLayoutData((Object)"cell 0 3, alignx trailing, gapx related");
            this.colorText.setLayoutData((Object)"cell 2 3 2 1,grow, width 200:100%:100%");
        } else {
            this.control.setLayout((Layout)new MigLayout("insets 0, flowx", "", ""));
            redLabel.setLayoutData((Object)"gap related");
            this.redSpinner.setLayoutData((Object)"gap unrelated");
            greenLabel.setLayoutData((Object)"gap related");
            this.greenSpinner.setLayoutData((Object)"gap unrelated");
            blueLabel.setLayoutData((Object)"gap related");
            this.blueSpinner.setLayoutData((Object)"gap unrelated");
            hexLabel.setLayoutData((Object)"gap related");
            this.colorText.setLayoutData((Object)"gap unrelated");
        }
        this.listen(true);
    }

    public Control getControl() {
        return this.control;
    }

    private void syncSelection(Spinner spinner, Scale scalebar, SelectionEvent e) {
        int value;
        if (spinner == null || scalebar == null) {
            return;
        }
        if (spinner == e.getSource()) {
            value = spinner.getSelection();
            scalebar.setSelection(value);
            scalebar.setEnabled(true);
        }
        if (scalebar == e.getSource()) {
            value = scalebar.getSelection();
            spinner.setSelection(value);
            spinner.setEnabled(true);
        }
    }

    public Expression validate(SelectionEvent e) {
        this.syncSelection(this.redSpinner, this.redScale, e);
        this.syncSelection(this.greenSpinner, this.greenScale, e);
        this.syncSelection(this.blueSpinner, this.blueScale, e);
        int r = this.redSpinner.getSelection();
        int g = this.greenSpinner.getSelection();
        int b = this.blueSpinner.getSelection();
        Color c = new Color(r, g, b);
        String cql = "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
        this.colorText.setText(cql);
        this.colorText.setEnabled(true);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Literal expression = ff.literal((Object)cql);
        return expression;
    }

    @Override
    public void setExpression(Expression expression) {
        if (this.expression == expression) {
            return;
        }
        this.expression = expression;
        this.refreshExpression();
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    @Override
    public void refresh() {
        if (this.input != null) {
            boolean isColor = Color.class.isAssignableFrom(this.input.getBinding());
            if (isColor) {
                this.feedback();
            } else {
                this.feedback("Used with colour");
            }
        }
        this.refreshExpression();
    }

    public void refreshSelection(Spinner spinner, Scale scalebar, int selection) {
        spinner.setValues(selection, 0, 255, 0, 1, 5);
        if (scalebar != null) {
            scalebar.setMinimum(0);
            scalebar.setMaximum(255);
            scalebar.setIncrement(1);
            scalebar.setPageIncrement(5);
            scalebar.setSelection(selection);
        }
    }

    public void refreshExpression() {
        if (this.colorText != null && !this.colorText.isDisposed()) {
            this.colorText.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RGBExpressionViewer.this.colorText == null || RGBExpressionViewer.this.colorText.isDisposed()) {
                        return;
                    }
                    try {
                        Literal literal;
                        Color color;
                        RGBExpressionViewer.this.listen(false);
                        Expression expr = RGBExpressionViewer.this.getExpression();
                        if (expr instanceof Literal && (color = (Color)(literal = (Literal)expr).evaluate(null, Color.class)) != null) {
                            RGBExpressionViewer.this.feedback();
                            RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.redSpinner, RGBExpressionViewer.this.redScale, color.getRed());
                            RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.greenSpinner, RGBExpressionViewer.this.greenScale, color.getGreen());
                            RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.blueSpinner, RGBExpressionViewer.this.blueScale, color.getBlue());
                            String text = (String)Converters.convert((Object)color, String.class);
                            if (text != null) {
                                RGBExpressionViewer.this.colorText.setText(text);
                            } else {
                                RGBExpressionViewer.this.colorText.setText("#" + Integer.toHexString(color.getRGB()));
                            }
                            RGBExpressionViewer.this.colorText.setEnabled(true);
                            return;
                        }
                        String cql = "";
                        if (expr != null) {
                            cql = ECQL.toCQL((Expression)expr);
                        }
                        RGBExpressionViewer.this.colorText.setText(cql);
                        RGBExpressionViewer.this.colorText.setEnabled(false);
                        RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.redSpinner, RGBExpressionViewer.this.redScale, 0);
                        RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.greenSpinner, RGBExpressionViewer.this.greenScale, 0);
                        RGBExpressionViewer.this.refreshSelection(RGBExpressionViewer.this.blueSpinner, RGBExpressionViewer.this.blueScale, 0);
                        RGBExpressionViewer.this.feedbackReplace(expr);
                    }
                    finally {
                        RGBExpressionViewer.this.listen(true);
                    }
                }
            });
        }
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        StructuredSelection structuredSelection;
        Object value;
        if (selection instanceof StructuredSelection && (value = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof Expression) {
            this.setInput((Expression)value);
        }
    }

    public static class Factory
    extends ExpressionViewerFactory {
        @Override
        public int score(ExpressionInput input, Expression expression) {
            Literal literal;
            Color color;
            if (expression instanceof Literal && (color = (Color)(literal = (Literal)expression).evaluate(null, Color.class)) != null) {
                return ViewerFactory.Appropriate.APPROPRIATE.getScore();
            }
            return ViewerFactory.Appropriate.NOT_APPROPRIATE.getScore();
        }

        @Override
        public IExpressionViewer createViewer(Composite parent, int style) {
            return new RGBExpressionViewer(parent, style);
        }
    }
}

