/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import net.refractions.udig.ui.filter.ExpressionInput;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;

public abstract class IExpressionViewer
extends Viewer {
    protected ExpressionInput input;
    protected Expression expression;

    public void setInput(Object expressionInput) {
        if (this.input == expressionInput) {
            return;
        }
        if (this.input != null) {
            if (expressionInput instanceof SimpleFeatureType) {
                this.setInput(new ExpressionInput((SimpleFeatureType)expressionInput));
            } else if (expressionInput instanceof ExpressionInput) {
                this.setInput((ExpressionInput)expressionInput);
            }
        }
    }

    public void setInput(ExpressionInput input) {
        this.input = input;
    }

    public ExpressionInput getInput() {
        return this.input;
    }

    public abstract void refresh();

    public Expression getExpression() {
        return this.expression;
    }

    public ISelection getSelection() {
        if (this.expression != null) {
            return new StructuredSelection((Object)this.expression);
        }
        return StructuredSelection.EMPTY;
    }

    public abstract void setExpression(Expression var1);

    protected void internalUpdate(Expression newExpression) {
        String after;
        if (this.expression == newExpression) {
            return;
        }
        String before = this.expression != null ? ECQL.toCQL((Expression)this.expression) : "(empty)";
        String string = after = newExpression != null ? ECQL.toCQL((Expression)newExpression) : "(empty)";
        if (!Utilities.equals((Object)before, (Object)after)) {
            this.expression = newExpression;
            this.feedback();
            StructuredSelection selection = newExpression != null ? new StructuredSelection((Object)newExpression) : StructuredSelection.EMPTY;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        StructuredSelection sel;
        Object element;
        if (selection != null && selection instanceof StructuredSelection && (element = (sel = (StructuredSelection)selection).getFirstElement()) instanceof Expression) {
            this.setExpression((Expression)element);
            return;
        }
        this.setExpression(Expression.NIL);
    }

    protected void feedback() {
        if (this.input != null && this.input.getFeedback() != null) {
            this.input.getFeedback().hide();
        }
    }

    protected void feedbackReplace(Expression expression) {
        String cql = "";
        if (expression != null) {
            cql = ECQL.toCQL((Expression)expression);
        }
        this.feedback("Unable to display dynamic expression: \n" + cql + "\nEdit to replace expression.");
    }

    protected void feedback(String warning) {
        Control control;
        if (this.input != null && this.input.getFeedback() != null) {
            ControlDecoration feedback = this.input.getFeedback();
            feedback.setDescriptionText(warning);
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration errorDecoration = decorations.getFieldDecoration("DEC_WARNING");
            feedback.setImage(errorDecoration.getImage());
            feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(warning);
        }
    }

    protected void feedback(String warning, boolean isRequired) {
        if (isRequired) {
            Control control;
            if (this.input != null && this.input.getFeedback() != null) {
                ControlDecoration feedback = this.input.getFeedback();
                feedback.setDescriptionText(warning);
                FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
                if (isRequired) {
                    FieldDecoration requiredDecoration = decorations.getFieldDecoration("DEC_REQUIRED");
                    feedback.setImage(requiredDecoration.getImage());
                } else {
                    FieldDecoration warningDecoration = decorations.getFieldDecoration("DEC_WARNING");
                    feedback.setImage(warningDecoration.getImage());
                }
                feedback.show();
            }
            if ((control = this.getControl()) != null && !control.isDisposed()) {
                control.setToolTipText(warning);
            }
        } else {
            this.feedback(warning);
        }
    }

    protected void feedback(String error, Throwable exception) {
        Control control;
        if (this.input != null && this.input.getFeedback() != null) {
            ControlDecoration feedback = this.input.getFeedback();
            feedback.setDescriptionText(error);
            FieldDecorationRegistry decorations = FieldDecorationRegistry.getDefault();
            FieldDecoration warningDecoration = decorations.getFieldDecoration("DEC_WARNING");
            feedback.setImage(warningDecoration.getImage());
            feedback.show();
        }
        if ((control = this.getControl()) != null && !control.isDisposed()) {
            control.setToolTipText(String.valueOf(error) + ":" + exception);
        }
    }
}

