/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.filter.CQLFilterViewer;
import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewerFactory;
import net.refractions.udig.ui.filter.IFilterViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.PageBook;
import org.opengis.filter.Filter;

public class FilterViewer
extends IFilterViewer {
    protected IFilterViewer delegate;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Filter delegateFilter = FilterViewer.this.delegate.getFilter();
            FilterViewer.this.internalUpdate(delegateFilter);
        }
    };
    Composite control;
    private PageBook pageBook;
    private String viewerId;
    private int style;
    private SelectionListener menuListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.widget;
            Object data = menuItem.getData();
            boolean selected = menuItem.getSelection();
            if (selected && data instanceof String) {
                FilterViewer.this.showViewer((String)data);
            }
            if (selected && data instanceof ContributionItem) {
                ContributionItem item = (ContributionItem)data;
                FilterViewer.this.showViewer(item.getId());
            }
        }
    };
    private HashMap<String, IFilterViewer> pages;
    private Label placeholder;
    private Label config;
    public static final String FILTER_VIEWER_EXTENSION = "net.refractions.udig.ui.filterViewer";
    private static List<FilterViewerFactory> filterViewerFactoryList;

    public FilterViewer(Composite parent) {
        this(parent, -1);
    }

    public FilterViewer(Composite parent, int style) {
        this.control = new Composite(parent, 16){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                FilterViewer.this.config.setEnabled(enabled);
                if (FilterViewer.this.delegate != null) {
                    FilterViewer.this.config.setEnabled(enabled);
                }
                if (FilterViewer.this.input != null && FilterViewer.this.input.getFeedback() != null && FilterViewer.this.input.getFeedback().getControl() != null) {
                    Control feedbackLabel = FilterViewer.this.input.getFeedback().getControl();
                    Display display = feedbackLabel.getDisplay();
                    feedbackLabel.setEnabled(enabled);
                    if (enabled) {
                        feedbackLabel.setForeground(display.getSystemColor(30));
                    } else {
                        feedbackLabel.setForeground(display.getSystemColor(33));
                    }
                }
            }
        };
        this.control.setLayout((Layout)new MigLayout("insets 0", "[fill][]", "[fill]"));
        this.pageBook = new PageBook(this.control, 16);
        this.pageBook.setLayoutData((Object)"cell 0 0,grow,width 200:100%:100%,height 18:75%:100%");
        this.placeholder = new Label((Composite)this.pageBook, 4);
        this.placeholder.setText("Choose filter editor");
        this.delegate = new CQLFilterViewer((Composite)this.pageBook, style);
        this.delegate.addSelectionChangedListener(this.listener);
        this.pageBook.showPage(this.delegate.getControl());
        this.pages = new HashMap();
        this.pages.put("net.refractions.udig.ui.filter.cqlFilterViewer", this.delegate);
        this.config = new Label(this.control, 4);
        this.config.setImage(JFaceResources.getImage((String)"popup_menu_image"));
        this.config.setLayoutData((Object)"cell 1 0,aligny top,height 16!, width 16!");
        this.createContextMenu((Control)this.config);
        this.config.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Menu menu = FilterViewer.this.config.getMenu();
                if (menu != null) {
                    menu.setVisible(true);
                }
            }
        });
        this.style = style;
    }

    protected void showViewer(String newViewerId) {
        if (newViewerId == null) {
            newViewerId = "net.refractions.udig.ui.filter.cqlFilterViewer";
        }
        this.viewerId = newViewerId;
        IFilterViewer viewer = this.getViewer(this.viewerId);
        if (viewer == this.delegate) {
            return;
        }
        String cqlText = null;
        if (this.delegate instanceof CQLFilterViewer) {
            CQLFilterViewer cqlViewer = (CQLFilterViewer)this.delegate;
            cqlText = cqlViewer.text.getText();
        }
        if (viewer == null) {
            this.pageBook.showPage((Control)this.placeholder);
        } else {
            this.feedback();
            FilterInput currentInput = this.getInput();
            Filter currentFilter = this.getFilter();
            viewer.setInput(currentInput);
            viewer.setFilter(currentFilter);
            viewer.refresh();
            if (cqlText != null && viewer instanceof CQLFilterViewer) {
                CQLFilterViewer cqlViewer = (CQLFilterViewer)viewer;
                cqlViewer.text.setText(cqlText);
            }
            this.pageBook.showPage(viewer.getControl());
            viewer.addSelectionChangedListener(this.listener);
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.listener);
            this.delegate.setInput(null);
        }
        this.delegate = viewer;
    }

    private IFilterViewer getViewer(String lookupId) {
        IFilterViewer viewer = this.pages.get(lookupId);
        if (viewer != null) {
            return viewer;
        }
        for (FilterViewerFactory factory : FilterViewer.filterViewerFactoryList()) {
            if (!factory.getId().equals(lookupId)) continue;
            viewer = factory.createViewer((Composite)this.pageBook, this.style);
            this.pages.put(factory.getId(), viewer);
            return viewer;
        }
        return null;
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void refresh() {
        List<FilterViewerFactory> list;
        if (this.viewerId == null && this.getInput() != null && this.getInput().getViewerId() != null) {
            this.showViewer(this.getInput().getViewerId());
        }
        if (this.delegate != null) {
            this.delegate.refresh();
        }
        if (!(list = FilterViewer.filterViewerFactory(this.getInput(), this.getFilter())).isEmpty()) {
            FilterViewerFactory factory = list.get(0);
            this.showViewer(factory.getId());
        }
    }

    @Override
    public void setInput(Object filterInput) {
        super.setInput(filterInput);
        if (this.delegate != null) {
            this.delegate.setInput(filterInput);
        }
    }

    @Override
    public void setFilter(Filter filter) {
        if (this.filter == filter) {
            return;
        }
        this.filter = filter;
        if (this.delegate != null && this.delegate.getControl() != null && !this.delegate.getControl().isDisposed()) {
            try {
                this.delegate.removeSelectionChangedListener(this.listener);
                this.delegate.setFilter(filter);
            }
            finally {
                this.delegate.addSelectionChangedListener(this.listener);
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private void createContextMenu(Control control) {
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int current = -1;
                for (FilterViewerFactory factory : FilterViewer.filterViewerFactory(FilterViewer.this.getInput(), FilterViewer.this.getFilter())) {
                    int currentScore = factory.appropriate(FilterViewer.this.getInput(), FilterViewer.this.getFilter());
                    int category = FilterViewerFactory.toCategory(currentScore);
                    if (current == -1) {
                        current = category;
                    } else if (current != category) {
                        menuManager.add((IContributionItem)new Separator("appropriate " + current));
                        current = category;
                    }
                    FilterViewerFactoryContributionItem contributionItem = new FilterViewerFactoryContributionItem(factory);
                    menuManager.add((IContributionItem)contributionItem);
                }
            }
        });
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    private static List<FilterViewerFactory> filterViewerFactory(final FilterInput input, final Filter filter) {
        ArrayList<FilterViewerFactory> list = new ArrayList<FilterViewerFactory>(FilterViewer.filterViewerFactoryList());
        Collections.sort(list, new Comparator<FilterViewerFactory>(){

            @Override
            public int compare(FilterViewerFactory factory1, FilterViewerFactory factory2) {
                int factory1Score = factory1.appropriate(input, filter);
                int factory2Score = factory2.appropriate(input, filter);
                return factory2Score - factory1Score;
            }
        });
        return list;
    }

    private static synchronized List<FilterViewerFactory> filterViewerFactoryList() {
        if (filterViewerFactoryList == null) {
            IConfigurationElement[] configurationElements;
            ArrayList<FilterViewerFactory> list = new ArrayList<FilterViewerFactory>();
            IExtensionRegistry registery = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registery.getExtensionPoint(FILTER_VIEWER_EXTENSION);
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configuration = iConfigurationElementArray[n2];
                if ("filterViewer".equals(configuration.getName())) {
                    try {
                        FilterViewerFactory factory = (FilterViewerFactory)configuration.createExecutableExtension("class");
                        factory.init(configuration);
                        list.add(factory);
                    }
                    catch (CoreException e) {
                        String pluginId = configuration.getContributor().getName();
                        Status status = new Status(2, pluginId, e.getMessage(), (Throwable)e);
                        UiPlugin.log((IStatus)status);
                    }
                }
                ++n2;
            }
            filterViewerFactoryList = Collections.unmodifiableList(list);
        }
        return filterViewerFactoryList;
    }

    class FilterViewerFactoryContributionItem
    extends ContributionItem {
        private FilterViewerFactory factory;

        FilterViewerFactoryContributionItem(FilterViewerFactory factory) {
            this.setId(factory.getId());
            this.factory = factory;
        }

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 16, index);
            item.setText(this.factory.getDisplayName());
            item.setData((Object)this.factory.getId());
            item.setSelection(this.factory.getId().equals(FilterViewer.this.viewerId));
            item.addSelectionListener(FilterViewer.this.menuListener);
            int appropriate = this.factory.appropriate(FilterViewer.this.getInput(), FilterViewer.this.getFilter());
            if (appropriate == 0) {
                item.setEnabled(false);
            }
        }
    }
}

