/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.HashMap;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import net.refractions.udig.ui.filter.CQLExpressionViewer;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewerFactory;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.PageBook;
import org.opengis.filter.expression.Expression;

public class ExpressionViewer
extends IExpressionViewer {
    protected IExpressionViewer delegate;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ExpressionViewer.this.internalUpdate(ExpressionViewer.this.delegate.getExpression());
        }
    };
    Composite control;
    private PageBook pageBook;
    private String viewerId;
    private int style;
    private SelectionListener menuListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.widget;
            Object data = menuItem.getData();
            boolean selected = menuItem.getSelection();
            if (selected && data instanceof String) {
                ExpressionViewer.this.showViewer((String)data);
            }
            if (selected && data instanceof ContributionItem) {
                ContributionItem item = (ContributionItem)data;
                ExpressionViewer.this.showViewer(item.getId());
            }
        }
    };
    private HashMap<String, IExpressionViewer> pages;
    private Label placeholder;
    private Label config;

    public ExpressionViewer(Composite parent) {
        this(parent, -1);
    }

    public ExpressionViewer(Composite parent, int style) {
        this.control = new Composite(parent, 16){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                ExpressionViewer.this.config.setEnabled(enabled);
                if (ExpressionViewer.this.delegate != null) {
                    ExpressionViewer.this.config.setEnabled(enabled);
                }
                if (ExpressionViewer.this.input != null && ExpressionViewer.this.input.getFeedback() != null && ExpressionViewer.this.input.getFeedback().getControl() != null) {
                    ExpressionViewer.this.input.getFeedback().getControl().setEnabled(enabled);
                }
            }
        };
        this.control.setLayout((Layout)new MigLayout("insets 0", "[fill][]", "[fill]"));
        this.pageBook = new PageBook(this.control, 16);
        this.pageBook.setLayoutData((Object)"cell 0 0,grow,width 200:100%:100%,height 18:75%:100%");
        this.placeholder = new Label((Composite)this.pageBook, 4);
        this.placeholder.setText("Choose expression editor");
        this.delegate = new CQLExpressionViewer((Composite)this.pageBook, style);
        this.delegate.addSelectionChangedListener(this.listener);
        this.pageBook.showPage(this.delegate.getControl());
        this.pages = new HashMap();
        this.pages.put("net.refractions.udig.ui.filter.cqlExpressionViewer", this.delegate);
        this.config = new Label(this.control, 4);
        this.config.setImage(JFaceResources.getImage((String)"popup_menu_image"));
        this.config.setLayoutData((Object)"cell 1 0,aligny top,height 16!, width 16!");
        this.createContextMenu((Control)this.config);
        this.config.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Menu menu = ExpressionViewer.this.config.getMenu();
                if (menu != null) {
                    menu.setVisible(true);
                }
            }
        });
        this.style = style;
    }

    protected void showViewer(String newViewerId) {
        if (newViewerId == null) {
            newViewerId = "net.refractions.udig.ui.cqlExpressionViewer";
        }
        this.viewerId = newViewerId;
        IExpressionViewer viewer = this.getViewer(this.viewerId);
        String cqlText = null;
        if (this.delegate instanceof CQLExpressionViewer) {
            CQLExpressionViewer cqlViewer = (CQLExpressionViewer)this.delegate;
            cqlText = cqlViewer.text.getText();
        }
        if (viewer == null) {
            this.pageBook.showPage((Control)this.placeholder);
        } else {
            this.feedback();
            ExpressionInput currentInput = this.getInput();
            Expression currentExpression = this.getExpression();
            viewer.setInput(currentInput);
            viewer.setExpression(currentExpression);
            viewer.refresh();
            viewer.getControl().getParent().layout();
            if (cqlText != null && viewer instanceof CQLExpressionViewer) {
                CQLExpressionViewer cqlViewer = (CQLExpressionViewer)viewer;
                cqlViewer.text.setText(cqlText);
            }
            this.pageBook.showPage(viewer.getControl());
            viewer.addSelectionChangedListener(this.listener);
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.listener);
            this.delegate.setInput(null);
        }
        this.delegate = viewer;
    }

    private IExpressionViewer getViewer(String lookupId) {
        IExpressionViewer viewer = this.pages.get(lookupId);
        if (viewer != null) {
            return viewer;
        }
        for (ExpressionViewerFactory factory : ExpressionViewerFactory.factoryList()) {
            if (!factory.getId().equals(lookupId)) continue;
            viewer = factory.createViewer((Composite)this.pageBook, this.style);
            this.pages.put(factory.getId(), viewer);
            return viewer;
        }
        return null;
    }

    public String getViewerId() {
        return this.viewerId;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void refresh() {
        List<ExpressionViewerFactory> list;
        if (this.viewerId == null && this.getInput() != null && this.getInput().getViewerId() != null) {
            this.showViewer(this.getInput().getViewerId());
        }
        if (this.delegate != null) {
            this.delegate.refresh();
        }
        if (!(list = ExpressionViewerFactory.factoryList(this.getInput(), this.getExpression())).isEmpty()) {
            ExpressionViewerFactory factory = list.get(0);
            this.showViewer(factory.getId());
        }
    }

    @Override
    public void setInput(Object expressionInput) {
        super.setInput(expressionInput);
        if (this.delegate != null) {
            this.delegate.setInput(expressionInput);
        }
    }

    @Override
    public void setExpression(Expression expression) {
        if (this.expression == expression) {
            return;
        }
        this.expression = expression;
        if (this.delegate != null && this.delegate.getControl() != null && !this.delegate.getControl().isDisposed()) {
            try {
                this.delegate.removeSelectionChangedListener(this.listener);
                this.delegate.setExpression(expression);
            }
            finally {
                this.delegate.addSelectionChangedListener(this.listener);
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private void createContextMenu(Control control) {
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ViewerFactory.Appropriate current = null;
                for (ExpressionViewerFactory factory : ExpressionViewerFactory.factoryList(ExpressionViewer.this.getInput(), ExpressionViewer.this.getExpression())) {
                    int currentScore = factory.score(ExpressionViewer.this.getInput(), ExpressionViewer.this.getExpression());
                    ViewerFactory.Appropriate category = ViewerFactory.Appropriate.valueOf(currentScore);
                    if (current == null) {
                        current = category;
                    } else if (current != category) {
                        menuManager.add((IContributionItem)new Separator(current.name()));
                        current = category;
                    }
                    ExpressionViewerFactoryContributionItem contributionItem = new ExpressionViewerFactoryContributionItem(factory);
                    menuManager.add((IContributionItem)contributionItem);
                }
            }
        });
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    class ExpressionViewerFactoryContributionItem
    extends ContributionItem {
        private ExpressionViewerFactory factory;

        ExpressionViewerFactoryContributionItem(ExpressionViewerFactory factory) {
            this.setId(factory.getId());
            this.factory = factory;
        }

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 16, index);
            item.setText(this.factory.getDisplayName());
            item.setData((Object)this.factory.getId());
            item.setSelection(this.factory.getId().equals(ExpressionViewer.this.viewerId));
            item.addSelectionListener(ExpressionViewer.this.menuListener);
            int score = this.factory.score(ExpressionViewer.this.getInput(), ExpressionViewer.this.getExpression());
            if (ViewerFactory.Appropriate.valueOf(score) == ViewerFactory.Appropriate.NOT_APPROPRIATE) {
                item.setEnabled(false);
            }
        }
    }
}

