/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui.filter;

import java.util.TreeSet;
import net.refractions.udig.ui.filter.ExpressionInput;
import net.refractions.udig.ui.filter.ExpressionViewerFactory;
import net.refractions.udig.ui.filter.FunctionContentProposalProvider;
import net.refractions.udig.ui.filter.IExpressionViewer;
import net.refractions.udig.ui.filter.ViewerFactory;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.filter.expression.Expression;

public class CQLExpressionViewer
extends IExpressionViewer {
    protected Text text;
    private FunctionContentProposalProvider proposalProvider;

    protected void setPreferredTextSize(int numberOfColumns, int numberOfRows) {
        GC gc = new GC((Drawable)this.text);
        FontMetrics fm = gc.getFontMetrics();
        int width = 30 * fm.getAverageCharWidth();
        int height = fm.getHeight();
        gc.dispose();
        this.text.setSize(this.text.computeSize(width, height));
    }

    public CQLExpressionViewer(Composite parent, int style) {
        int textStyle;
        boolean isReadOnly;
        boolean bl = isReadOnly = (style & 8) != 0;
        if ((style & 4) != 0) {
            textStyle = 2052;
            if (isReadOnly) {
                textStyle |= 8;
            }
            this.text = new Text(parent, textStyle);
            this.setPreferredTextSize(30, 1);
        } else if ((style & 2) != 0) {
            textStyle = 2626;
            if (isReadOnly) {
                textStyle |= 8;
            }
            this.text = new Text(parent, textStyle);
            this.setPreferredTextSize(60, 3);
        } else {
            this.text = new Text(parent, 2052);
            this.setPreferredTextSize(30, 1);
        }
        this.text.setEditable(!isReadOnly);
        this.proposalProvider = new FunctionContentProposalProvider(false);
        TextContentAdapter contentAdapter = new TextContentAdapter();
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)this.proposalProvider, null, null);
        adapter.setProposalAcceptanceStyle(1);
        adapter.setPopupSize(new Point(400, 300));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CQLExpressionViewer.this.changed();
            }
        });
    }

    public Control getControl() {
        return this.text;
    }

    protected void changed() {
        Expression parsedFilter = this.validate();
        if (parsedFilter != null) {
            this.internalUpdate(parsedFilter);
        }
    }

    protected Expression toExpression(String txt) throws CQLException {
        if (txt == null) {
            return null;
        }
        if ("".equals(txt.trim())) {
            return Expression.NIL;
        }
        return ECQL.toExpression((String)txt);
    }

    protected String toCQL(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression == Expression.NIL) {
            return "";
        }
        return ECQL.toCQL((Expression)expression);
    }

    protected Expression validate() {
        Expression parsedExpr;
        try {
            parsedExpr = this.toExpression(this.text.getText());
        }
        catch (CQLException e) {
            this.feedback(e.getLocalizedMessage(), e);
            return null;
        }
        if ((parsedExpr == null || parsedExpr == Expression.NIL) && this.input != null && this.input.isRequired()) {
            this.feedback("Required", true);
            return null;
        }
        this.feedback();
        return parsedExpr;
    }

    @Override
    public void refresh() {
        if (this.input != null) {
            TreeSet<String> names = new TreeSet<String>(this.input.toPropertyList());
            this.proposalProvider.setExtra(names);
        }
        this.refreshText();
    }

    @Override
    public void setExpression(Expression expression) {
        if (this.expression == expression) {
            return;
        }
        this.expression = expression;
        this.refreshText();
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private void refreshText() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CQLExpressionViewer.this.text == null || CQLExpressionViewer.this.text.isDisposed()) {
                        return;
                    }
                    if (CQLExpressionViewer.this.expression == null) {
                        CQLExpressionViewer.this.text.setText("");
                        CQLExpressionViewer.this.feedback("Empty");
                    } else {
                        String cql = CQLExpressionViewer.this.toCQL(CQLExpressionViewer.this.expression);
                        CQLExpressionViewer.this.text.setText(cql);
                        CQLExpressionViewer.this.feedback();
                    }
                }
            });
        }
    }

    public static class Factory
    extends ExpressionViewerFactory {
        @Override
        public int score(ExpressionInput input, Expression expression) {
            return ViewerFactory.Appropriate.COMPLETE.getScore();
        }

        @Override
        public IExpressionViewer createViewer(Composite parent, int style) {
            return new CQLExpressionViewer(parent, style);
        }
    }
}

