/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Collections;
import java.util.List;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.MenuBuilder;
import net.refractions.udig.ui.action.NewObjectContribution;
import net.refractions.udig.ui.action.NewObjectDelegate;
import net.refractions.udig.ui.action.NewObjectDelegateComparator;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;

public class UDIGMenuBuilder
implements MenuBuilder {
    @Override
    public void fillMenuBar(IMenuManager menuBar, IWorkbenchWindow window) {
        IMenuManager helpMenu;
        IMenuManager windowMenu;
        IMenuManager editMenu;
        IMenuManager fileMenu = menuBar.findMenuUsingPath("file");
        if (fileMenu == null) {
            fileMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_file, "file");
            if (menuBar.getItems().length > 0) {
                menuBar.insertBefore(menuBar.getItems()[0].getId(), (IContributionItem)fileMenu);
            } else {
                menuBar.add((IContributionItem)fileMenu);
            }
        }
        if ((editMenu = menuBar.findMenuUsingPath("edit")) == null) {
            editMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_edit, "edit");
            menuBar.insertAfter("file", (IContributionItem)editMenu);
        }
        if (menuBar.findUsingPath("additions") == null) {
            menuBar.insertAfter("edit", (IContributionItem)new GroupMarker("additions"));
        }
        if ((windowMenu = menuBar.findMenuUsingPath("window")) == null) {
            windowMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_window, "window");
            menuBar.insertAfter("additions", (IContributionItem)windowMenu);
        }
        if ((helpMenu = menuBar.findMenuUsingPath("help")) == null) {
            helpMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_help, "help");
            menuBar.insertAfter("window", (IContributionItem)helpMenu);
        }
        this.fillFileMenu(window, fileMenu);
        this.fillEditMenu(window, editMenu);
        this.fillWindowMenu(window, windowMenu);
        this.fillHelpMenu(window, helpMenu);
        UiPlugin.getDefault().getOperationMenuFactory().setWindow(window);
        menuBar.insertBefore("additions", (IContributionItem)UiPlugin.getDefault().getOperationMenuFactory().getMenu());
        menuBar.insertBefore("additions", (IContributionItem)this.createNavigationMenu());
        menuBar.insertBefore("additions", (IContributionItem)this.createLayerMenu());
        menuBar.insertBefore("additions", (IContributionItem)this.createToolMenu());
        UiPlugin.getDefault().getOperationMenuFactory().contributeActions(menuBar);
    }

    @Override
    public void fillCoolBar(ICoolBarManager coolBar, IWorkbenchWindow window) {
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)this.createFileBar(window), "org.eclipse.ui.workbench.file"));
    }

    private ToolBarManager createFileBar(IWorkbenchWindow window) {
        ToolBarManager toolbar = new ToolBarManager(0x800000);
        toolbar.add((IContributionItem)new NewObjectContribution(window));
        toolbar.add((IAction)ActionFactory.SAVE.create(window));
        toolbar.add((IAction)ActionFactory.SAVE_ALL.create(window));
        toolbar.add((IContributionItem)new GroupMarker("additions"));
        return toolbar;
    }

    private void setupFileMenuStructure(IMenuManager fileMenu) {
        if (fileMenu.findUsingPath("fileStart") == null) {
            if (fileMenu.getItems().length > 0) {
                fileMenu.insertBefore(fileMenu.getItems()[0].getId(), (IContributionItem)new GroupMarker("fileStart"));
            } else {
                fileMenu.add((IContributionItem)new GroupMarker("fileStart"));
            }
        }
        if (fileMenu.findUsingPath("open.ext") == null) {
            fileMenu.insertAfter("fileStart", (IContributionItem)new GroupMarker("open.ext"));
        }
        if (fileMenu.findUsingPath("close.ext") == null) {
            fileMenu.insertAfter("open.ext", (IContributionItem)new GroupMarker("close.ext"));
        }
        if (fileMenu.findUsingPath("save.ext") == null) {
            fileMenu.insertAfter("close.ext", (IContributionItem)new GroupMarker("save.ext"));
        }
        if (fileMenu.findUsingPath("additions") == null) {
            fileMenu.insertAfter("save.ext", (IContributionItem)new GroupMarker("additions"));
        }
        if (fileMenu.findUsingPath("fileEnd") == null) {
            fileMenu.insertAfter("additions", (IContributionItem)new GroupMarker("fileEnd"));
        }
        fileMenu.insertAfter("open.ext", (IContributionItem)new Separator());
        fileMenu.insertAfter("close.ext", (IContributionItem)new Separator());
        fileMenu.insertAfter("save.ext", (IContributionItem)new Separator());
        fileMenu.insertAfter("additions", (IContributionItem)new Separator());
    }

    private void fillFileMenu(IWorkbenchWindow window, IMenuManager fileMenu) {
        this.setupFileMenuStructure(fileMenu);
        IMenuManager newMenu = fileMenu.findMenuUsingPath(ActionFactory.NEW.getId());
        if (newMenu == null) {
            newMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_new, ActionFactory.NEW.getId());
            fileMenu.insertAfter("fileStart", (IContributionItem)newMenu);
        }
        newMenu.add((IContributionItem)new GroupMarker("new.start"));
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.ui.newObjectAction");
        Collections.sort(list, new NewObjectDelegateComparator());
        for (IConfigurationElement element : list) {
            final NewObjectDelegate item = new NewObjectDelegate(element, window);
            Action newAction = new Action(){

                public void runWithEvent(Event event) {
                    item.runAction();
                }
            };
            newAction.setText(item.text);
            newAction.setImageDescriptor(item.icon);
            newMenu.appendToGroup("new.start", (IAction)newAction);
        }
        newMenu.add(ContributionItemFactory.NEW_WIZARD_SHORTLIST.create(window));
        if (fileMenu.findUsingPath(ActionFactory.CLOSE.getId()) == null) {
            ActionFactory.IWorkbenchAction close = ActionFactory.CLOSE.create(window);
            fileMenu.insertAfter("close.ext", (IAction)close);
        }
        if (fileMenu.findUsingPath(ActionFactory.CLOSE_ALL.getId()) == null) {
            ActionFactory.IWorkbenchAction closeAll = ActionFactory.CLOSE_ALL.create(window);
            fileMenu.insertAfter(ActionFactory.CLOSE.getId(), (IAction)closeAll);
        }
        if (fileMenu.findUsingPath(ActionFactory.SAVE.getId()) == null) {
            ActionFactory.IWorkbenchAction save = ActionFactory.SAVE.create(window);
            fileMenu.insertBefore("save.ext", (IAction)save);
        }
        if (fileMenu.findUsingPath(ActionFactory.SAVE_ALL.getId()) == null) {
            ActionFactory.IWorkbenchAction saveAll = ActionFactory.SAVE_ALL.create(window);
            fileMenu.insertBefore("save.ext", (IAction)saveAll);
        }
        fileMenu.insertAfter("save.ext", (IContributionItem)new GroupMarker("commit.exe"));
        fileMenu.insertBefore("fileEnd", (IContributionItem)new GroupMarker("rename.ext"));
        fileMenu.insertAfter("rename.ext", (IContributionItem)new Separator());
        if (fileMenu.findUsingPath(ActionFactory.REFRESH.getId()) == null) {
            fileMenu.insertBefore("additions", (IContributionItem)new GroupMarker(ActionFactory.REFRESH.getId()));
        }
        if (fileMenu.findUsingPath(ActionFactory.IMPORT.getId()) == null) {
            ActionFactory.IWorkbenchAction _import = ActionFactory.IMPORT.create(window);
            fileMenu.insertBefore("fileEnd", (IAction)_import);
            fileMenu.insertAfter(ActionFactory.IMPORT.getId(), (IContributionItem)new Separator());
        }
        if (fileMenu.findUsingPath(ActionFactory.EXPORT.getId()) == null) {
            ActionFactory.IWorkbenchAction _export = ActionFactory.EXPORT.create(window);
            fileMenu.insertBefore("fileEnd", (IAction)_export);
            fileMenu.insertAfter(ActionFactory.EXPORT.getId(), (IContributionItem)new Separator());
        }
        fileMenu.insertBefore("fileEnd", (IContributionItem)new GroupMarker("config.ext"));
        fileMenu.insertAfter("config.ext", (IContributionItem)new Separator());
        if (fileMenu.findUsingPath(ActionFactory.QUIT.getId()) == null) {
            ActionFactory.IWorkbenchAction exit = ActionFactory.QUIT.create(window);
            fileMenu.insertAfter("fileEnd", (IAction)exit);
        }
    }

    private void fillEditMenu(IWorkbenchWindow window, IMenuManager editMenu) {
        if (editMenu.findUsingPath("editStart") == null) {
            if (editMenu.getItems().length > 0) {
                editMenu.insertBefore(editMenu.getItems()[0].getId(), (IContributionItem)new GroupMarker("editStart"));
            } else {
                editMenu.add((IContributionItem)new GroupMarker("editStart"));
            }
        }
        if (editMenu.findUsingPath("undo.ext") == null) {
            editMenu.insertAfter("editStart", (IContributionItem)new GroupMarker("undo.ext"));
        }
        if (editMenu.findUsingPath("cut.ext") == null) {
            editMenu.insertAfter("undo.ext", (IContributionItem)new GroupMarker("cut.ext"));
        }
        if (editMenu.findUsingPath("add.ext") == null) {
            editMenu.insertAfter("cut.ext", (IContributionItem)new GroupMarker("add.ext"));
        }
        if (editMenu.findUsingPath("editEnd") == null) {
            editMenu.insertAfter("add.ext", (IContributionItem)new GroupMarker("editEnd"));
        }
        if (editMenu.findUsingPath("additions") == null) {
            editMenu.insertAfter("editEnd", (IContributionItem)new GroupMarker("additions"));
        }
        editMenu.appendToGroup("undo.ext", (IAction)ActionFactory.UNDO.create(window));
        editMenu.appendToGroup("undo.ext", (IAction)ActionFactory.REDO.create(window));
        editMenu.appendToGroup("cut.ext", (IAction)ActionFactory.CUT.create(window));
        editMenu.appendToGroup("cut.ext", (IAction)ActionFactory.COPY.create(window));
        editMenu.appendToGroup("cut.ext", (IAction)ActionFactory.PASTE.create(window));
        editMenu.appendToGroup("add.ext", (IAction)ActionFactory.DELETE.create(window));
        editMenu.insertAfter("undo.ext", (IContributionItem)new Separator());
        editMenu.insertAfter("cut.ext", (IContributionItem)new Separator());
        editMenu.insertAfter("editEnd", (IContributionItem)new Separator());
    }

    private IMenuManager createLayerMenu() {
        MenuManager menu = new MenuManager(Messages.UDIGWorkbenchAdvisor_layerMenu, "layer");
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("edit.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("mapGraphic.ext"));
        menu.add((IContributionItem)new GroupMarker("mapGraphicOther.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        return menu;
    }

    private IMenuManager createNavigationMenu() {
        MenuManager menu = new MenuManager(Messages.UDIGWorkbenchAdvisor_navigationMenu, "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("zoom.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("bottom"));
        return menu;
    }

    private IMenuManager createToolMenu() {
        MenuManager menu = new MenuManager(Messages.UDIGWorkbenchAdvisor_tools, "tools");
        menu.add((IContributionItem)new GroupMarker("action.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("modal.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        return menu;
    }

    private void fillWindowMenu(IWorkbenchWindow window, IMenuManager windowMenu) {
        IMenuManager viewMenu;
        IMenuManager perspectiveMenu;
        if (windowMenu.findUsingPath(ActionFactory.OPEN_NEW_WINDOW.getId()) == null) {
            ActionFactory.IWorkbenchAction openNewWindow = ActionFactory.OPEN_NEW_WINDOW.create(window);
            openNewWindow.setText(Messages.UDIGWorkbenchAdvisor_newWindow_text);
            if (windowMenu.getItems().length > 0) {
                windowMenu.insertBefore(windowMenu.getItems()[0].getId(), (IAction)openNewWindow);
            } else {
                windowMenu.add((IAction)openNewWindow);
            }
        }
        if ((perspectiveMenu = windowMenu.findMenuUsingPath(ContributionItemFactory.PERSPECTIVES_SHORTLIST.getId())) == null) {
            perspectiveMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_open_perspective, ContributionItemFactory.PERSPECTIVES_SHORTLIST.getId());
            windowMenu.insertAfter(ActionFactory.OPEN_NEW_WINDOW.getId(), (IContributionItem)perspectiveMenu);
            IContributionItem perspectiveList = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
            perspectiveMenu.add(perspectiveList);
        }
        if ((viewMenu = windowMenu.findMenuUsingPath(ContributionItemFactory.VIEWS_SHORTLIST.getId())) == null) {
            viewMenu = new MenuManager(Messages.UDIGWorkbenchAdvisor_show_view, ContributionItemFactory.VIEWS_SHORTLIST.getId());
            windowMenu.insertAfter(ContributionItemFactory.PERSPECTIVES_SHORTLIST.getId(), (IContributionItem)viewMenu);
            IContributionItem viewList = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
            viewMenu.add(viewList);
        }
        if (windowMenu.findUsingPath(ContributionItemFactory.OPEN_WINDOWS.getId()) == null) {
            windowMenu.add(ContributionItemFactory.OPEN_WINDOWS.create(window));
        }
        if (windowMenu.findUsingPath(ActionFactory.PREFERENCES.getId()) == null) {
            ActionFactory.IWorkbenchAction preferences = ActionFactory.PREFERENCES.create(window);
            preferences.setText(Messages.UDIGWorkbenchAdvisor_preferences_text);
            windowMenu.insertBefore(ContributionItemFactory.OPEN_WINDOWS.getId(), (IAction)preferences);
        }
        if (windowMenu.findUsingPath("additions") == null) {
            windowMenu.insertBefore(ActionFactory.PREFERENCES.getId(), (IContributionItem)new GroupMarker("additions"));
        }
        if (windowMenu.findUsingPath(ActionFactory.CLOSE_ALL_PERSPECTIVES.getId()) == null) {
            ActionFactory.IWorkbenchAction closeAllPerspectives = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
            closeAllPerspectives.setText(Messages.UDIGWorkbenchAdvisor_closeAllPerspectives_text);
            windowMenu.insertBefore("additions", (IAction)closeAllPerspectives);
        }
        if (windowMenu.findUsingPath(ActionFactory.CLOSE_PERSPECTIVE.getId()) == null) {
            ActionFactory.IWorkbenchAction closePerspective = ActionFactory.CLOSE_PERSPECTIVE.create(window);
            closePerspective.setText(Messages.UDIGWorkbenchAdvisor_closePerspective_text);
            windowMenu.insertBefore(ActionFactory.CLOSE_ALL_PERSPECTIVES.getId(), (IAction)closePerspective);
        }
        if (windowMenu.findUsingPath(ActionFactory.RESET_PERSPECTIVE.getId()) == null) {
            ActionFactory.IWorkbenchAction resetPerspective = ActionFactory.RESET_PERSPECTIVE.create(window);
            resetPerspective.setText(Messages.UDIGWorkbenchAdvisor_resetPerspective_text);
            windowMenu.insertBefore(ActionFactory.CLOSE_PERSPECTIVE.getId(), (IAction)resetPerspective);
        }
        windowMenu.insertAfter(ActionFactory.OPEN_NEW_WINDOW.getId(), (IContributionItem)new Separator());
        windowMenu.insertAfter(ContributionItemFactory.VIEWS_SHORTLIST.getId(), (IContributionItem)new Separator());
        windowMenu.insertBefore("additions", (IContributionItem)new Separator());
        windowMenu.insertAfter("additions", (IContributionItem)new Separator());
    }

    private void fillHelpMenu(IWorkbenchWindow window, IMenuManager helpMenu) {
        if (helpMenu.findUsingPath(ActionFactory.INTRO.getId()) == null) {
            ActionFactory.IWorkbenchAction welcome = ActionFactory.INTRO.create(window);
            welcome.setText(Messages.UDIGWorkbenchAdvisor_welcome_text);
            if (helpMenu.getItems().length > 0) {
                helpMenu.insertBefore(helpMenu.getItems()[0].getId(), (IAction)welcome);
            } else {
                helpMenu.add((IAction)welcome);
            }
        }
        if (helpMenu.findUsingPath("helpStart") == null) {
            helpMenu.insertAfter(ActionFactory.INTRO.getId(), (IContributionItem)new GroupMarker("helpStart"));
        }
        if (helpMenu.findUsingPath(ActionFactory.HELP_CONTENTS.getId()) == null) {
            ActionFactory.IWorkbenchAction helpContents = ActionFactory.HELP_CONTENTS.create(window);
            helpContents.setText(Messages.UDIGWorkbenchAdvisor_helpContents_text);
            helpMenu.insertBefore("helpStart", (IAction)helpContents);
        }
        if (helpMenu.findUsingPath("helpEnd") == null) {
            helpMenu.insertAfter("helpStart", (IContributionItem)new GroupMarker("helpEnd"));
        }
        if (helpMenu.findUsingPath("additions") == null) {
            helpMenu.insertAfter("helpEnd", (IContributionItem)new GroupMarker("additions"));
        }
        helpMenu.insertAfter(ActionFactory.INTRO.getId(), (IContributionItem)new Separator());
        helpMenu.insertBefore("helpStart", (IContributionItem)new Separator());
        helpMenu.insertAfter("helpEnd", (IContributionItem)new Separator());
        if (helpMenu.findUsingPath(ActionFactory.ABOUT.getId()) == null) {
            ActionFactory.IWorkbenchAction about = ActionFactory.ABOUT.create(window);
            about.setText(Messages.UDIGWorkbenchAdvisor_aboutUDig_text);
            helpMenu.add((IAction)about);
        }
    }
}

