/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.internal.ui.UDIGControlDragListener;
import net.refractions.udig.internal.ui.UDIGControlDropListener;
import net.refractions.udig.internal.ui.UDIGDNDProcessor;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.internal.ui.UDIGViewerDropAdapter;
import net.refractions.udig.ui.UDIGDropTargetListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

public class UDIGDragDropUtilities {
    public static void addDragDropSupport(StructuredViewer viewer, IDropTargetProvider defaultTarget) {
        UDIGDragDropUtilities.addDragDropSupport(viewer, defaultTarget, true, false);
    }

    public static void addDragDropSupport(StructuredViewer viewer, IDropTargetProvider defaultTarget, boolean showDropFeedback, boolean expandTree) {
        UDIGDragDropUtilities.addDragSupport(viewer.getControl(), (ISelectionProvider)viewer);
        UDIGDragDropUtilities.addDropSupport(viewer, defaultTarget, showDropFeedback, expandTree);
    }

    public static UDIGDropTargetListener addDropSupport(StructuredViewer viewer, IDropTargetProvider defaultTarget) {
        return UDIGDragDropUtilities.addDropSupport(viewer, defaultTarget, true, false);
    }

    public static UDIGDropTargetListener addDropSupport(StructuredViewer viewer, IDropTargetProvider defaultTarget, boolean showDropFeedback, boolean scrollExpandEnabled) {
        int dndOperations = 23;
        Set<Transfer> transfers = UDIGDragDropUtilities.getTransfers();
        UDIGViewerDropAdapter viewerDropAdapter = new UDIGViewerDropAdapter((Viewer)viewer, defaultTarget);
        viewerDropAdapter.setFeedbackEnabled(showDropFeedback);
        viewerDropAdapter.setScrollExpandEnabled(scrollExpandEnabled);
        viewer.addDropSupport(dndOperations, transfers.toArray(new Transfer[transfers.size()]), (DropTargetListener)viewerDropAdapter);
        return viewerDropAdapter;
    }

    public static void addDragDropSupport(Control control, IDropTargetProvider destination, ISelectionProvider source) {
        UDIGDragDropUtilities.addDragSupport(control, source);
        UDIGDragDropUtilities.addDropSupport(control, destination);
    }

    public static DragSourceDescriptor addDragSupport(Control control, ISelectionProvider provider) {
        int dndOperations = 23;
        Set<Transfer> transfers = UDIGDragDropUtilities.getTransfers();
        transfers.remove(FileTransfer.getInstance());
        DragSource dragSource = new DragSource(control, dndOperations);
        DragController dragController = new DragController(dragSource, transfers);
        provider.addSelectionChangedListener((ISelectionChangedListener)dragController);
        dragController.setTransfers((IStructuredSelection)provider.getSelection());
        UDIGControlDragListener controlDragListener = new UDIGControlDragListener(provider);
        dragSource.addDragListener((DragSourceListener)controlDragListener);
        return new DragSourceDescriptor(dragSource, controlDragListener);
    }

    public static DropTargetDescriptor addDropSupport(Control control, IDropTargetProvider destination, UDIGDropHandler dropHandler) {
        int dndOperations = 23;
        Set<Transfer> transfers = UDIGDragDropUtilities.getTransfers();
        DropTarget target = new DropTarget(control, dndOperations);
        target.setTransfer(transfers.toArray(new Transfer[transfers.size()]));
        UDIGControlDropListener controlDropListener = new UDIGControlDropListener(destination, dropHandler);
        target.addDropListener((DropTargetListener)controlDropListener);
        return new DropTargetDescriptor(target, controlDropListener);
    }

    public static DropTargetDescriptor addDropSupport(Control control, IDropTargetProvider destination) {
        return UDIGDragDropUtilities.addDropSupport(control, destination, new UDIGDropHandler());
    }

    public static Set<Transfer> getTransfers() {
        return UDIGDNDProcessor.getTransfers();
    }

    public static void registerUDigDND(IWorkbenchWindowConfigurer configurer) {
        UDIGDragDropUtilities.registerUDigDND(configurer, new UDIGDropHandler());
    }

    public static void registerUDigDND(IWorkbenchWindowConfigurer configurer, UDIGDropHandler dropHandler) {
        Set<Transfer> transfers = UDIGDragDropUtilities.getTransfers();
        for (Transfer transfer : transfers) {
            configurer.addEditorAreaTransfer(transfer);
        }
        configurer.configureEditorAreaDropListener((DropTargetListener)new UDIGControlDropListener(new EditorPlaceholder(), dropHandler));
    }

    public static UDIGControlDropListener getEditorDropListener() {
        return UDIGDragDropUtilities.getEditorDropListener(new UDIGDropHandler());
    }

    public static UDIGControlDropListener getEditorDropListener(UDIGDropHandler dropHandler) {
        return new UDIGControlDropListener(new EditorPlaceholder(), dropHandler);
    }

    private static class DragController
    implements ISelectionChangedListener {
        private static final Transfer[] EMPTY = new Transfer[0];
        private DragSource dragSource;
        private Set<Transfer> transfers;

        public DragController(DragSource dragSourceA, Set<Transfer> transfersA) {
            this.dragSource = dragSourceA;
            this.transfers = transfersA;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() == null) {
                this.dragSource.setTransfer(EMPTY);
            }
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.setTransfers(selection);
        }

        private void setTransfers(IStructuredSelection selection) {
            CopyOnWriteArrayList<Transfer> toSet = new CopyOnWriteArrayList<Transfer>(this.transfers);
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (toSet.isEmpty()) break;
                Object element = iter.next();
                for (Transfer transfer : toSet) {
                    UDIGTransfer t;
                    if (transfer instanceof UDIGTransfer) {
                        t = (UDIGTransfer)transfer;
                        if (t.validate(element)) continue;
                        toSet.remove(t);
                        continue;
                    }
                    if (transfer instanceof TextTransfer) {
                        t = (TextTransfer)transfer;
                        try {
                            t.javaToNative(element, t.getSupportedTypes()[0]);
                        }
                        catch (Exception exception) {
                            toSet.remove(t);
                        }
                    }
                    if (transfer instanceof FileTransfer) {
                        t = (FileTransfer)transfer;
                        try {
                            t.javaToNative(element, t.getSupportedTypes()[0]);
                        }
                        catch (Exception exception) {
                            toSet.remove(t);
                        }
                    }
                    if (transfer instanceof RTFTransfer) {
                        t = (RTFTransfer)transfer;
                        try {
                            t.javaToNative(element, t.getSupportedTypes()[0]);
                        }
                        catch (Exception exception) {
                            toSet.remove(t);
                        }
                    }
                    if (!(transfer instanceof HTMLTransfer)) continue;
                    t = (HTMLTransfer)transfer;
                    try {
                        t.javaToNative(element, t.getSupportedTypes()[0]);
                    }
                    catch (Exception exception) {
                        toSet.remove(t);
                    }
                }
            }
            if (toSet.isEmpty()) {
                this.dragSource.setTransfer(EMPTY);
            } else {
                this.dragSource.setTransfer(toSet.toArray(new Transfer[toSet.size()]));
            }
        }
    }

    public static class DragSourceDescriptor {
        public final DragSource source;
        public final DragSourceListener listener;

        public DragSourceDescriptor(DragSource sourceA, DragSourceListener listenerA) {
            this.source = sourceA;
            this.listener = listenerA;
        }
    }

    public static class DropTargetDescriptor {
        public final DropTarget target;
        public final UDIGDropTargetListener listener;

        public DropTargetDescriptor(DropTarget targetA, UDIGDropTargetListener listenerA) {
            this.target = targetA;
            this.listener = listenerA;
        }
    }

    private static class EditorPlaceholder
    implements IEditorPart,
    IDropTargetProvider {
        private EditorPlaceholder() {
        }

        IEditorPart getEditorPart() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }

        public IEditorInput getEditorInput() {
            return this.getEditorPart() != null ? this.getEditorPart().getEditorInput() : null;
        }

        public IEditorSite getEditorSite() {
            return this.getEditorPart() != null ? this.getEditorPart().getEditorSite() : null;
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            if (this.getEditorPart() != null) {
                this.getEditorPart().init(site, input);
            }
        }

        public void addPropertyListener(IPropertyListener listener) {
            if (this.getEditorPart() != null) {
                this.getEditorPart().addPropertyListener(listener);
            }
        }

        public void createPartControl(Composite parent) {
            if (this.getEditorPart() != null) {
                this.getEditorPart().createPartControl(parent);
            }
        }

        public void dispose() {
            if (this.getEditorPart() != null) {
                this.getEditorPart().dispose();
            }
        }

        public IWorkbenchPartSite getSite() {
            return this.getEditorPart() != null ? this.getEditorPart().getSite() : null;
        }

        public String getTitle() {
            return this.getEditorPart() != null ? this.getEditorPart().getTitle() : null;
        }

        public Image getTitleImage() {
            return this.getEditorPart() != null ? this.getEditorPart().getTitleImage() : null;
        }

        public String getTitleToolTip() {
            return this.getEditorPart() != null ? this.getEditorPart().getTitleToolTip() : null;
        }

        public void removePropertyListener(IPropertyListener listener) {
            if (this.getEditorPart() != null) {
                this.getEditorPart().removePropertyListener(listener);
            }
        }

        public void setFocus() {
            if (this.getEditorPart() != null) {
                this.getEditorPart().setFocus();
            }
        }

        public Object getAdapter(Class adapter) {
            return this.getEditorPart() != null ? this.getEditorPart().getAdapter(adapter) : null;
        }

        public void doSave(IProgressMonitor monitor) {
            if (this.getEditorPart() != null) {
                this.getEditorPart().doSave(monitor);
            }
        }

        public void doSaveAs() {
            if (this.getEditorPart() != null) {
                this.getEditorPart().doSaveAs();
            }
        }

        public boolean isDirty() {
            return this.getEditorPart() != null ? this.getEditorPart().isDirty() : false;
        }

        public boolean isSaveAsAllowed() {
            return this.getEditorPart() != null ? this.getEditorPart().isSaveAsAllowed() : false;
        }

        public boolean isSaveOnCloseNeeded() {
            return this.getEditorPart() != null ? this.getEditorPart().isSaveOnCloseNeeded() : false;
        }

        @Override
        public Object getTarget(DropTargetEvent event) {
            return this;
        }
    }
}

