/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.UDIGDisplaySafeCondition;
import org.eclipse.swt.widgets.Display;

public class UDIGDisplaySafeLock
implements Lock {
    private AtomicInteger lockCount;
    ReentrantLock internalLock;
    volatile Thread lockThread;
    private UDIGDisplaySafeCondition displayCondition;
    private UDIGDisplaySafeCondition condition;
    private static int ID = 0;
    private int id = ID++;

    public UDIGDisplaySafeLock() {
        this.init();
    }

    protected void init() {
        this.lockCount = new AtomicInteger(0);
        this.internalLock = new ReentrantLock();
        this.condition = new UDIGDisplaySafeCondition(new NullLock(this.internalLock));
        this.displayCondition = new UDIGDisplaySafeCondition(new NullLock(this.internalLock));
    }

    public int getHoldCount() {
        this.internalLock.lock();
        try {
            int n = this.lockCount.get();
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public int getWaitQueueLength(Condition condition) {
        this.internalLock.lock();
        try {
            if (condition == null) {
                throw new NullPointerException("Condition cannot be null");
            }
            if (!(condition instanceof UDIGDisplaySafeCondition)) {
                throw new IllegalStateException("Condition is not owned by this lock!");
            }
            UDIGDisplaySafeCondition casted = (UDIGDisplaySafeCondition)condition;
            if (!casted.isOwner(this)) {
                throw new IllegalStateException("Condition is not owned by this lock!");
            }
            int n = casted.getWaitQueueLength();
            return n;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public boolean hasWaiters(Condition condition) {
        this.internalLock.lock();
        try {
            boolean bl = this.getWaitQueueLength(condition) > 0;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public boolean isHeldByCurrentThread() {
        this.internalLock.lock();
        try {
            boolean bl = Thread.currentThread() == this.lockThread;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public boolean isLocked() {
        this.internalLock.lock();
        try {
            boolean bl = this.lockThread != null;
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void lock() {
        try {
            this.lock(false);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("This is illegal, interrupted exception should not occur here.");
        }
    }

    private void lock(boolean allowInterrupts) throws InterruptedException {
        this.internalLock.lock();
        try {
            while (this.lockThread != null && this.lockThread != Thread.currentThread()) {
                this.wait(-1L, null, allowInterrupts);
            }
            this.doLock();
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private void doLock() {
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/udigdisplaysafelock")) {
            UiPlugin.trace(this.getClass(), String.valueOf(Thread.currentThread().getName()) + " is Locking " + this.id + ". Number of entrances: " + (this.lockCount.get() + 1), null);
        }
        if (this.lockCount.compareAndSet(0, 1)) {
            this.lockThread = Thread.currentThread();
        } else if (this.lockThread == Thread.currentThread()) {
            this.lockCount.incrementAndGet();
        } else {
            if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/udigdisplaysafelock")) {
                UiPlugin.trace(this.getClass(), "Illegal state.  Trying to increment lock count even though lock is not held by current Thread.  \n\tcurrentThread = " + Thread.currentThread() + " Lock thread==" + this.lockThread, null);
            }
            throw new IllegalStateException("Illegal state.  Trying to increment lock count even though lock is not held by current Thread.  \n\tcurrentThread = " + Thread.currentThread() + " Lock thread==" + this.lockThread);
        }
    }

    private void wait(long timeout, TimeUnit unit, boolean allowInterrupts) throws InterruptedException {
        if (allowInterrupts && Thread.interrupted()) {
            throw new InterruptedException("Thread has been interrupted");
        }
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/udigdisplaysafelock")) {
            UiPlugin.trace(this.getClass(), String.valueOf(Thread.currentThread().getName()) + " is waiting for Lock " + this.id + ". Interruptible=" + allowInterrupts, null);
        }
        if (Display.getCurrent() != null) {
            this.displayCondition.doAwait(timeout, unit, allowInterrupts);
        } else {
            this.condition.doAwait(timeout, unit, allowInterrupts);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock(true);
    }

    @Override
    public Condition newCondition() {
        this.internalLock.lock();
        try {
            UDIGDisplaySafeCondition uDIGDisplaySafeCondition = new UDIGDisplaySafeCondition(this);
            return uDIGDisplaySafeCondition;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean tryLock() {
        this.internalLock.lock();
        try {
            if (!this.isLocked() || this.isHeldByCurrentThread()) {
                this.lock();
                return true;
            }
            return false;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        this.internalLock.lock();
        try {
            if (this.tryLock()) {
                return true;
            }
            this.wait(timeout, unit, true);
            boolean bl = this.tryLock();
            return bl;
        }
        finally {
            this.internalLock.unlock();
        }
    }

    @Override
    public void unlock() {
        this.internalLock.lock();
        try {
            if (this.lockThread != Thread.currentThread()) {
                throw new IllegalStateException("Current thread does not own lock!  Lock owner == " + this.lockThread);
            }
            if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/udigdisplaysafelock")) {
                UiPlugin.trace(this.getClass(), String.valueOf(Thread.currentThread().getName()) + " is unlocking Lock " + this.id + " remaining holds=" + (this.lockCount.get() - 1), null);
            }
            if (this.lockCount.get() > 0) {
                if (this.displayCondition.getWaitQueueLength() > 0) {
                    this.displayCondition.signal();
                } else {
                    this.condition.signal();
                }
                if (this.lockCount.decrementAndGet() == 0) {
                    this.lockThread = null;
                }
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    private static class NullLock
    extends UDIGDisplaySafeLock {
        public NullLock(ReentrantLock internalLock) {
            this.internalLock = internalLock;
        }

        @Override
        public boolean isHeldByCurrentThread() {
            return true;
        }

        @Override
        public boolean isLocked() {
            return true;
        }

        @Override
        public void unlock() {
            this.internalLock.unlock();
        }

        @Override
        public void lock() {
            this.internalLock.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.internalLock.lockInterruptibly();
        }

        @Override
        protected void init() {
        }
    }
}

