/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.swt.widgets.Display;

class UDIGDisplaySafeCondition
implements Condition {
    private final UDIGDisplaySafeLock owningLock;
    private final Condition nonDisplayCondition;
    private final Condition displayCondition;
    private volatile Set<Thread> displayNotified = new HashSet<Thread>();

    UDIGDisplaySafeCondition(UDIGDisplaySafeLock lock) {
        if (lock == null) {
            throw new NullPointerException("Lock cannot be null");
        }
        this.owningLock = lock;
        this.nonDisplayCondition = this.owningLock.internalLock.newCondition();
        this.displayCondition = this.owningLock.internalLock.newCondition();
    }

    @Override
    public void await() throws InterruptedException {
        this.doAwait(-1L, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean doAwait(long wait, TimeUnit unit, boolean allowInterrupts) throws InterruptedException {
        this.owningLock.internalLock.lock();
        try {
            this.checkState();
            this.owningLock.unlock();
            if (Display.getCurrent() == null) {
                if (!allowInterrupts) {
                    this.nonDisplayCondition.awaitUninterruptibly();
                    return true;
                }
                if (unit == null) {
                    this.nonDisplayCondition.await();
                    return true;
                }
                boolean bl = this.nonDisplayCondition.await(wait, unit);
                return bl;
            }
            boolean bl = this.displayAwait(wait, unit, allowInterrupts) <= 0L;
            return bl;
        }
        finally {
            this.owningLock.lock();
            this.owningLock.internalLock.unlock();
        }
    }

    private long displayAwait(long time, TimeUnit unit, boolean allowInterrupts) throws InterruptedException {
        this.displayNotified.add(Thread.currentThread());
        long start = System.nanoTime();
        long remaining = unit != null ? TimeUnit.NANOSECONDS.convert(time, unit) : -1L;
        long nextInterval = TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS);
        Display current = Display.getCurrent();
        while (nextInterval > 0L && this.displayNotified.contains(Thread.currentThread())) {
            block7: {
                if (unit != null) {
                    nextInterval = Math.min(nextInterval, remaining);
                }
                this.owningLock.internalLock.unlock();
                boolean readAndDispatch = true;
                try {
                    readAndDispatch = current.readAndDispatch();
                }
                catch (Throwable e) {
                    UiPlugin.log("error occurred in a display event", e);
                }
                this.owningLock.internalLock.lock();
                if (!readAndDispatch) {
                    try {
                        this.displayCondition.await(nextInterval, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        if (!allowInterrupts) break block7;
                        throw e;
                    }
                }
            }
            remaining -= System.nanoTime() - start;
        }
        return remaining;
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.doAwait(time, unit, true);
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long remaining = Display.getCurrent() == null ? this.nonDisplayCondition.awaitNanos(nanosTimeout) : this.displayAwait(nanosTimeout, TimeUnit.NANOSECONDS, true);
        return remaining;
    }

    @Override
    public void awaitUninterruptibly() {
        try {
            this.doAwait(-1L, null, false);
        }
        catch (InterruptedException e) {
            throw new Error("This should not be permitted to happen", e);
        }
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        this.checkState();
        long waitTime = deadline.getTime() - System.currentTimeMillis();
        return this.doAwait(waitTime, TimeUnit.MILLISECONDS, true);
    }

    @Override
    public void signal() {
        this.owningLock.internalLock.lock();
        try {
            this.checkState();
            if (!this.displayNotified.isEmpty()) {
                Thread next = this.displayNotified.iterator().next();
                this.displayNotified.remove(next);
                this.displayCondition.signal();
            } else {
                this.nonDisplayCondition.signal();
            }
        }
        finally {
            this.owningLock.internalLock.unlock();
        }
    }

    @Override
    public void signalAll() {
        this.owningLock.internalLock.lock();
        try {
            this.checkState();
            if (!this.displayNotified.isEmpty()) {
                this.displayNotified.clear();
                this.displayCondition.signalAll();
            }
            this.nonDisplayCondition.signalAll();
        }
        finally {
            this.owningLock.internalLock.unlock();
        }
    }

    private void checkState() {
        if (!this.owningLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("current thread does not own lock!!!");
        }
    }

    public int getWaitQueueLength() {
        int count = this.displayNotified.size();
        int i = count + this.owningLock.internalLock.getWaitQueueLength(this.nonDisplayCondition);
        return i;
    }

    public boolean isOwner(UDIGDisplaySafeLock lock) {
        return this.owningLock == lock;
    }
}

