/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class SearchPart
extends ViewPart
implements ISetSelectionTarget {
    protected StructuredViewer viewer;
    protected IAction cancel;
    protected IProgressMonitor searchMonitor;
    protected SashForm splitter;
    protected IMemento save;
    protected Composite parent;
    IDialogSettings settings;
    protected Orientation orientation = Orientation.VERTICAL;
    Orientation currentOrientation;
    private boolean showDetails;
    private ToggleOrientationAction[] toggleOrientationActions;
    private Composite details;
    private IPartListener2 partListener;
    Object filter = null;
    Job looking = new Job(String.valueOf(this.getPartName()) + "..."){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    final ResultSet set = new ResultSet(SearchPart.this);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).SearchPart.this.viewer.setInput(set.results);
                        }
                    });
                    SearchPart.this.searchImplementation(SearchPart.this.filter, monitor, set);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).SearchPart.this.viewer.setSelection(SearchPart.this.getSelection(set.results), SearchPart.this.showSelection());
                        }
                    });
                }
                catch (Throwable throwable) {
                    SearchPart.this.cancel.setEnabled(false);
                }
            }
            finally {
                SearchPart.this.cancel.setEnabled(false);
            }
            return Status.OK_STATUS;
        }
    };

    protected SearchPart(IDialogSettings dialogSettings) {
        this.settings = dialogSettings;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.save = memento;
    }

    public void saveState(IMemento memento) {
        if (this.splitter == null) {
            if (this.save != null) {
                memento.putMemento(this.save);
            }
            return;
        }
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                SearchPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        this.saveSplitterRatio();
        if (this.save != null) {
            this.save.putInteger("orientation", this.orientation.ordinal());
        }
        if (this.orientation != Orientation.AUTOMATIC) {
            this.setOrientation(this.orientation);
        } else {
            if (this.orientation == Orientation.SINGLE) {
                return;
            }
            Point size = this.parent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(Orientation.HORIZONTAL);
                } else {
                    this.setOrientation(Orientation.VERTICAL);
                }
            }
        }
    }

    private void saveSplitterRatio() {
        if (this.splitter != null && !this.splitter.isDisposed()) {
            int[] weigths = this.splitter.getWeights();
            int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
            this.settings.put("ratio" + (Object)((Object)this.orientation), ratio);
        }
    }

    private void restoreSplitterRatio() {
        try {
            Integer ratio = this.settings.getInt("ratio" + (Object)((Object)this.orientation));
            if (ratio == null) {
                return;
            }
            this.splitter.setWeights(new int[]{ratio, 1000 - ratio});
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected void setOrientation(Orientation orientation) {
        if (this.currentOrientation == orientation) {
            return;
        }
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && this.splitter != null && !this.splitter.isDisposed()) {
            if (orientation == Orientation.SINGLE) {
                this.setShowDetails(false);
            } else {
                if (this.currentOrientation == Orientation.SINGLE) {
                    this.setShowDetails(true);
                }
                boolean horizontal = orientation == Orientation.HORIZONTAL;
                this.splitter.setOrientation(horizontal ? 256 : 512);
            }
            this.splitter.layout();
        }
        this.updateCheckedState();
        this.currentOrientation = orientation;
        this.restoreSplitterRatio();
    }

    private void updateCheckedState() {
        ToggleOrientationAction[] toggleOrientationActionArray = this.toggleOrientationActions;
        int n = this.toggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction toggle;
            toggle.setChecked(this.orientation == (toggle = toggleOrientationActionArray[n2]).getOrientation());
            ++n2;
        }
    }

    public void setShowDetails(boolean show) {
        this.showDetails = show;
        this.showOrHideDetails();
    }

    private void showOrHideDetails() {
        if (this.showDetails) {
            this.splitter.setMaximizedControl(null);
        } else {
            this.splitter.setMaximizedControl(this.viewer.getControl());
        }
    }

    public void createPartControl(Composite aParent) {
        this.parent = aParent;
        this.addResizeListener(this.parent);
        this.splitter = new SashForm(this.parent, 256);
        this.viewer = this.createViewer((Composite)this.splitter);
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        this.viewer.addSelectionChangedListener(this.createSelectionListener());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.details = this.createDetails(this.splitter);
        this.initDragAndDrop();
        this.makeActions();
        this.fillViewMenu();
        this.fillActionBars();
        this.initOrientation();
        if (this.save != null) {
            this.restoreState(this.save);
        }
        this.restoreSplitterRatio();
        this.addPartListener();
    }

    private void restoreState(IMemento memento) {
    }

    protected void saveViewSettings() {
        this.saveSplitterRatio();
        this.settings.put("orientation", this.orientation.ordinal());
    }

    private void addPartListener() {
        final String ID = this.getViewSite().getId();
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (ID.equals(partRef.getId())) {
                    SearchPart.this.saveViewSettings();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (ID.equals(partRef.getId())) {
                    SearchPart.this.saveViewSettings();
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
    }

    private void initOrientation() {
        Integer integer;
        this.orientation = Orientation.AUTOMATIC;
        if (this.save != null && (integer = this.save.getInteger("orientation")) != null) {
            this.orientation = Orientation.values()[integer];
        }
        this.currentOrientation = null;
        this.setOrientation(this.orientation);
    }

    protected Composite createDetails(SashForm splitter) {
        return new Composite((Composite)splitter, 0);
    }

    protected Composite getDetails() {
        return this.details;
    }

    protected StructuredViewer createViewer(Composite parent) {
        ListViewer viewer = new ListViewer(parent);
        return viewer;
    }

    protected ISelectionChangedListener createSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    SearchPart.this.showDetail(selection.getFirstElement());
                }
            }
        };
    }

    protected void showDetail(Object selection) {
    }

    protected IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (!$assertionsDisabled && !(newInput instanceof List)) {
                    throw new AssertionError();
                }
            }
        };
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    synchronized void stopSearch() {
        if (this.searchMonitor != null) {
            IProgressMonitor cancelMonitor = this.searchMonitor;
            this.searchMonitor = null;
            cancelMonitor.setCanceled(true);
        }
    }

    protected void initDragAndDrop() {
    }

    protected void makeActions() {
        this.cancel = new Action(){

            public void run() {
                SearchPart.this.stopSearch();
                this.setEnabled(false);
            }
        };
        Messages.initAction(this.cancel, "cancel");
        this.cancel.setEnabled(false);
        this.toggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, Orientation.VERTICAL), new ToggleOrientationAction(this, Orientation.HORIZONTAL), new ToggleOrientationAction(this, Orientation.AUTOMATIC), new ToggleOrientationAction(this, Orientation.SINGLE)};
    }

    protected void fillViewMenu() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add(this.cancel);
        viewMenu.add((IContributionItem)new Separator());
        ToggleOrientationAction[] toggleOrientationActionArray = this.toggleOrientationActions;
        int n = this.toggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction toggle = toggleOrientationActionArray[n2];
            viewMenu.add((IAction)toggle);
            ++n2;
        }
    }

    protected void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.cancel);
    }

    public void quick(String pattern) {
    }

    protected void notifyChange(ResultSet set, final Collection<? extends Object> newObjects) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!newObjects.isEmpty()) {
                    SearchPart.this.viewer.refresh(true);
                }
            }
        });
    }

    protected ISelection getSelection(List<Object> input) {
        if (input.size() > 0) {
            return new StructuredSelection(input.get(0));
        }
        return new StructuredSelection();
    }

    protected boolean showSelection() {
        return true;
    }

    public void search(Object newFilter) {
        if (newFilter == null) {
            this.stopSearch();
            return;
        }
        this.stopSearch();
        this.viewer.setInput(null);
        this.filter = newFilter;
        this.searchMonitor = Platform.getJobManager().createProgressGroup();
        this.searchMonitor.setTaskName(this.getPartName());
        this.looking.setPriority(40);
        this.looking.setProgressGroup(this.searchMonitor, -1);
        this.cancel.setEnabled(true);
        this.looking.schedule();
    }

    protected void searchImplementation(Object filter, IProgressMonitor monitor, ResultSet results) {
    }

    public void selectReveal(ISelection selection) {
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl().isVisible()) {
            this.viewer.getControl().setFocus();
        }
    }

    protected static enum Orientation {
        VERTICAL,
        HORIZONTAL,
        SINGLE,
        AUTOMATIC;

    }

    public static class ResultSet {
        SearchPart owner;
        List<Object> results = new CopyOnWriteArrayList<Object>();
        private int changes = 0;

        private ResultSet(SearchPart owner) {
            this.owner = owner;
        }

        public boolean firstNotification() {
            return this.changes == 1;
        }

        private void notifyChange(Collection<? extends Object> changed) {
            ++this.changes;
            this.owner.notifyChange(this, changed);
        }

        public void add(int arg0, Object arg1) {
            this.results.add(arg0, arg1);
            this.notifyChange(Collections.singleton(arg1));
        }

        public boolean add(Object arg0) {
            boolean add = this.results.add(arg0);
            this.notifyChange(Collections.singleton(arg0));
            return add;
        }

        public boolean addAll(Collection<? extends Object> arg0) {
            boolean addAll = this.results.addAll(arg0);
            this.notifyChange(arg0);
            return addAll;
        }

        public boolean addAll(int arg0, Collection<? extends Object> arg1) {
            boolean addAll = this.results.addAll(arg0, arg1);
            this.notifyChange(arg1);
            return addAll;
        }

        public boolean contains(Object arg0) {
            return this.results.contains(arg0);
        }

        public boolean containsAll(Collection<?> arg0) {
            return this.results.containsAll(arg0);
        }

        public Object get(int arg0) {
            return this.results.get(arg0);
        }

        public int indexOf(Object arg0) {
            return this.results.indexOf(arg0);
        }
    }

    static class ToggleOrientationAction
    extends Action {
        private SearchPart view;
        private Orientation orientation;

        public ToggleOrientationAction(SearchPart searchPart, Orientation orientation) {
            super("", 8);
            Messages.initAction((IAction)this, "orientation_" + orientation.toString().toLowerCase());
            this.view = searchPart;
            this.orientation = orientation;
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public void run() {
            if (this.isChecked()) {
                this.view.orientation = this.orientation;
                this.view.computeOrientation();
            }
        }
    }
}

