/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.OffThreadProgressMonitor;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.WaitCondition;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.geotools.brewer.color.ColorBrewer;

public class PlatformGIS {
    private static ColorBrewer colorBrewer;
    private static ExecutorService executor;

    static {
        executor = Executors.newCachedThreadPool();
    }

    public static void run(IRunnableWithProgress request) {
        Runner runner = new Runner();
        runner.setRequest(request);
        runner.schedule();
    }

    public static void run(IRunnableWithProgress request, IProgressMonitor monitorToUse) {
        Runner runner = new Runner();
        RunnableAndProgress runnable = new RunnableAndProgress(request, monitorToUse);
        runner.setRequest(runnable);
        runner.schedule();
    }

    public static void runBlockingOperation(final IRunnableWithProgress runnable, IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
        final IProgressMonitor monitor = monitor2 == null ? new NullProgressMonitor() : monitor2;
        final InterruptedException[] interruptedException = new InterruptedException[1];
        final InvocationTargetException[] invocationTargetException = new InvocationTargetException[1];
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        final Display display = d;
        final AtomicBoolean done = new AtomicBoolean();
        final Object mutex = new Object();
        done.set(false);
        Future<Object> future = executor.submit(new Callable<Object>(){
            Exception e = new Exception("For debugging");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                block18: {
                    try {
                        runnable.run((IProgressMonitor)new OffThreadProgressMonitor(monitor != null ? monitor : ProgressManager.instance().get(new Object[0]), display));
                    }
                    catch (InvocationTargetException ite) {
                        invocationTargetException[0] = ite;
                        done.set(true);
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notify();
                            break block18;
                        }
                    }
                    catch (InterruptedException ie) {
                        Object object;
                        try {
                            interruptedException[0] = ie;
                            done.set(true);
                            object = mutex;
                        }
                        catch (Throwable throwable) {
                            done.set(true);
                            Object object2 = mutex;
                            synchronized (object2) {
                                mutex.notify();
                            }
                            throw throwable;
                        }
                        synchronized (object) {
                            mutex.notify();
                            break block18;
                        }
                    }
                    done.set(true);
                    Object object = mutex;
                    synchronized (object) {
                        mutex.notify();
                    }
                }
                return null;
            }
        });
        while (!(monitor.isCanceled() || done.get() || Thread.interrupted())) {
            Thread.yield();
            if (Display.getCurrent() == null) {
                PlatformGIS.wait(mutex, 200L);
                continue;
            }
            try {
                if (d.readAndDispatch()) continue;
                PlatformGIS.wait(mutex, 200L);
            }
            catch (Exception e) {
                UiPlugin.log("Error occurred while waiting for an operation to complete", e);
            }
        }
        if (monitor.isCanceled()) {
            future.cancel(true);
        }
        if (interruptedException[0] != null) {
            throw interruptedException[0];
        }
        if (invocationTargetException[0] != null) {
            throw invocationTargetException[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wait(Object mutex, long waitTime) {
        Object object = mutex;
        synchronized (object) {
            try {
                mutex.wait(waitTime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static void run(ISafeRunnable request) {
        Runner runner = new Runner();
        runner.setRequest(request);
        runner.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorBrewer getColorBrewer() {
        Class<ColorBrewer> clazz = ColorBrewer.class;
        synchronized (ColorBrewer.class) {
            if (colorBrewer == null) {
                colorBrewer = ColorBrewer.instance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return colorBrewer;
        }
    }

    public static void syncInDisplayThread(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        PlatformGIS.syncInDisplayThread(display, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncInDisplayThread(Display display, final Runnable runnable) {
        if (Display.getCurrent() != display) {
            final AtomicBoolean done = new AtomicBoolean(false);
            final Object mutex = new Object();
            display.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        done.set(true);
                        Object object = mutex;
                        synchronized (object) {
                            mutex.notify();
                        }
                        throw throwable;
                    }
                    done.set(true);
                    Object object = mutex;
                    synchronized (object) {
                        mutex.notify();
                    }
                }
            });
            while (!done.get() && !Thread.interrupted()) {
                Object object = mutex;
                synchronized (object) {
                    PlatformGIS.wait(mutex, 200L);
                }
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void wait(long interval, long timeout, WaitCondition condition, Object mutex) throws InterruptedException {
        block10: {
            start = System.currentTimeMillis();
            mutex2 = mutex == null ? new Object() : mutex;
            current = Display.getCurrent();
            if (current != null) ** GOTO lbl27
            while (!condition.isTrue()) {
                if (timeout > 0L && System.currentTimeMillis() - start > timeout) {
                    throw new InterruptedException("Timed out waiting for condition " + condition);
                }
                var10_7 = mutex2;
                synchronized (var10_7) {
                    mutex2.wait(interval);
                }
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                Thread.yield();
                if (timeout > 0L && System.currentTimeMillis() - start > timeout) {
                    throw new InterruptedException("Timed out waiting for condition " + condition);
                }
                if (current.readAndDispatch()) continue;
                var10_8 = mutex2;
                synchronized (var10_8) {
                    mutex2.wait(interval);
                    continue;
                }
lbl27:
                // 3 sources

                ** while (!condition.isTrue())
            }
        }
    }

    public static void runInProgressDialog(final String dialogTitle, final boolean showRunInBackground, final IRunnableWithProgress runnable, boolean runASync) {
        Runnable object = new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                    protected void configureShell(Shell shell) {
                        super.configureShell(shell);
                        shell.setText(dialogTitle);
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        if (showRunInBackground) {
                            this.createBackgroundButton(parent);
                        }
                        super.createButtonsForButtonBar(parent);
                    }

                    private void createBackgroundButton(Composite parent) {
                        this.createButton(parent, 14, Messages.PlatformGIS_background, true);
                    }

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 14) {
                            this.getShell().setVisible(false);
                        } else {
                            super.buttonPressed(buttonId);
                        }
                    }
                };
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            try {
                                PlatformGIS.runBlockingOperation(new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        runnable.run(monitor);
                                    }
                                }, monitor);
                            }
                            catch (Exception e) {
                                UiPlugin.log("", e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    UiPlugin.log("", e);
                }
            }
        };
        if (runASync) {
            Display.getDefault().asyncExec(object);
        } else {
            PlatformGIS.syncInDisplayThread(object);
        }
    }

    public static void asyncInDisplayThread(Runnable runnable, boolean executeIfInDisplay) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        PlatformGIS.asyncInDisplayThread(display, runnable, executeIfInDisplay);
    }

    public static void asyncInDisplayThread(Display display, Runnable runnable, boolean executeIfInDisplay) {
        if (executeIfInDisplay && display == Display.getCurrent()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static IAOIService getAOIService() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        return (IAOIService)workbench.getService(IAOIService.class);
    }

    private static class RunnableAndProgress {
        IRunnableWithProgress runnable;
        IProgressMonitor monitor;

        public RunnableAndProgress(IRunnableWithProgress request, IProgressMonitor monitorToUse) {
            this.runnable = request;
            Display display = Display.getCurrent();
            if (display == null) {
                Display.getDefault();
            }
            this.monitor = new OffThreadProgressMonitor(monitorToUse, display);
        }
    }

    private static class Runner
    extends Job {
        Object runnable;

        public Runner() {
            super("Platform GIS runner");
        }

        public void setRequest(Object runnable) {
            this.runnable = runnable;
        }

        private void run(ISafeRunnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                if (e.getMessage() != null) {
                    UiPlugin.log(e.getMessage(), e);
                } else {
                    UiPlugin.log("", e);
                }
                runnable.handleException(e);
            }
        }

        private void run(IRunnableWithProgress runnable, IProgressMonitor monitor) {
            try {
                runnable.run(monitor);
            }
            catch (Throwable t) {
                UiPlugin.log("", t);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!PlatformUI.getWorkbench().isClosing() && this.runnable != null) {
                if (this.runnable instanceof ISafeRunnable) {
                    this.run((ISafeRunnable)this.runnable);
                } else if (this.runnable instanceof IRunnableWithProgress) {
                    this.run((IRunnableWithProgress)this.runnable, monitor);
                } else if (this.runnable instanceof RunnableAndProgress) {
                    RunnableAndProgress request = (RunnableAndProgress)this.runnable;
                    this.run(request.runnable, request.monitor);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

