/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class OffThreadProgressMonitor
implements IProgressMonitor {
    private IProgressMonitor monitor;
    private Display display = Display.getCurrent();
    private Widget widget;

    public OffThreadProgressMonitor(IProgressMonitor part, Display display) {
        this(part);
        this.display = display;
    }

    public OffThreadProgressMonitor(IProgressMonitor monitor2) {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        if (monitor2 instanceof Widget) {
            this.widget = (Widget)monitor2;
            this.display = this.widget.getDisplay();
        }
        this.monitor = monitor2;
    }

    private Runnable runSafely(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        runnable.run();
                    }
                    catch (SWTException e) {
                        if (e.code == 24) break block2;
                        throw e;
                    }
                }
            }
        };
    }

    public void beginTask(final String name, final int totalWork) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OffThreadProgressMonitor.this.monitor.beginTask(name, totalWork);
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }

    public void done() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OffThreadProgressMonitor.this.monitor.done();
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }

    public void internalWorked(final double work) {
        PlatformGIS.asyncInDisplayThread(this.display, new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                OffThreadProgressMonitor.this.monitor.internalWorked(work);
            }
        }, true);
    }

    public boolean isCanceled() {
        final boolean[] cancelled = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                cancelled[0] = OffThreadProgressMonitor.this.monitor.isCanceled();
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
        return cancelled[0];
    }

    public void setCanceled(final boolean value) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                OffThreadProgressMonitor.this.monitor.setCanceled(value);
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }

    public void setTaskName(final String name) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                OffThreadProgressMonitor.this.monitor.setTaskName(name);
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }

    public void subTask(final String name) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                OffThreadProgressMonitor.this.monitor.subTask(name);
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }

    public void worked(final int work) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (OffThreadProgressMonitor.this.widget != null && OffThreadProgressMonitor.this.widget.isDisposed()) {
                    return;
                }
                OffThreadProgressMonitor.this.monitor.worked(work);
            }
        };
        PlatformGIS.asyncInDisplayThread(this.display, this.runSafely(runnable), true);
    }
}

