/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.CRSDialogCellEditor;
import net.refractions.udig.ui.LegalAttributeTypes;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureTypeEditor {
    private static final int MAX_ATTRIBUTE_LENGTH = 0x9FFFFF;
    private static final int NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final int OTHER_COLUMN = 2;
    private static final List<LegalAttributeTypes> TYPES;
    private TreeViewer viewer;
    private IAction createAttributeAction;
    private IAction deleteAttributeAction;
    private Text nameText;
    private List<LegalAttributeTypes> legalTypes = TYPES;
    private SimpleFeatureType featureType;
    private ControlDecoration errorDecorator;

    static {
        ArrayList<LegalAttributeTypes> types = new ArrayList<LegalAttributeTypes>();
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_stringType, String.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_booleanType, Boolean.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_dateType, Date.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_integerType, Integer.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_longType, Long.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_floatType, Float.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_doubleType, Double.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_pointType, Point.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_lineStringType, LineString.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_polygonType, Polygon.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_geometryType, Geometry.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_multiPointType, MultiPoint.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_multiLineStringType, MultiLineString.class));
        types.add(new LegalAttributeTypes(Messages.FeatureTypeEditor_multiPolygonType, MultiPolygon.class));
        TYPES = Collections.unmodifiableList(types);
    }

    public void createTable(Composite parent, Object layoutData) {
        this.createTable(parent, layoutData, this.featureType, true);
    }

    public void createTable(Composite parent, Object layoutData, SimpleFeatureType type) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(type.getName());
        builder.init(type);
        this.createTable(parent, layoutData, builder.buildFeatureType(), true);
    }

    public void createTable(Composite parent, Object layoutData, SimpleFeatureType featureType, boolean editable) {
        this.viewer = new TreeViewer(parent, 65536);
        Tree tree = this.viewer.getTree();
        if (layoutData == null) {
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            tree.setLayoutData(layoutData);
        }
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        tree.setLayout((Layout)tableLayout);
        TreeColumn column = new TreeColumn(tree, 0x1000000);
        column.setResizable(true);
        column.setText(Messages.FeatureTypeEditor_nameColumnName);
        column = new TreeColumn(tree, 0x1000000);
        column.setResizable(true);
        column.setText(Messages.FeatureTypeEditor_typeColumnName);
        column = new TreeColumn(tree, 0x1000000);
        column.setResizable(true);
        this.viewer.setContentProvider((IContentProvider)new FeatureTypeContentProvider(this.viewer));
        this.viewer.setLabelProvider((IBaseLabelProvider)new FeatureTypeLabelProvider());
        this.viewer.setColumnProperties(new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2)});
        this.setEditable(editable);
        this.setFeatureType(featureType);
    }

    public void setLegalTypes(List<LegalAttributeTypes> legalTypes) {
        this.legalTypes = Collections.unmodifiableList(legalTypes);
    }

    public List<LegalAttributeTypes> getLegalTypes() {
        return Collections.unmodifiableList(this.legalTypes);
    }

    public void setEditable(boolean editable) {
        if (editable) {
            Tree tree = this.viewer.getTree();
            String[] comboItems = new String[this.legalTypes.size()];
            int i = 0;
            while (i < comboItems.length) {
                comboItems[i] = this.legalTypes.get(i).getName();
                ++i;
            }
            TextCellEditor attributeNameEditor = new TextCellEditor((Composite)tree);
            ComboBoxCellEditor attributeTypeEditor = new ComboBoxCellEditor((Composite)tree, comboItems, 65544);
            DialogCellEditor crsEditor = this.createCRSEditor(tree);
            this.viewer.setCellEditors(new CellEditor[]{attributeNameEditor, attributeTypeEditor, crsEditor});
            this.viewer.setCellModifier((ICellModifier)new AttributeCellModifier());
        } else {
            this.viewer.setCellEditors(null);
            this.viewer.setCellModifier(null);
        }
    }

    private DialogCellEditor createCRSEditor(Tree tree) {
        return new CRSDialogCellEditor(tree);
    }

    public SimpleFeatureTypeBuilder builderFromFeatureType(SimpleFeatureType ft) {
        SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
        ftB.init(ft);
        ftB.setName(ft.getName());
        return ftB;
    }

    public MenuManager createContextMenu() {
        final MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                contextMenu.add(FeatureTypeEditor.this.getCreateAttributeAction());
                contextMenu.add(FeatureTypeEditor.this.getDeleteAction());
            }
        });
        Menu menu = contextMenu.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getControl().setMenu(menu);
        return contextMenu;
    }

    public void setGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getDeleteAction());
    }

    public void setFeatureType(SimpleFeatureType type) {
        SimpleFeatureTypeBuilder builder = null;
        if (type != null) {
            builder = new SimpleFeatureTypeBuilder();
            builder.init(type);
            builder.setName(type.getName());
            this.featureType = builder.buildFeatureType();
        } else {
            this.featureType = this.createDefaultFeatureType();
        }
        if (this.viewer != null) {
            this.setInput(this.featureType);
        }
    }

    public final void setFeatureTypeBuilder(SimpleFeatureTypeBuilder newBuilder) {
    }

    public SimpleFeatureType createDefaultFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(Messages.FeatureTypeEditor_newFeatureTypeName);
        builder.setCRS(this.getDefaultCRS());
        builder.length(0x9FFFFF).add(Messages.FeatureTypeEditor_defaultNameAttributeName, String.class);
        builder.add(Messages.FeatureTypeEditor_defaultGeometryName, LineString.class);
        return builder.buildFeatureType();
    }

    private CoordinateReferenceSystem getDefaultCRS() {
        String crsInfo = UiPlugin.getDefault().getPreferenceStore().getString("P_DEFAULT_GEOMEMTRY_CRS");
        if (crsInfo != null && crsInfo.trim().length() > 0) {
            try {
                crsInfo = crsInfo.trim();
                if (crsInfo.startsWith("EPSG")) {
                    return CRS.decode((String)crsInfo);
                }
                return CRS.parseWKT((String)crsInfo);
            }
            catch (Throwable t) {
                UiPlugin.log("", t);
            }
        }
        return DefaultGeographicCRS.WGS84;
    }

    public void setDefaultCRS(CoordinateReferenceSystem crs) {
        String crsInfo = null;
        Set identifiers = crs.getIdentifiers();
        for (Identifier identifier : identifiers) {
            if (!identifier.toString().startsWith("EPSG")) continue;
            crsInfo = identifier.toString();
            break;
        }
        if (crsInfo == null) {
            crsInfo = crs.toWKT();
        }
        UiPlugin.getDefault().getPreferenceStore().setValue("P_DEFAULT_GEOMEMTRY_CRS", crsInfo);
        SimpleFeatureTypeBuilder tmpBuilder = new SimpleFeatureTypeBuilder();
        tmpBuilder.init(this.featureType);
        tmpBuilder.setName(this.featureType.getTypeName());
        tmpBuilder.setCRS(crs);
        this.featureType = tmpBuilder.buildFeatureType();
    }

    private void setInput(SimpleFeatureType featureType) {
        this.viewer.setInput((Object)featureType);
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.setText(featureType.getTypeName());
        }
    }

    public synchronized IAction getCreateAttributeAction() {
        if (this.createAttributeAction == null) {
            this.createAttributeAction = new Action(){

                public void runWithEvent(Event event) {
                    SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
                    SimpleFeatureTypeBuilder ftB = FeatureTypeEditor.this.builderFromFeatureType(ft);
                    int index = 0;
                    while (true) {
                        try {
                            ftB.add(String.valueOf(Messages.FeatureTypeEditor_newAttributeTypeDefaultName) + index, String.class);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ++index;
                            continue;
                        }
                        break;
                    }
                    FeatureTypeEditor.this.featureType = ftB.buildFeatureType();
                    FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
                }
            };
            this.createAttributeAction.setId("net.refractions.udig.ui.FeatureTypeEditor.createAttributeAction");
            this.createAttributeAction.setText(Messages.addAttributeAction_label);
            this.createAttributeAction.setToolTipText(Messages.addAttributeAction_label);
            this.createAttributeAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("elcl16/new_attribute.gif"));
        }
        return this.createAttributeAction;
    }

    public synchronized IAction getDeleteAction() {
        if (this.deleteAttributeAction == null) {
            this.deleteAttributeAction = new Action(){

                public void runWithEvent(Event event) {
                    SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
                    SimpleFeatureTypeBuilder ftB = FeatureTypeEditor.this.builderFromFeatureType(ft);
                    IStructuredSelection selection = (IStructuredSelection)FeatureTypeEditor.this.viewer.getSelection();
                    for (AttributeDescriptor element : selection) {
                        ftB.remove(element.getLocalName());
                    }
                    FeatureTypeEditor.this.featureType = ftB.buildFeatureType();
                    FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
                }
            };
            this.deleteAttributeAction.setText(Messages.deleteAttributeAction_label);
            this.deleteAttributeAction.setToolTipText(Messages.deleteAttributeAction_tooltip);
            this.deleteAttributeAction.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("elcl16/delete.gif"));
            this.deleteAttributeAction.setDescription(Messages.deleteAttributeAction_description);
            this.deleteAttributeAction.setId("net.refractions.udig.ui.FeatureTypeEditor.deleteAttributeAction");
        }
        return this.deleteAttributeAction;
    }

    public void createFeatureTypeNameText(Composite parent, Object layoutData) {
        SimpleFeatureType input;
        this.nameText = new Text(parent, 18436);
        this.errorDecorator = new ControlDecoration((Control)this.nameText, 16512);
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        this.errorDecorator.setImage(image);
        if (this.viewer != null && (input = (SimpleFeatureType)this.viewer.getInput()) != null) {
            this.nameText.setText(input.getTypeName());
        }
        if (layoutData != null) {
            this.nameText.setLayoutData(layoutData);
        } else {
            this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.nameText.setFocus();
        class NameListener
        implements KeyListener,
        FocusListener {
            NameListener() {
            }

            public void keyPressed(KeyEvent e) {
                SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
                if (e.character == '\u001b') {
                    FeatureTypeEditor.this.nameText.setText(ft.getTypeName());
                } else if (e.character == '\r') {
                    SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
                    ftB.init(ft);
                    ftB.setName(FeatureTypeEditor.this.nameText.getText());
                    FeatureTypeEditor.this.featureType = ftB.buildFeatureType();
                    FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
                } else {
                    FeatureTypeEditor.this.errorDecorator.hide();
                }
            }

            public void keyReleased(KeyEvent e) {
                SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
                SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
                ftB.init(ft);
                ftB.setName(FeatureTypeEditor.this.nameText.getText());
                FeatureTypeEditor.this.featureType = ftB.buildFeatureType();
                FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
            }

            public void focusGained(FocusEvent e) {
                int end = FeatureTypeEditor.this.nameText.getText().length();
                FeatureTypeEditor.this.nameText.setSelection(0, end);
            }

            public void focusLost(FocusEvent e) {
                SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
                SimpleFeatureTypeBuilder ftB = new SimpleFeatureTypeBuilder();
                ftB.init(ft);
                ftB.setName(FeatureTypeEditor.this.nameText.getText());
                FeatureTypeEditor.this.featureType = ftB.buildFeatureType();
                FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
            }
        }
        NameListener listener = new NameListener();
        this.nameText.addKeyListener((KeyListener)listener);
        this.nameText.addFocusListener((FocusListener)listener);
    }

    public SimpleFeatureType getFeatureType() {
        if (this.viewer == null) {
            return null;
        }
        return (SimpleFeatureType)this.viewer.getInput();
    }

    public SimpleFeatureTypeBuilder getFeatureTypeBuilder() {
        if (this.viewer == null) {
            return null;
        }
        return this.builderFromFeatureType((SimpleFeatureType)this.viewer.getInput());
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public TreeViewer testingGetViewer() {
        return this.viewer;
    }

    public static List<LegalAttributeTypes> testingGetTYPES() {
        return TYPES;
    }

    public Text testingGetNameText() {
        return this.nameText;
    }

    public void builderChanged() {
        this.viewer.refresh();
        if (this.nameText != null && !this.nameText.isDisposed() && this.viewer.getInput() != null) {
            String typeName = ((SimpleFeatureType)this.viewer.getInput()).getTypeName();
            this.nameText.setText(typeName);
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorDecorator.setDescriptionText(errorMessage);
        this.errorDecorator.show();
        this.errorDecorator.showHoverText(errorMessage);
    }

    public class AttributeCellModifier
    implements ICellModifier {
        private Object lastCRS;

        public AttributeCellModifier() {
            this.lastCRS = FeatureTypeEditor.this.getDefaultCRS();
        }

        public boolean canModify(Object element, String property) {
            return !String.valueOf(2).equals(property) || element instanceof GeometryDescriptor;
        }

        public Object getValue(Object element, String property) {
            AttributeDescriptor editElement = (AttributeDescriptor)element;
            switch (Integer.parseInt(property)) {
                case 0: {
                    return editElement.getName().toString();
                }
                case 1: {
                    int i = 0;
                    while (i < FeatureTypeEditor.this.legalTypes.size()) {
                        if (((LegalAttributeTypes)FeatureTypeEditor.this.legalTypes.get(i)).getType() == editElement.getType().getBinding()) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
                case 2: {
                    return ((GeometryDescriptor)element).getCoordinateReferenceSystem();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element == null || property == null || value == null) {
                return;
            }
            AttributeDescriptor editElement = (AttributeDescriptor)((TreeItem)element).getData();
            SimpleFeatureType ft = (SimpleFeatureType)FeatureTypeEditor.this.viewer.getInput();
            AttributeDescriptor newAttr = this.createNewAttributeType(editElement, property, value);
            if (newAttr == null) {
                return;
            }
            int index = 0;
            while (index < ft.getAttributeCount()) {
                if (ft.getDescriptor(index) == editElement) break;
                ++index;
            }
            if (index == ft.getAttributeCount()) {
                return;
            }
            SimpleFeatureTypeBuilder builder = FeatureTypeEditor.this.builderFromFeatureType(ft);
            builder.remove(ft.getDescriptor(index).getLocalName());
            builder.add(index, newAttr);
            FeatureTypeEditor.this.featureType = builder.buildFeatureType();
            FeatureTypeEditor.this.viewer.setInput((Object)FeatureTypeEditor.this.featureType);
        }

        private AttributeDescriptor createNewAttributeType(AttributeDescriptor editElement, String property, Object value) {
            AttributeTypeBuilder builder = new AttributeTypeBuilder();
            builder.init(editElement);
            switch (Integer.parseInt(property)) {
                case 0: {
                    return builder.buildDescriptor((String)value);
                }
                case 1: {
                    int choice = -1;
                    if (value instanceof Integer) {
                        choice = (Integer)value;
                    } else if (value instanceof String) {
                        choice = Integer.parseInt((String)value);
                    }
                    if (choice == -1) {
                        return null;
                    }
                    Class type = ((LegalAttributeTypes)FeatureTypeEditor.this.legalTypes.get(choice)).getType();
                    builder.setBinding(type);
                    return builder.buildDescriptor(editElement.getLocalName());
                }
                case 2: {
                    this.lastCRS = value;
                    CoordinateReferenceSystem crs = (CoordinateReferenceSystem)value;
                    if (FeatureTypeEditor.this.featureType.getGeometryDescriptor() == editElement) {
                        FeatureTypeEditor.this.setDefaultCRS(crs);
                    }
                    builder.setCRS(crs);
                    return builder.buildDescriptor(editElement.getLocalName());
                }
            }
            return null;
        }
    }

    public static class FeatureTypeContentProvider
    implements ITreeContentProvider {
        private TreeViewer viewer;

        public FeatureTypeContentProvider(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SimpleFeatureType) {
                SimpleFeatureType featureType = (SimpleFeatureType)parentElement;
                Object[] attributes = new Object[featureType.getAttributeCount()];
                int i = 0;
                while (i < attributes.length) {
                    attributes[i] = featureType.getDescriptor(i);
                    ++i;
                }
                return attributes;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof AttributeDescriptor) {
                return this.viewer.getInput();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SimpleFeatureType;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }

    public static class FeatureTypeLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider,
    ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            AttributeDescriptor attribute = (AttributeDescriptor)element;
            switch (columnIndex) {
                case 0: {
                    return attribute.getLocalName();
                }
                case 1: {
                    return attribute.getType().getBinding().getSimpleName();
                }
                case 2: {
                    if (!(attribute instanceof GeometryDescriptor)) break;
                    CoordinateReferenceSystem crs = ((GeometryDescriptor)attribute).getCoordinateReferenceSystem();
                    if (crs != null) {
                        return crs.getName().toString();
                    }
                    return "Unspecified";
                }
            }
            return null;
        }
    }
}

