/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.refractions.udig.core.IProvider;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.FeatureTableControl;
import net.refractions.udig.ui.LoadingEvent;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.WaitCondition;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class FeatureTableContentProvider
implements ILazyContentProvider,
IProvider<Collection<SimpleFeature>> {
    private static final IProgressMonitor NULL = new NullProgressMonitor();
    private final FeatureTableControl owningFeatureTableControl;
    private volatile IProgressMonitor monitor = NULL;
    private IProvider<IProgressMonitor> progressMonitorProvider;
    private CollectionListener listener = new CollectionListener(){

        public void collectionChanged(CollectionEvent event) {
            if (FeatureTableContentProvider.this.listener == null) {
                event.getCollection().removeListener((CollectionListener)this);
            }
            SimpleFeature[] changed = event.getFeatures();
            TableViewer viewer = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer();
            switch (event.getEventType()) {
                case 0: {
                    int i = 0;
                    while (i < changed.length) {
                        FeatureTableContentProvider.this.features.add(changed[i]);
                        ++i;
                    }
                    viewer.setItemCount(FeatureTableContentProvider.this.features.size());
                    viewer.getTable().clearAll();
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < changed.length) {
                        Iterator<SimpleFeature> iter = FeatureTableContentProvider.this.features.iterator();
                        while (iter.hasNext()) {
                            if (!iter.next().getID().equals(changed[i].getID())) continue;
                            iter.remove();
                            break;
                        }
                        viewer.setItemCount(FeatureTableContentProvider.this.features.size());
                        viewer.getTable().clearAll();
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i = 0;
                    while (i < changed.length) {
                        ListIterator<SimpleFeature> iter = FeatureTableContentProvider.this.features.listIterator();
                        while (iter.hasNext()) {
                            if (!iter.next().getID().equals(changed[i].getID())) continue;
                            iter.set(changed[i]);
                            break;
                        }
                        ++i;
                    }
                    viewer.getTable().clearAll();
                    break;
                }
            }
        }
    };
    List<SimpleFeature> features = Collections.synchronizedList(new ArrayList());
    Map<String, SimpleFeature> lookup = new HashMap<String, SimpleFeature>();
    private volatile boolean updating = false;
    private boolean disposed = false;

    public FeatureTableContentProvider(FeatureTableControl control, IProvider<IProgressMonitor> progressMonitorProvider) {
        this.owningFeatureTableControl = control;
        this.progressMonitorProvider = progressMonitorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        FeatureTableContentProvider featureTableContentProvider = this;
        synchronized (featureTableContentProvider) {
            FeatureCollection input;
            if (this.monitor != NULL) {
                this.monitor.setCanceled(true);
                UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "#inputChanged(): cancelled monitor", null);
                try {
                    PlatformGIS.wait(500L, -1L, new WaitCondition(){

                        @Override
                        public boolean isTrue() {
                            return FeatureTableContentProvider.this.monitor == NULL;
                        }
                    }, this);
                }
                catch (InterruptedException e) {
                    UiPlugin.log("Interrupted", e);
                    return;
                }
            }
            this.features.clear();
            if (oldInput != null) {
                FeatureCollection old = (FeatureCollection)oldInput;
                old.removeListener(this.listener);
            }
            if (newInput != null) {
                input = (FeatureCollection)newInput;
                input.addListener(this.listener);
            }
            if (newInput == null) {
                return;
            }
            this.monitor = (IProgressMonitor)this.progressMonitorProvider.get(new Object[0]);
            this.monitor.setCanceled(false);
            this.owningFeatureTableControl.message(null);
            this.owningFeatureTableControl.notifyLoadingListeners(new LoadingEvent(false, this.monitor, true));
            input = (FeatureCollection)newInput;
            Display display = Display.getCurrent();
            this.owningFeatureTableControl.message(Messages.FeatureTableContentProvider_loading, display.getSystemColor(29), display.getSystemColor(28));
            PlatformGIS.run(new ContentLoader((FeatureCollection<SimpleFeatureType, SimpleFeature>)input));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        FeatureTableContentProvider featureTableContentProvider = this;
        synchronized (featureTableContentProvider) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        this.features.clear();
        if (this.monitor != NULL) {
            this.monitor.setCanceled(true);
            try {
                PlatformGIS.wait(200L, -1L, new WaitCondition(){

                    @Override
                    public boolean isTrue() {
                        return FeatureTableContentProvider.this.monitor == NULL;
                    }
                }, this);
            }
            catch (InterruptedException e) {
                UiPlugin.log("Interrupted", e);
                return;
            }
        }
    }

    public Collection<SimpleFeature> get(Object ... params) {
        return this.features;
    }

    public void updateElement(int index) {
        if (index >= this.features.size()) {
            this.owningFeatureTableControl.getViewer().replace((Object)"", index);
        } else if (this.monitor != NULL && index == 0 && !this.updating) {
            this.owningFeatureTableControl.getViewer().replace(FeatureTableControl.LOADING, 0);
        } else {
            int resolvedIndex = index;
            if (this.owningFeatureTableControl.getViewer().getTable().getSortDirection() == 128) {
                resolvedIndex = this.features.size() - index - 1;
            }
            SimpleFeature feature = this.features.get(resolvedIndex);
            this.owningFeatureTableControl.getViewer().replace((Object)feature, index);
        }
    }

    public void update(FeatureCollection<SimpleFeatureType, SimpleFeature> features2) throws IllegalArgumentException {
        if (this.features == null) {
            return;
        }
        if (!((SimpleFeatureType)this.owningFeatureTableControl.features.getSchema()).equals((Object)features2.getSchema())) {
            throw new IllegalArgumentException("The feature type of the SimpleFeature Collection passed as a parameter does not have the same feature type as the features in the table so it cannot be used to update the features.");
        }
        ContentUpdater updater = new ContentUpdater(features2);
        PlatformGIS.run(updater);
    }

    SimpleFeature findFeature(String featureId) {
        return this.lookup.get(featureId);
    }

    public void assertInternallyConsistent() {
        if (this.features.size() != this.lookup.size()) {
            throw new AssertionError((Object)("lookup table has " + this.lookup.size() + " features while feature list has " + this.features.size() + " features"));
        }
        for (SimpleFeature feature : this.features) {
            SimpleFeature lookupFeature = this.lookup.get(feature.getID());
            if (this.lookup == null) {
                throw new AssertionError((Object)("Lookup table is missing " + feature));
            }
            if (lookupFeature != feature) {
                throw new AssertionError((Object)("Lookup table contains: " + lookupFeature + " while feature list contains" + feature + ".  They are" + " not the same instance"));
            }
        }
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> deleteSelection() {
        SimpleFeatureCollection deletedFeatures = FeatureCollections.newCollection();
        Runnable updateTable = new Runnable((FeatureCollection)deletedFeatures){
            private final /* synthetic */ FeatureCollection val$deletedFeatures;
            {
                this.val$deletedFeatures = featureCollection;
            }

            @Override
            public void run() {
                Collection<String> selectionFids = FeatureTableContentProvider.this.owningFeatureTableControl.getSelectionProvider().getSelectionFids();
                Iterator<SimpleFeature> iter = FeatureTableContentProvider.this.features.iterator();
                while (iter.hasNext()) {
                    SimpleFeature feature = iter.next();
                    if (!selectionFids.contains(feature.getID())) continue;
                    this.val$deletedFeatures.add((Feature)feature);
                    iter.remove();
                    FeatureTableContentProvider.this.lookup.remove(feature.getID());
                }
                selectionFids.clear();
                FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getTable().clearAll();
            }
        };
        if (Display.getCurrent() == null) {
            PlatformGIS.syncInDisplayThread(this.owningFeatureTableControl.getControl().getDisplay(), updateTable);
        } else {
            updateTable.run();
        }
        return deletedFeatures;
    }

    private class ContentLoader
    implements ISafeRunnable {
        private final FeatureCollection<SimpleFeatureType, SimpleFeature> input;

        public ContentLoader(FeatureCollection<SimpleFeatureType, SimpleFeature> input) {
            this.input = input;
        }

        public void handleException(Throwable exception) {
            UiPlugin.log("Error loading features", exception);
        }

        public void run() throws Exception {
            if (this.cancel()) {
                return;
            }
            UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "Starting ContentLoader", null);
            this.setEnabled(false);
            int i = 0;
            int[] monitorUpdate = new int[]{0};
            boolean updated = false;
            long start = System.currentTimeMillis();
            FeatureIterator iterator = null;
            try {
                iterator = this.input.features();
                while (iterator.hasNext()) {
                    if (System.currentTimeMillis() - start > 500L) {
                        if (!updated) {
                            updated = true;
                            this.updateTable(this.input, false);
                        }
                        start = System.currentTimeMillis();
                        this.updateMonitor(i, monitorUpdate);
                    }
                    if (this.cancel()) {
                        return;
                    }
                    try {
                        SimpleFeature next = (SimpleFeature)iterator.next();
                        FeatureTableContentProvider.this.features.add(next);
                        FeatureTableContentProvider.this.lookup.put(next.getID(), next);
                        ++i;
                    }
                    catch (OutOfMemoryError error) {
                        this.error(this.input, String.valueOf(i) + " " + Messages.FeatureTableContentProvider_outOfMemory, true);
                        UiPlugin.log("Out of memory error in table view", error);
                        return;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(this.input, String.valueOf(Messages.FeatureTableContentProvider_unexpectedErro) + " " + Messages.FeatureTableContentProvider_probablecharseterror, false);
                        UiPlugin.log("error loading features in table view", e);
                        return;
                    }
                    catch (Throwable t) {
                        this.error(this.input, String.valueOf(Messages.FeatureTableContentProvider_unexpectedErro) + t.getLocalizedMessage(), false);
                        UiPlugin.log("error loading features in table view", t);
                        return;
                    }
                }
            }
            finally {
                if (iterator != null) {
                    this.input.close(iterator);
                }
                UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "Ending ContentLoader, Cancel state is:" + FeatureTableContentProvider.this.monitor.isCanceled(), null);
            }
            if (!this.cancel()) {
                this.updateTable(this.input, true);
                this.setEnabled(true);
            }
        }

        private void error(FeatureCollection<SimpleFeatureType, SimpleFeature> input, final String string, boolean clearFeatures) {
            UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "ContentLoader#error: Error occurred in ContentLoader:\n" + string, null);
            final Display display = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureTableContentProvider.this.monitor.setCanceled(true);
                }
            });
            this.done();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureTableContentProvider.this.owningFeatureTableControl.message(string, display.getSystemColor(29), display.getSystemColor(28));
                }
            });
        }

        private void updateMonitor(int i, final int[] monitorUpdate) {
            final int j = i;
            FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureTableContentProvider.this.monitor.subTask(String.valueOf(Messages.FeatureTableContentProvider_loadedFeatures) + j);
                    FeatureTableContentProvider.this.monitor.worked(j - monitorUpdate[0]);
                    monitorUpdate[0] = j;
                }
            });
        }

        private void setEnabled(final boolean enabled) {
            Table control = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getTable();
            final int size = !enabled ? this.input.size() : -1;
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "ContentLoader#setEnabled():" + enabled, null);
                    if (enabled) {
                        ContentLoader.this.done();
                    } else {
                        FeatureTableContentProvider.this.monitor.beginTask(String.valueOf(Messages.FeatureTableControl_loading1) + ((SimpleFeatureType)ContentLoader.this.input.getSchema()).getName().getLocalPart() + Messages.FeatureTableControl_loading2, size + 1);
                        FeatureTableContentProvider.this.monitor.worked(1);
                    }
                }
            });
        }

        private void done() {
            final Table control = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getTable();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "ContentLoader#done()|run():", null);
                    FeatureTableContentProvider.this.monitor.done();
                    FeatureTableContentProvider featureTableContentProvider = FeatureTableContentProvider.this;
                    synchronized (featureTableContentProvider) {
                        FeatureTableContentProvider.this.monitor = NULL;
                        FeatureTableContentProvider.this.notifyAll();
                        if (!control.isDisposed()) {
                            control.getVerticalBar().setEnabled(true);
                        }
                        if (control.getItemCount() > 0) {
                            FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().replace((Object)((ContentLoader)ContentLoader.this).FeatureTableContentProvider.this.features.get(0), 0);
                        }
                        FeatureTableContentProvider.this.owningFeatureTableControl.notifyLoadingListeners(new LoadingEvent(FeatureTableContentProvider.this.monitor.isCanceled(), null, false));
                    }
                }
            };
            if (Display.getCurrent() != control.getDisplay()) {
                control.getDisplay().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }

        private void updateTable(FeatureCollection<SimpleFeatureType, SimpleFeature> newInput, final boolean done) {
            final Table table = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getTable();
            table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiPlugin.trace("net.refractions.udig.ui/debug/featuretable", FeatureTableContentProvider.class, "ContentLoader#updateTable(): done=" + done, null);
                    FeatureTableContentProvider.this.owningFeatureTableControl.message(null);
                    int size = ((ContentLoader)ContentLoader.this).FeatureTableContentProvider.this.features.size();
                    FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().setItemCount(size);
                    if (!done && !table.isDisposed()) {
                        table.getVerticalBar().setEnabled(false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancel() {
            FeatureTableContentProvider featureTableContentProvider = FeatureTableContentProvider.this;
            synchronized (featureTableContentProvider) {
                block4: {
                    if (!FeatureTableContentProvider.this.monitor.isCanceled() && !PlatformUI.getWorkbench().isClosing()) break block4;
                    this.done();
                    return true;
                }
                return false;
            }
        }
    }

    private class ContentUpdater
    implements ISafeRunnable {
        private FeatureCollection<SimpleFeatureType, SimpleFeature> newFeatures;
        private int loaded = 0;

        public ContentUpdater(FeatureCollection<SimpleFeatureType, SimpleFeature> features2) {
            this.newFeatures = features2;
        }

        public void handleException(Throwable exception) {
            UiPlugin.log("Exception while updating the features in the FeatureTableControl", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            FeatureTableContentProvider featureTableContentProvider = FeatureTableContentProvider.this;
            synchronized (featureTableContentProvider) {
                FeatureTableContentProvider.this.updating = true;
                if (FeatureTableContentProvider.this.monitor != NULL) {
                    try {
                        PlatformGIS.wait(500L, -1L, new WaitCondition(){

                            @Override
                            public boolean isTrue() {
                                return FeatureTableContentProvider.this.monitor == NULL;
                            }
                        }, FeatureTableContentProvider.this);
                    }
                    catch (InterruptedException e) {
                        UiPlugin.log("Interrupted", e);
                        return;
                    }
                }
                this.startLoading();
                SimpleFeatureType schema = (SimpleFeatureType)this.newFeatures.getSchema();
                FeatureIterator iter = this.newFeatures.features();
                try {
                    boolean featuresWereAdded = false;
                    while (iter.hasNext()) {
                        if (FeatureTableContentProvider.this.monitor.isCanceled()) break;
                        SimpleFeature newValue = (SimpleFeature)iter.next();
                        SimpleFeature oldValue = FeatureTableContentProvider.this.findFeature(newValue.getID());
                        if (oldValue == null) {
                            featuresWereAdded = true;
                            FeatureTableContentProvider.this.features.add(newValue);
                            FeatureTableContentProvider.this.lookup.put(newValue.getID(), newValue);
                        } else {
                            int i = 0;
                            while (i < schema.getAttributeCount()) {
                                oldValue.setAttribute(i, newValue.getAttribute(i));
                                ++i;
                            }
                        }
                        ++this.loaded;
                        this.updateMonitor(String.valueOf(this.loaded) + Messages.FeatureTableContentProvider_updatingFeatures);
                    }
                    this.updateTable(featuresWereAdded);
                }
                finally {
                    iter.close();
                }
            }
        }

        private void updateTable(final boolean featuresWereAdded) {
            final Table table = FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().getTable();
            table.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (featuresWereAdded) {
                        ContentUpdater.this.updateMonitor(Messages.FeatureTableContentProvider_sortTable);
                        FeatureTableContentProvider.this.owningFeatureTableControl.sort(false);
                        FeatureTableContentProvider.this.owningFeatureTableControl.getViewer().setItemCount(((ContentUpdater)ContentUpdater.this).FeatureTableContentProvider.this.features.size());
                    } else {
                        table.clearAll();
                    }
                    FeatureTableContentProvider.this.monitor.done();
                    boolean cancelled = FeatureTableContentProvider.this.monitor.isCanceled();
                    FeatureTableContentProvider.this.monitor = NULL;
                    FeatureTableContentProvider.this.updating = false;
                    FeatureTableContentProvider featureTableContentProvider = FeatureTableContentProvider.this;
                    synchronized (featureTableContentProvider) {
                        FeatureTableContentProvider.this.notifyAll();
                    }
                    FeatureTableContentProvider.this.owningFeatureTableControl.notifyLoadingListeners(new LoadingEvent(cancelled, null, false));
                }
            });
        }

        private void updateMonitor(final String subTask) {
            Display display = FeatureTableContentProvider.this.owningFeatureTableControl.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureTableContentProvider.this.monitor.subTask(subTask);
                    FeatureTableContentProvider.this.monitor.worked(1);
                }
            });
        }

        private void startLoading() {
            Display display = FeatureTableContentProvider.this.owningFeatureTableControl.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FeatureTableContentProvider.this.owningFeatureTableControl.notifyLoadingListeners(new LoadingEvent(false, FeatureTableContentProvider.this.monitor, true));
                    FeatureTableContentProvider.this.monitor = (IProgressMonitor)FeatureTableContentProvider.this.progressMonitorProvider.get(new Object[0]);
                    FeatureTableContentProvider.this.monitor.setCanceled(false);
                    FeatureTableContentProvider.this.monitor.beginTask(Messages.FeatureTableContentProvider_updateTaskName, -1);
                }
            });
        }
    }
}

