/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.refractions.udig.ui.IBlockingSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureCollectionSelection
implements IStructuredSelection,
IBlockingSelection {
    Collection<Iterator> openIterators = new ArrayList<Iterator>();
    FeatureCollection<SimpleFeatureType, SimpleFeature> wrapped;
    private volatile SimpleFeature firstElement;

    public FeatureCollectionSelection(FeatureCollection<SimpleFeatureType, SimpleFeature> selectedFeatures) {
        this.wrapped = selectedFeatures;
    }

    protected void finalize() throws Throwable {
        for (Iterator iterator : this.openIterators) {
            this.wrapped.close(iterator);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirstElement() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("SimpleFeature Collection is empty, there is no first element");
        }
        if (this.firstElement == null) {
            FeatureCollectionSelection featureCollectionSelection = this;
            synchronized (featureCollectionSelection) {
                if (this.firstElement == null) {
                    FeatureIterator iter = this.wrapped.features();
                    try {
                        this.firstElement = (SimpleFeature)iter.next();
                    }
                    finally {
                        iter.close();
                    }
                }
            }
        }
        return this.firstElement;
    }

    public Iterator iterator() {
        Iterator iter = this.wrapped.iterator();
        this.openIterators.add(iter);
        return iter;
    }

    public int size() {
        return this.wrapped.size();
    }

    public Object[] toArray() {
        return this.toList().toArray();
    }

    public List toList() {
        if (this.wrapped instanceof List) {
            return (List)this.wrapped;
        }
        LinkedList arrayList = new LinkedList();
        Iterator iter = this.wrapped.iterator();
        try {
            while (iter.hasNext()) {
                arrayList.add(iter.next());
            }
        }
        finally {
            this.wrapped.close(iter);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }
}

