/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.io.Serializable;
import java.util.Comparator;
import org.opengis.feature.simple.SimpleFeature;

public class FIDComparator
implements Comparator<SimpleFeature>,
Serializable {
    private static final long serialVersionUID = 6541004741916267811L;
    private int dir;

    public FIDComparator(int dir) {
        if (dir == 128) {
            this.dir = -1;
        } else if (dir == 1024) {
            this.dir = 1;
        } else {
            throw new IllegalArgumentException("dir must be SWT.UP or SWT.DOWN was: " + dir);
        }
    }

    @Override
    public int compare(SimpleFeature o1, SimpleFeature o2) {
        String id1 = o1.getID();
        String id2 = o2.getID();
        int i = 1;
        while (i < id2.length() && i < id1.length() && id2.regionMatches(0, id1, 0, i)) {
            ++i;
        }
        String diff1 = id1.substring(i - 1);
        String diff2 = id2.substring(i - 1);
        try {
            Integer num1 = Integer.valueOf(diff1);
            Integer num2 = Integer.valueOf(diff2);
            return this.dir * num1.compareTo(num2);
        }
        catch (NumberFormatException numberFormatException) {
            return this.dir * id1.compareTo(id2);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.dir;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FIDComparator other = (FIDComparator)obj;
        return this.dir == other.dir;
    }
}

