/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorManager {
    private static final ErrorManager instance = new ErrorManager();

    private ErrorManager() {
    }

    public static ErrorManager get() {
        return instance;
    }

    public void displayError(final String title, final String message) {
        PlatformGIS.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public void displayException(Throwable exception, String message, String pluginID) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        exceptions.add(exception);
        this.displayExceptions(exceptions, message, pluginID);
    }

    public void displayExceptions(List<Throwable> exceptions, String message, String pluginID) {
        final String m = message == null ? "" : message;
        final MultiStatus multi = new MultiStatus(pluginID, 0, message, null);
        for (Throwable exception : exceptions) {
            Status status = new Status(4, pluginID, 4, exception.getLocalizedMessage(), exception);
            multi.add((IStatus)status);
        }
        PlatformGIS.syncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                ErrorDialog dialog = new ErrorDialog(Display.getDefault().getActiveShell(), Messages.ErrorManager_very_informative_error, m, (IStatus)multi, 4);
                dialog.open();
            }
        });
    }
}

