/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DisplayErrorCellListener
implements ICellEditorListener {
    private CellEditor editor;
    private Color validBackgroundColor;
    private Color validForegroundColor;

    public DisplayErrorCellListener(CellEditor editor) {
        this.editor = editor;
    }

    public void applyEditorValue() {
        this.setStatusLineMessage(false, true);
        this.setEditorBackground(false, true);
    }

    public void cancelEditor() {
        this.setStatusLineMessage(false, true);
        this.setEditorBackground(false, true);
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        this.setStatusLineMessage(oldValidState, newValidState);
        this.setEditorBackground(oldValidState, newValidState);
    }

    private void setEditorBackground(boolean oldValidState, boolean newValidState) {
        if (oldValidState == newValidState) {
            return;
        }
        Control control = this.editor.getControl();
        if (control == null) {
            return;
        }
        if (oldValidState) {
            if (this.validBackgroundColor == null) {
                this.validBackgroundColor = control.getBackground();
            }
            if (this.validBackgroundColor == null) {
                this.validForegroundColor = control.getForeground();
            }
        }
        if (newValidState) {
            if (this.validBackgroundColor == null) {
                control.setBackground(Display.getCurrent().getSystemColor(25));
            } else {
                control.setBackground(this.validBackgroundColor);
            }
            if (this.validForegroundColor == null) {
                control.setForeground(Display.getCurrent().getSystemColor(2));
            } else {
                control.setForeground(this.validBackgroundColor);
            }
        } else {
            control.setBackground(Display.getCurrent().getSystemColor(3));
            control.setForeground(Display.getCurrent().getSystemColor(1));
        }
    }

    private void setStatusLineMessage(boolean oldValidState, boolean newValidState) {
        IActionBars actionBars;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return;
        }
        if (activePart instanceof IViewPart) {
            actionBars = ((IViewPart)activePart).getViewSite().getActionBars();
        } else if (activePart instanceof IEditorPart) {
            actionBars = ((IEditorPart)activePart).getEditorSite().getActionBars();
        } else {
            return;
        }
        if (newValidState) {
            actionBars.getStatusLineManager().setErrorMessage(null);
        } else {
            actionBars.getStatusLineManager().setErrorMessage(this.editor.getErrorMessage());
        }
    }
}

