/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DecoratorOverlayIcon
extends CompositeImageDescriptor {
    static final Point DEFAULT_SIZE = new Point(22, 16);
    private Image base;
    private ImageDescriptor[] overlays;
    private Point size;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int UNDERLAY = 4;

    public DecoratorOverlayIcon(Image baseImage, ImageDescriptor[] overlaysArray) {
        this.base = baseImage;
        this.overlays = new ImageDescriptor[overlaysArray.length];
        int i = overlaysArray.length;
        this.overlays = new ImageDescriptor[i];
        System.arraycopy(overlaysArray, 0, this.overlays, 0, i);
        Rectangle bounds = baseImage.getBounds();
        this.size = new Point(bounds.width, bounds.height);
    }

    public DecoratorOverlayIcon(Image baseImage, ImageDescriptor[] overlaysArray, Point sizeValue) {
        this.base = baseImage;
        int i = 0;
        if (overlaysArray != null) {
            i = overlaysArray.length;
        }
        this.overlays = new ImageDescriptor[i];
        System.arraycopy(overlaysArray, 0, this.overlays, 0, i);
        this.size = sizeValue;
    }

    protected void drawOverlays(ImageDescriptor[] overlaysArray) {
        int i = 0;
        while (i < this.overlays.length) {
            ImageDescriptor overlay = overlaysArray[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.size.y - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.size.x - overlayData.width, this.size.y - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DecoratorOverlayIcon)) {
            return false;
        }
        DecoratorOverlayIcon other = (DecoratorOverlayIcon)((Object)o);
        return this.base.equals((Object)other.base) && Arrays.equals(this.overlays, other.overlays);
    }

    public int hashCode() {
        int code = this.base.hashCode();
        int i = 0;
        while (i < this.overlays.length) {
            if (this.overlays[i] != null) {
                code ^= this.overlays[i].hashCode();
            }
            ++i;
        }
        return code;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay = this.overlays[4];
        if (underlay != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        this.drawImage(this.base.getImageData(), 0, 0);
        this.drawOverlays(this.overlays);
    }

    protected Point getSize() {
        return this.size;
    }
}

