/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.ui;

import net.refractions.udig.ui.internal.Messages;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.geotools.feature.type.Types;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class AttributeValidator
implements ICellEditorValidator {
    private final AttributeDescriptor attributeDescriptor;
    private final SimpleFeatureType featureType;
    private Object[] values;
    private int indexof;

    public AttributeValidator(AttributeDescriptor attributeType, SimpleFeatureType featureType) {
        this.attributeDescriptor = attributeType;
        this.featureType = featureType;
        this.values = new Object[featureType.getAttributeCount()];
        int i = 0;
        while (i < featureType.getAttributeCount()) {
            AttributeDescriptor attributeType2 = featureType.getDescriptor(i);
            if (attributeType2 == attributeType) {
                this.indexof = i;
            }
            this.values[i] = attributeType2.getDefaultValue();
            ++i;
        }
    }

    public String isValid(Object value) {
        if (value == null || value instanceof String && ((String)value).equals("")) {
            if (!this.attributeDescriptor.isNillable()) {
                return String.valueOf(Messages.AttributeValidator_missingAtt1) + this.attributeDescriptor.getName() + Messages.AttributeValidator_missingAtt2;
            }
            return null;
        }
        if (!this.attributeDescriptor.getType().getBinding().isAssignableFrom(value.getClass())) {
            return String.valueOf(Messages.AttributeValidator_wrongType) + this.attributeDescriptor.getType().getBinding().getSimpleName();
        }
        try {
            Types.validate((AttributeDescriptor)this.attributeDescriptor, (Object)value);
            return null;
        }
        catch (Throwable e) {
            return e.getLocalizedMessage();
        }
    }
}

