/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.ui.internal.Messages;
import net.refractions.udig.ui.operations.OpAction;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class OperationMenuFactory {
    List<IConfigurationElement> extensionPoints;
    private MenuManager contextManager;
    private ArrayList<OpAction> actions = new ArrayList();
    private Map<String, OperationCategory> categories = new HashMap<String, OperationCategory>();
    private MenuManager menuManager;
    private IWorkbenchWindow window;

    public OperationMenuFactory() {
        this.extensionPoints = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.ui.operation");
        this.createActionList(this.extensionPoints);
    }

    public MenuManager getContextMenu(ISelection selection) {
        this.contextManager = this.createMenuManager();
        Iterator<OperationCategory> iter = this.getCategories().values().iterator();
        while (iter.hasNext()) {
            OperationCategory category = iter.next();
            for (OpAction action : category.getActions()) {
                if (selection instanceof IStructuredSelection) {
                    action.updateEnablement((IStructuredSelection)selection, true);
                }
                if (!action.isEnabled()) continue;
                this.contextManager.add((IAction)action);
            }
            if (!iter.hasNext()) continue;
            this.contextManager.add((IContributionItem)new Separator());
        }
        if (this.getActions().size() != 0) {
            this.contextManager.add((IContributionItem)new Separator());
        }
        for (OpAction action : this.getActions()) {
            if (selection instanceof IStructuredSelection) {
                action.updateEnablement((IStructuredSelection)selection, true);
            }
            if (!action.isEnabled()) continue;
            this.contextManager.add((IAction)action);
        }
        return this.contextManager;
    }

    public MenuManager getMenu() {
        if (this.menuManager == null) {
            this.menuManager = new MenuManager(this.getMenuText());
            for (OperationCategory category : this.categories.values()) {
                if (category.getItems().length <= 0) continue;
                this.menuManager.add((IContributionItem)category);
            }
            for (OpAction action : this.actions) {
                this.menuManager.add((IAction)action);
            }
            this.menuManager.add((IContributionItem)new GroupMarker("additions"));
        }
        return this.menuManager;
    }

    public void add() {
        this.menuManager.update();
    }

    private void createActionList(List<IConfigurationElement> list) {
        for (IConfigurationElement element : list) {
            try {
                if (!element.getName().equals("category")) continue;
                this.categories.put(element.getAttribute("id"), new OperationCategory(element));
            }
            catch (Exception e) {
                UiPlugin.log(null, e);
            }
        }
        for (IConfigurationElement element : list) {
            OperationCategory category;
            if (element.getName().equals("category")) continue;
            OpAction action = new OpAction(element);
            if (this.window != null) {
                this.window.getSelectionService().addSelectionListener((ISelectionListener)action);
            }
            if ((category = this.categories.get(element.getAttribute("categoryId"))) != null) {
                category.add((IAction)action);
                continue;
            }
            this.actions.add(action);
            if (element.getAttribute("categoryId") == null || element.getAttribute("categoryId").length() == 0) continue;
            UiPlugin.log("Action '" + action.getText() + "' references invalid category '" + element.getAttribute("categoryId") + "'.", null);
        }
    }

    public void contributeActions(IMenuManager menuBar) {
        for (OperationCategory category : this.categories.values()) {
            for (OpAction action : category.getActions()) {
                this.addActionToMenu(menuBar, action);
            }
        }
        for (OpAction action : this.actions) {
            this.addActionToMenu(menuBar, action);
        }
    }

    private void addActionToMenu(IMenuManager menuBar, OpAction action) {
        if (action.getMenuPath() != null) {
            try {
                String[] paths = action.getMenuPath().split("/");
                IMenuManager manager = menuBar.findMenuUsingPath("additions");
                if (manager == null) {
                    manager = menuBar;
                }
                String markerID = null;
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    markerID = null;
                    IContributionItem item = manager.findUsingPath(path);
                    if (item == null) {
                        UiPlugin.log(String.valueOf(action.getMenuPath()) + " is not a valid menuPath", null);
                        break;
                    }
                    if (item instanceof IMenuManager) {
                        manager = (IMenuManager)item;
                    } else if (item.isGroupMarker()) {
                        markerID = item.getId();
                    } else if (item instanceof SubContributionItem) {
                        if ((item = ((SubContributionItem)item).getInnerItem()) instanceof IMenuManager) {
                            manager = (IMenuManager)item;
                        } else if (item.isGroupMarker()) {
                            markerID = item.getId();
                        }
                    }
                    ++n2;
                }
                if (manager != null) {
                    if (markerID != null) {
                        manager.appendToGroup(markerID, (IAction)action);
                    } else {
                        manager.add((IAction)action);
                    }
                } else {
                    UiPlugin.log(String.valueOf(action.getMenuPath()) + " is not a valid menuPath", null);
                }
            }
            catch (Exception e) {
                UiPlugin.log("Error adding operation to menu", e);
            }
        }
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void setWindow(IWorkbenchWindow window) {
        IWorkbenchWindow oldwindow = this.window;
        this.window = window;
        Collection<OperationCategory> cat = this.categories.values();
        for (OperationCategory category : cat) {
            List<OpAction> catActions = category.getActions();
            for (OpAction action : catActions) {
                if (window != null) {
                    window.getSelectionService().addSelectionListener((ISelectionListener)action);
                }
                if (oldwindow == null) continue;
                oldwindow.getSelectionService().removeSelectionListener((ISelectionListener)action);
            }
        }
        for (OpAction action : this.actions) {
            if (window != null) {
                window.getSelectionService().addSelectionListener((ISelectionListener)action);
            }
            if (oldwindow == null) continue;
            oldwindow.getSelectionService().removeSelectionListener((ISelectionListener)action);
        }
    }

    public List<OpAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public Map<String, OperationCategory> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    private String getMenuText() {
        return Messages.OperationMenuFactory_menu_text;
    }

    public MenuManager createMenuManager() {
        return new MenuManager(this.getMenuText(), "analysis");
    }

    public OperationCategory findCategory(String categoryId) {
        return this.getCategories().get(categoryId);
    }

    public OpAction find(String actionId) {
        for (OpAction action : this.getActions()) {
            if (!action.getId().equals(actionId)) continue;
            return action;
        }
        for (OperationCategory category : this.getCategories().values()) {
            for (OpAction action : category.actions) {
                if (!action.getId().equals(actionId)) continue;
                return action;
            }
        }
        return null;
    }

    public void addWorkbenchMenus(IMenuService menuService) {
        String locationURI = "menu:org.eclipse.ui.main.menu?after=additions";
        menuService.addContributionFactory(new AbstractContributionFactory(locationURI, null){

            public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
                additions.addContributionItem((IContributionItem)OperationMenuFactory.this.getMenu(), Expression.TRUE);
            }
        });
        locationURI = "menu:edit?after=additions";
        menuService.addContributionFactory(new AbstractContributionFactory(locationURI, null){

            public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
                for (OpAction action : OperationMenuFactory.this.getActions()) {
                    ActionContributionItem item = new ActionContributionItem((IAction)action);
                    Expression visibleWhen = Expression.TRUE;
                    additions.addContributionItem((IContributionItem)item, visibleWhen);
                }
            }
        });
    }

    public List<IContributionItem> createContributionItems(String categoryId) {
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        OperationCategory category = this.findCategory(categoryId);
        if (category == null || category.getActions().isEmpty()) {
            return items;
        }
        List<OpAction> actions = category.getActions();
        for (OpAction action : actions) {
            if (action == null) continue;
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.setVisible(true);
            items.add((IContributionItem)item);
        }
        return items;
    }
}

