/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.internal.ui.operations.OperationMenuFactory;
import net.refractions.udig.ui.operations.OpAction;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class OperationContentProvider
implements ITreeContentProvider {
    private Map childMap = new HashMap();

    public void dispose() {
        this.childMap.clear();
    }

    public Object[] getChildren(Object element) {
        Object[] children = (Object[])this.childMap.get(element);
        if (children == null) {
            children = this.createChildren(element);
            this.childMap.put(element, children);
        }
        return children;
    }

    private Object[] createChildren(Object element) {
        List<OpAction> actionList;
        OpAction[] actions;
        if (element instanceof OperationMenuFactory) {
            OperationMenuFactory opMenuFactory = (OperationMenuFactory)element;
            Map<String, OperationCategory> categoriesMap = opMenuFactory.getCategories();
            ArrayList<Object> filtered = new ArrayList<Object>();
            for (OperationCategory category : categoriesMap.values()) {
                if (!this.hasChildren((Object)category)) continue;
                filtered.add((Object)category);
            }
            filtered.addAll(opMenuFactory.getActions());
            Object[] topLevelElements = filtered.toArray(new Object[filtered.size()]);
            if (topLevelElements.length == 1) {
                return this.getChildren(topLevelElements[0]);
            }
            return topLevelElements;
        }
        if (element instanceof OperationCategory && (actions = (actionList = ((OperationCategory)((Object)element)).getActions()).toArray(new OpAction[actionList.size()])) != null) {
            ArrayList<OpAction> filtered = new ArrayList<OpAction>();
            int i = 0;
            while (i < actions.length) {
                OpAction action = actions[i];
                if (action.isEnabled() && !WorkbenchActivityHelper.filterItem((Object)((Object)action))) {
                    filtered.add(action);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof OperationMenuFactory) {
            return true;
        }
        return element instanceof OperationCategory && this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childMap.clear();
    }
}

