/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class UDigByteAndLocalTransfer
extends ByteArrayTransfer
implements UDIGTransfer {
    private static UDigByteAndLocalTransfer _instance = new UDigByteAndLocalTransfer();
    static final String CFSTR_INETURL = "InternalObject";
    private static final int CFSTR_INETURLID = Transfer.registerType((String)"InternalObject");
    private long startTime;
    public Object object;

    public boolean isSupportedType(TransferData transferData) {
        return super.isSupportedType(transferData);
    }

    public static UDigByteAndLocalTransfer getInstance() {
        return _instance;
    }

    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLID};
    }

    public String[] getTypeNames() {
        return new String[]{CFSTR_INETURL};
    }

    public TransferData[] getSupportedTypes() {
        return super.getSupportedTypes();
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        this.startTime = System.currentTimeMillis();
        if (object instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)object;
            ArrayList elements = new ArrayList();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                elements.add(iter.next());
            }
            this.object = elements.toArray();
        }
        this.object = object;
        if (transferData != null) {
            super.javaToNative((Object)String.valueOf(this.startTime).getBytes(), transferData);
        }
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        try {
            long startTime = Long.valueOf(new String(bytes));
            return this.startTime == startTime ? this.object : null;
        }
        catch (NumberFormatException numberFormatException) {
            InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(bytes));
            StringBuffer buf = new StringBuffer();
            char[] chars = new char[bytes.length / 2];
            int read = 0;
            try {
                read = reader.read(chars);
            }
            catch (IOException e) {
                UiPlugin.log("Error reading transfer data", e);
            }
            buf.append(chars, 0, read);
            return buf.toString().trim();
        }
    }

    @Override
    public boolean validate(Object object) {
        return true;
    }
}

