/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.internal.ui.UDIGDNDProcessor;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.IDropHandlerListener;
import net.refractions.udig.ui.ProgressMonitorTaskNamer;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import net.refractions.udig.ui.ViewerDropLocation;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;

public class UDIGDropHandler
extends DropTargetAdapter {
    private static final CompositeDropActionJob actionJob = new CompositeDropActionJob();
    private Object target;
    private ViewerDropLocation location = ViewerDropLocation.ON;
    private Set<IDropHandlerListener> listeners = new CopyOnWriteArraySet<IDropHandlerListener>();

    public void setTarget(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setViewerLocation(ViewerDropLocation location) {
        this.location = location;
    }

    public ViewerDropLocation getViewerLocation() {
        return this.location;
    }

    public void dragLeave(DropTargetEvent event) {
        super.dragLeave(event);
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
        if ((event.operations & 4) == 4) {
            event.detail = 4;
        } else if ((event.operations & 2) == 2) {
            event.detail = 2;
        } else if ((event.operations & 1) == 1) {
            event.detail = 1;
        }
    }

    public void dropAccept(DropTargetEvent event) {
        super.dropAccept(event);
    }

    private Object getJavaObject(Transfer transfer, TransferData data) {
        try {
            if (transfer instanceof UDIGTransfer) {
                return ((UDIGTransfer)transfer).nativeToJava(data);
            }
            Method m = transfer.getClass().getMethod("nativeToJava", TransferData.class);
            return m.invoke((Object)transfer, data);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void dragEnter(DropTargetEvent event) {
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/dnd")) {
            DropTarget target = (DropTarget)event.getSource();
            Control control = target.getControl();
            System.out.println("UDIGDropHandler.dragEnter " + control.toString() + ": Setting event.detail to COPY");
        }
        event.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/dnd")) {
            System.out.println("UDIGDropHandler.dragOperationChanged: Setting event.detail to COPY");
        }
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        Set<Transfer> t = UDIGDragDropUtilities.getTransfers();
        List<IDropAction> actions = null;
        block0: for (Transfer transfer : t) {
            TransferData[] types;
            if (event.data != null && !(actions = this.findDropActions(event.data, event)).isEmpty()) break;
            TransferData[] transferDataArray = types = transfer.getSupportedTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                TransferData data = transferDataArray[n2];
                if (transfer.isSupportedType(data) && (object = this.getJavaObject(transfer, data)) != null && !(actions = this.findDropActions(object, event)).isEmpty()) continue block0;
                ++n2;
            }
        }
        CompositeDropActionJob actionJob = UDIGDropHandler.getActionJob();
        if (actions != null && !actions.isEmpty()) {
            List<IDropAction> filteredActions = this.filterActions(event, actions);
            UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), "Target " + this.getTarget() + " found " + filteredActions.size() + " drop actions", null);
            for (IDropAction action : filteredActions) {
                UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), " * Action " + action.getName() + " implementation " + action.getClass().getSimpleName(), null);
            }
            actionJob.addActions(this, filteredActions);
        } else {
            UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), event.data + " dropped on " + this.getTarget() + " found no actions for processing it", null);
            this.notifyNoDropAction(event.data);
        }
    }

    protected List<IDropAction> filterActions(DropTargetEvent event, List<IDropAction> actions) {
        return actions;
    }

    private List<IDropAction> findDropActions(Object data, DropTargetEvent event) {
        Object type;
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/dnd")) {
            type = data.getClass().getSimpleName();
            String value = data.getClass().isArray() ? String.valueOf(Array.getLength(data)) + " items" : data.toString();
            UiPlugin.trace("net.refractions.udig.ui/debug/dnd", UDIGDropHandler.class, "Find drop actions for " + (String)type + ": " + value, null);
        }
        type = data.getClass();
        Object[] objects = null;
        objects = ((Class)type).isArray() ? (Object[])data : (data instanceof Collection ? ((Collection)data).toArray() : (data instanceof IStructuredSelection ? ((IStructuredSelection)data).toArray() : new Object[]{data}));
        List<IDropAction> actions = UDIGDNDProcessor.process(objects, this, event);
        return actions;
    }

    public void performDrop(Object data, DropTargetEvent event) {
        if (UiPlugin.isDebugging("net.refractions.udig.ui/debug/dnd")) {
            System.out.println("PerformDrop called on " + data + "(" + data.getClass() + ")");
        }
        List<IDropAction> actions = this.findDropActions(data, event);
        CompositeDropActionJob actionJob = UDIGDropHandler.getActionJob();
        if (!actions.isEmpty()) {
            UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), data + " dropped on " + this.getTarget() + " found " + actions.size() + " drop actions", null);
            for (IDropAction action : actions) {
                UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), " * Action " + action.getName() + " implementation " + action.getClass().getSimpleName(), null);
            }
            actionJob.addActions(this, actions);
        } else {
            UiPlugin.trace("net.refractions.udig.ui/debug/dnd", ((Object)((Object)this)).getClass(), data + " dropped on " + this.getTarget() + " found no actions for processing it", null);
            this.notifyNoDropAction(data);
        }
    }

    private void notifyNoDropAction(Object object) {
        Set<IDropHandlerListener> set = this.listeners;
        for (IDropHandlerListener listener : set) {
            listener.noAction(object);
        }
    }

    public static CompositeDropActionJob getActionJob() {
        return actionJob;
    }

    public void removeListener(IDropHandlerListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(IDropHandlerListener listener) {
        this.listeners.add(listener);
    }

    public static class CompositeDropActionJob
    extends Job {
        private final Queue<Collection<DropActionRunnable>> queue = new ConcurrentLinkedQueue<Collection<DropActionRunnable>>();

        public CompositeDropActionJob() {
            super(Messages.UDIGDropHandler_jobName);
            this.setUser(true);
        }

        public synchronized List<Collection<DropActionRunnable>> getJobQueue() {
            return Collections.unmodifiableList(new ArrayList<Collection<DropActionRunnable>>(this.queue));
        }

        synchronized void addActions(UDIGDropHandler handler, Collection<IDropAction> actions) {
            ArrayList<DropActionRunnable> runnables = new ArrayList<DropActionRunnable>();
            for (IDropAction action : actions) {
                runnables.add(new DropActionRunnable(handler, action));
            }
            this.queue.offer(runnables);
            if (!actions.isEmpty()) {
                actionJob.schedule();
            }
        }

        public boolean belongsTo(Object family) {
            return family == CompositeDropActionJob.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor2) {
            monitor2.beginTask(Messages.UDIGDropHandler_performing_task, -1);
            while (!Thread.currentThread().isInterrupted()) {
                Collection<DropActionRunnable> next = null;
                CompositeDropActionJob compositeDropActionJob = this;
                synchronized (compositeDropActionJob) {
                    next = this.queue.poll();
                    if (next == null || Thread.currentThread().isInterrupted()) {
                        return Status.OK_STATUS;
                    }
                }
                boolean foundGoodAction = false;
                Iterator<DropActionRunnable> iterator = next.iterator();
                while (iterator.hasNext() && !foundGoodAction) {
                    DropActionRunnable action = iterator.next();
                    ProgressMonitorTaskNamer monitor = new ProgressMonitorTaskNamer(monitor2, 10);
                    monitor2.setTaskName(String.valueOf(Messages.UDIGDropHandler_performing_task) + ": " + action.action.getName());
                    if (action.run((IProgressMonitor)monitor).getCode() != 0) continue;
                    foundGoodAction = true;
                }
            }
            return Status.OK_STATUS;
        }
    }

    private static class DropActionRunnable {
        IDropAction action;
        UDIGDropHandler handler;

        public DropActionRunnable(UDIGDropHandler handler, IDropAction action) {
            this.handler = handler;
            this.action = action;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.notifyStart(this.action);
            try {
                this.action.perform(monitor);
                this.notifyDone(this.action, null);
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                String msg = Messages.UDIGDropHandler_error;
                String ns = this.action.getElement().getNamespaceIdentifier();
                Status s = new Status(2, ns, 0, msg, t);
                UiPlugin.getDefault().getLog().log((IStatus)s);
                this.notifyDone(this.action, t);
                return Status.CANCEL_STATUS;
            }
        }

        private void notifyDone(IDropAction action, Throwable t) {
            Set set = this.handler.listeners;
            for (IDropHandlerListener listener : set) {
                listener.done(action, t);
            }
        }

        private void notifyStart(IDropAction action) {
            Set set = this.handler.listeners;
            for (IDropHandlerListener listener : set) {
                listener.starting(action);
            }
        }
    }
}

