/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.internal.ui.AuthenticationDialog;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class UDIGAuthenticator
extends Authenticator {
    private static final String NAME = "NAME";
    private static final String PASSWORD = "PASSWORD";
    private static final String URL_AUTHENTICATION = "URL_AUTHENTICATION";
    private String username;
    private String password;
    private boolean storePassword;
    private Set<String> triedStoredForNodeKey = new HashSet<String>();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        final String[] name = new String[1];
        final String[] pass = new String[1];
        if (!this.isTriedStored()) {
            name[0] = this.loadName();
            pass[0] = this.loadPassword();
            this.setTriedStored(true);
        }
        if (name[0] == null && pass[0] == null) {
            PlatformGIS.syncInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    UDIGAuthenticator.this.promptForPassword();
                    name[0] = UDIGAuthenticator.this.username;
                    pass[0] = UDIGAuthenticator.this.password;
                }
            });
        }
        if (name[0] == null && pass[0] == null) {
            return null;
        }
        if (this.storePassword) {
            this.store(name[0], pass[0]);
        }
        return new PasswordAuthentication(name[0], pass[0].toCharArray());
    }

    private boolean isTriedStored() {
        try {
            return this.triedStoredForNodeKey.contains(this.getNodeKey());
        }
        catch (UnsupportedEncodingException e) {
            UiPlugin.log("", e);
            return false;
        }
    }

    private void setTriedStored(boolean mark) {
        try {
            if (mark) {
                this.triedStoredForNodeKey.add(this.getNodeKey());
            } else {
                this.triedStoredForNodeKey.remove(this.getNodeKey());
            }
        }
        catch (UnsupportedEncodingException e) {
            UiPlugin.log("", e);
        }
    }

    private void store(String name, String pass) {
        try {
            Preferences node = UiPlugin.getUserPreferences().node(this.getNodeKey());
            node.put(NAME, name);
            node.put(PASSWORD, pass);
        }
        catch (Exception e) {
            UiPlugin.log("", e);
        }
    }

    private String loadPassword() {
        String pass;
        block3: {
            try {
                Preferences node = UiPlugin.getUserPreferences().node(this.getNodeKey());
                pass = node.get(PASSWORD, null);
                if (pass != null) break block3;
                return null;
            }
            catch (Exception e) {
                UiPlugin.log("", e);
                return null;
            }
        }
        return pass;
    }

    private String getNodeKey() throws UnsupportedEncodingException {
        return URL_AUTHENTICATION + URLEncoder.encode(this.getRequestingURL().toString(), "UTF-8");
    }

    private String loadName() {
        try {
            Preferences node = UiPlugin.getUserPreferences().node(this.getNodeKey());
            return node.get(NAME, null);
        }
        catch (Exception e) {
            UiPlugin.log("", e);
            return null;
        }
    }

    protected void promptForPassword() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        AuthenticationDialog dialog = new AuthenticationDialog(shell);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 1) {
            this.username = null;
            this.password = null;
            return;
        }
        this.username = dialog.getUsername();
        if (this.username == null) {
            this.username = "";
        }
        this.password = dialog.getPassword();
        if (this.password == null) {
            this.password = "";
        }
        this.storePassword = dialog.shouldRemember();
    }
}

