/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import javax.xml.transform.TransformerException;
import net.refractions.udig.internal.ui.TransferStrategy;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.ui.AbstractTextStrategizedTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.geotools.gml.producer.GeometryTransformer;

public class GeometryTextTransfer
extends AbstractTextStrategizedTransfer
implements UDIGTransfer {
    private static GeometryTextTransfer _instance = new GeometryTextTransfer();
    private TransferStrategy[] transferStrategies;

    private GeometryTextTransfer() {
    }

    public static GeometryTextTransfer getInstance() {
        return _instance;
    }

    @Override
    public synchronized TransferStrategy[] getAllStrategies() {
        if (this.transferStrategies == null) {
            this.transferStrategies = new TransferStrategy[]{new JtsWktStrategy()};
        }
        TransferStrategy[] copy = new TransferStrategy[this.transferStrategies.length];
        System.arraycopy(this.transferStrategies, 0, copy, 0, this.transferStrategies.length);
        return copy;
    }

    @Override
    public String[] getStrategyNames() {
        return new String[]{"JTS WKT"};
    }

    @Override
    public String getTransferName() {
        return "Geometry";
    }

    @Override
    public TransferStrategy getDefaultStrategy() {
        return this.getAllStrategies()[0];
    }

    public TransferData[] getSupportedTypes() {
        return TextTransfer.getInstance().getSupportedTypes();
    }

    public boolean isSupportedType(TransferData transferData) {
        return TextTransfer.getInstance().isSupportedType(transferData);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Geometry;
    }

    public static class GMLStrategy
    implements TransferStrategy {
        @Override
        public void javaToNative(Object object, TransferData transferData) {
            Geometry geometry = (Geometry)object;
            GeometryTransformer transformer = new GeometryTransformer();
            transformer.setIndentation(2);
            try {
                TextTransfer.getInstance().javaToNative((Object)transformer.transform((Object)geometry), transferData);
            }
            catch (TransformerException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            return null;
        }
    }

    public static class JtsWktStrategy
    implements TransferStrategy {
        @Override
        public void javaToNative(Object object, TransferData transferData) {
            String geometry;
            Geometry feature = (Geometry)object;
            WKTWriter writer = new WKTWriter();
            String stringToEncode = geometry = writer.writeFormatted(feature);
            TextTransfer.getInstance().javaToNative((Object)stringToEncode, transferData);
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            String string = (String)TextTransfer.getInstance().nativeToJava(transferData);
            WKTReader reader = new WKTReader();
            try {
                return reader.read(string);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }
}

