/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.StringReader;
import javax.xml.transform.TransformerException;
import net.refractions.udig.internal.ui.TransferStrategy;
import net.refractions.udig.internal.ui.UDIGTransfer;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.ui.AbstractTextStrategizedTransfer;
import net.refractions.udig.ui.internal.Messages;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterFeature;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerFeature;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.gml.GMLReceiver;
import org.geotools.gml.producer.FeatureTransformer;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FeatureTextTransfer
extends AbstractTextStrategizedTransfer
implements UDIGTransfer {
    private static FeatureTextTransfer _instance = new FeatureTextTransfer();
    private TransferStrategy[] transferStrategies;

    private FeatureTextTransfer() {
    }

    public static FeatureTextTransfer getInstance() {
        return _instance;
    }

    @Override
    public synchronized TransferStrategy[] getAllStrategies() {
        if (this.transferStrategies == null) {
            this.transferStrategies = new TransferStrategy[]{new GMLStrategy(), new JtsWktStrategy()};
        }
        TransferStrategy[] copy = new TransferStrategy[this.transferStrategies.length];
        System.arraycopy(this.transferStrategies, 0, copy, 0, this.transferStrategies.length);
        return copy;
    }

    @Override
    public String[] getStrategyNames() {
        return new String[]{Messages.FeatureTextTransfer_strategy_gml_name, Messages.FeatureTextTransfer_strategy_wkt_name};
    }

    @Override
    public String getTransferName() {
        return Messages.FeatureTextTransfer_transfer_name;
    }

    @Override
    public TransferStrategy getDefaultStrategy() {
        return this.getAllStrategies()[0];
    }

    public TransferData[] getSupportedTypes() {
        return TextTransfer.getInstance().getSupportedTypes();
    }

    public boolean isSupportedType(TransferData transferData) {
        return TextTransfer.getInstance().isSupportedType(transferData);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof SimpleFeature;
    }

    public static class GMLStrategy
    implements TransferStrategy {
        @Override
        public void javaToNative(Object object, TransferData transferData) {
            SimpleFeature feature = (SimpleFeature)object;
            SimpleFeatureCollection collection = FeatureCollections.newCollection();
            collection.add((Feature)feature);
            FeatureTransformer transformer = new FeatureTransformer();
            transformer.setIndentation(4);
            try {
                TextTransfer.getInstance().javaToNative((Object)transformer.transform((Object)collection), transferData);
            }
            catch (TransformerException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            String string = (String)TextTransfer.getInstance().nativeToJava(transferData);
            InputSource input = new InputSource(new StringReader(string));
            SimpleFeatureCollection collection = FeatureCollections.newCollection();
            GMLReceiver receiver = new GMLReceiver(collection);
            GMLFilterFeature filterFeature = new GMLFilterFeature((GMLHandlerFeature)receiver);
            GMLFilterGeometry filterGeometry = new GMLFilterGeometry((GMLHandlerJTS)filterFeature);
            GMLFilterDocument filterDocument = new GMLFilterDocument((GMLHandlerGeometry)filterGeometry);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler((ContentHandler)filterDocument);
                reader.parse(input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return collection.features().next();
        }
    }

    public static class JtsWktStrategy
    implements TransferStrategy {
        @Override
        public void javaToNative(Object object, TransferData transferData) {
            String geometry;
            SimpleFeature feature = (SimpleFeature)object;
            WKTWriter writer = new WKTWriter();
            String stringToEncode = geometry = writer.writeFormatted((Geometry)feature.getDefaultGeometry());
            TextTransfer.getInstance().javaToNative((Object)stringToEncode, transferData);
        }

        @Override
        public Object nativeToJava(TransferData transferData) {
            String string = (String)TextTransfer.getInstance().nativeToJava(transferData);
            WKTReader reader = new WKTReader();
            try {
                Geometry read = reader.read(string);
                SimpleFeatureType ft = DataUtilities.createType((String)"Temp Type", (String)("*geom:" + read.getClass().getName()));
                return SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{read}, null);
            }
            catch (Exception e) {
                UiPlugin.log("", e);
                return null;
            }
        }
    }
}

