/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.aoi;

import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.operations.AbstractPropertyValue;
import net.refractions.udig.ui.operations.IOpFilterListener;
import net.refractions.udig.ui.operations.PropertyValue;

public class AOIStrategyPropertyValue
extends AbstractPropertyValue<Object>
implements PropertyValue<Object> {
    AOIListener watcher = new AOIListener(){

        @Override
        public void handleEvent(AOIListener.Event event) {
            AOIStrategyPropertyValue.this.notifyListeners(event);
        }
    };

    @Override
    public boolean isTrue(Object object, String value) {
        IAOIService aOIService = PlatformGIS.getAOIService();
        String name = aOIService.getProxy().getName();
        return name.equals(value);
    }

    @Override
    public boolean canCacheResult() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void addListener(IOpFilterListener listener) {
        super.addListener(listener);
        if (this.listeners.size() == 1) {
            IAOIService aOIService = PlatformGIS.getAOIService();
            aOIService.addListener(this.watcher);
        }
    }

    @Override
    public void removeListener(IOpFilterListener listener) {
        super.removeListener(listener);
        if (this.listeners.isEmpty()) {
            IAOIService aOIService = PlatformGIS.getAOIService();
            aOIService.removeListener(this.watcher);
        }
    }
}

